/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.PIndexScanParameters;
import com.apple.foundationdb.record.planprotos.PMultidimensionalIndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.MultidimensionalIndexScanBounds;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class MultidimensionalIndexScanComparisons
implements IndexScanParameters {
    @Nonnull
    private final ScanComparisons prefixScanComparisons;
    @Nonnull
    private final List<ScanComparisons> dimensionsScanComparisons;
    @Nonnull
    private final ScanComparisons suffixScanComparisons;

    public MultidimensionalIndexScanComparisons(@Nonnull ScanComparisons prefixScanComparisons, @Nonnull List<ScanComparisons> dimensionsScanComparisons, @Nonnull ScanComparisons suffixKeyComparisonRanges) {
        this.prefixScanComparisons = prefixScanComparisons;
        this.dimensionsScanComparisons = dimensionsScanComparisons;
        this.suffixScanComparisons = suffixKeyComparisonRanges;
    }

    @Override
    @Nonnull
    public IndexScanType getScanType() {
        return IndexScanType.BY_VALUE;
    }

    @Nonnull
    public ScanComparisons getPrefixScanComparisons() {
        return this.prefixScanComparisons;
    }

    @Nonnull
    public List<ScanComparisons> getDimensionsScanComparisons() {
        return this.dimensionsScanComparisons;
    }

    @Nonnull
    public ScanComparisons getSuffixScanComparisons() {
        return this.suffixScanComparisons;
    }

    @Override
    @Nonnull
    public MultidimensionalIndexScanBounds bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        ImmutableList.Builder dimensionsTupleRangeBuilder = ImmutableList.builder();
        for (ScanComparisons dimensionScanComparison : this.dimensionsScanComparisons) {
            dimensionsTupleRangeBuilder.add(dimensionScanComparison.toTupleRange(store, context));
        }
        MultidimensionalIndexScanBounds.Hypercube hypercube = new MultidimensionalIndexScanBounds.Hypercube((List<TupleRange>)((Object)dimensionsTupleRangeBuilder.build()));
        return new MultidimensionalIndexScanBounds(this.prefixScanComparisons.toTupleRange(store, context), hypercube, this.suffixScanComparisons.toTupleRange(store, context));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.prefixScanComparisons, this.dimensionsScanComparisons, this.suffixScanComparisons);
    }

    @Override
    public boolean isUnique(@Nonnull Index index) {
        return this.prefixScanComparisons.isEquality() && this.prefixScanComparisons.size() == index.getColumnSize();
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        TupleRange tupleRange = this.prefixScanComparisons.toTupleRangeWithoutContext();
        ExplainTokens prefix = tupleRange == null ? this.prefixScanComparisons.explain().getExplainTokens() : new ExplainTokens().addToString(tupleRange);
        ExplainTokens dimensions = new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> this.dimensionsScanComparisons.stream().map(dimensionScanComparisons -> {
            TupleRange dimensionTupleRange = dimensionScanComparisons.toTupleRangeWithoutContext();
            return dimensionTupleRange == null ? dimensionScanComparisons.explain().getExplainTokens() : new ExplainTokens().addToString(dimensionTupleRange);
        }).iterator());
        tupleRange = this.suffixScanComparisons.toTupleRangeWithoutContext();
        ExplainTokens suffix = tupleRange == null ? this.suffixScanComparisons.explain().getExplainTokens() : new ExplainTokens().addToString(tupleRange);
        return ExplainTokensWithPrecedence.of(prefix.addOptionalWhitespace().addToString(":{").addOptionalWhitespace().addNested(dimensions).addOptionalWhitespace().addToString("}:").addOptionalWhitespace().addNested(suffix));
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        TupleRange tupleRange = this.prefixScanComparisons.toTupleRangeWithoutContext();
        if (tupleRange != null) {
            detailsBuilder.add((Object)("prefix: " + tupleRange.getLowEndpoint().toString(false) + "{{plow}}, {{phigh}}" + tupleRange.getHighEndpoint().toString(true)));
            attributeMapBuilder.put("plow", Attribute.gml(tupleRange.getLow() == null ? "-\u221e" : tupleRange.getLow().toString()));
            attributeMapBuilder.put("phigh", Attribute.gml(tupleRange.getHigh() == null ? "\u221e" : tupleRange.getHigh().toString()));
        } else {
            detailsBuilder.add((Object)"prefix comparisons: {{pcomparisons}}");
            attributeMapBuilder.put("pcomparisons", Attribute.gml(this.prefixScanComparisons.toString()));
        }
        for (int d = 0; d < this.dimensionsScanComparisons.size(); ++d) {
            ScanComparisons dimensionScanComparisons = this.dimensionsScanComparisons.get(d);
            tupleRange = dimensionScanComparisons.toTupleRangeWithoutContext();
            if (tupleRange != null) {
                detailsBuilder.add((Object)("dim" + d + ": " + tupleRange.getLowEndpoint().toString(false) + "{{dlow" + d + "}}, {{dhigh" + d + "}}" + tupleRange.getHighEndpoint().toString(true)));
                attributeMapBuilder.put("dlow" + d, Attribute.gml(tupleRange.getLow() == null ? "-\u221e" : tupleRange.getLow().toString()));
                attributeMapBuilder.put("dhigh" + d, Attribute.gml(tupleRange.getHigh() == null ? "\u221e" : tupleRange.getHigh().toString()));
                continue;
            }
            detailsBuilder.add((Object)("dim" + d + " comparisons: {{dcomparisons" + d + "}}"));
            attributeMapBuilder.put("dcomparisons" + d, Attribute.gml(dimensionScanComparisons.toString()));
        }
        tupleRange = this.suffixScanComparisons.toTupleRangeWithoutContext();
        if (tupleRange != null) {
            detailsBuilder.add((Object)("suffix: " + tupleRange.getLowEndpoint().toString(false) + "{{slow}}, {{shigh}}" + tupleRange.getHighEndpoint().toString(true)));
            attributeMapBuilder.put("slow", Attribute.gml(tupleRange.getLow() == null ? "-\u221e" : tupleRange.getLow().toString()));
            attributeMapBuilder.put("shigh", Attribute.gml(tupleRange.getHigh() == null ? "\u221e" : tupleRange.getHigh().toString()));
        } else {
            detailsBuilder.add((Object)"suffix comparisons: {{scomparisons}}");
            attributeMapBuilder.put("scomparisons", Attribute.gml(this.suffixScanComparisons.toString()));
        }
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        ImmutableSet.Builder correlatedToBuilder = ImmutableSet.builder();
        correlatedToBuilder.addAll(this.prefixScanComparisons.getCorrelatedTo());
        correlatedToBuilder.addAll(this.dimensionsScanComparisons.stream().flatMap(dimensionScanComparison -> dimensionScanComparison.getCorrelatedTo().stream()).iterator());
        correlatedToBuilder.addAll(this.suffixScanComparisons.getCorrelatedTo());
        return correlatedToBuilder.build();
    }

    @Override
    @Nonnull
    public IndexScanParameters rebase(@Nonnull AliasMap translationMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(translationMap), false);
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MultidimensionalIndexScanComparisons that = (MultidimensionalIndexScanComparisons)other;
        if (!this.prefixScanComparisons.semanticEquals(that.prefixScanComparisons, aliasMap)) {
            return false;
        }
        if (this.dimensionsScanComparisons.size() != that.dimensionsScanComparisons.size()) {
            return false;
        }
        for (int i = 0; i < this.dimensionsScanComparisons.size(); ++i) {
            ScanComparisons otherDimensionScanComparison;
            ScanComparisons dimensionScanComparison = this.dimensionsScanComparisons.get(i);
            if (dimensionScanComparison.semanticEquals(otherDimensionScanComparison = that.dimensionsScanComparisons.get(i), aliasMap)) continue;
            return false;
        }
        return this.suffixScanComparisons.semanticEquals(that.suffixScanComparisons, aliasMap);
    }

    @Override
    public int semanticHashCode() {
        int hashCode = this.prefixScanComparisons.semanticHashCode();
        for (ScanComparisons dimensionScanComparison : this.dimensionsScanComparisons) {
            hashCode = 31 * hashCode + dimensionScanComparison.semanticHashCode();
        }
        return 31 * hashCode + this.suffixScanComparisons.semanticHashCode();
    }

    @Override
    @Nonnull
    public IndexScanParameters translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        ScanComparisons translatedPrefixScanComparisons = this.prefixScanComparisons.translateCorrelations(translationMap, shouldSimplifyValues);
        ImmutableList.Builder translatedDimensionScanComparisonBuilder = ImmutableList.builder();
        boolean isSameDimensionsScanComparisons = true;
        for (ScanComparisons dimensionScanComparisons : this.dimensionsScanComparisons) {
            ScanComparisons translatedDimensionScanComparison = dimensionScanComparisons.translateCorrelations(translationMap, shouldSimplifyValues);
            if (translatedDimensionScanComparison != dimensionScanComparisons) {
                isSameDimensionsScanComparisons = false;
            }
            translatedDimensionScanComparisonBuilder.add(translatedDimensionScanComparison);
        }
        ScanComparisons translatedSuffixKeyScanComparisons = this.suffixScanComparisons.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedPrefixScanComparisons != this.prefixScanComparisons || !isSameDimensionsScanComparisons || translatedSuffixKeyScanComparisons != this.suffixScanComparisons) {
            return this.withComparisons(translatedPrefixScanComparisons, (List<ScanComparisons>)((Object)translatedDimensionScanComparisonBuilder.build()), translatedSuffixKeyScanComparisons);
        }
        return this;
    }

    @Nonnull
    protected MultidimensionalIndexScanComparisons withComparisons(@Nonnull ScanComparisons prefixScanComparisons, @Nonnull List<ScanComparisons> dimensionsComparisonRanges, @Nonnull ScanComparisons suffixKeyScanComparisons) {
        return new MultidimensionalIndexScanComparisons(prefixScanComparisons, dimensionsComparisonRanges, suffixKeyScanComparisons);
    }

    public String toString() {
        return "BY_VALUE(MD):" + String.valueOf(this.prefixScanComparisons) + ":" + String.valueOf(this.dimensionsScanComparisons) + ":" + String.valueOf(this.suffixScanComparisons);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public PMultidimensionalIndexScanComparisons toProto(@Nonnull PlanSerializationContext serializationContext) {
        PMultidimensionalIndexScanComparisons.Builder builder = PMultidimensionalIndexScanComparisons.newBuilder();
        builder.setPrefixScanComparisons(this.prefixScanComparisons.toProto(serializationContext));
        for (ScanComparisons dimensionsScanComparison : this.dimensionsScanComparisons) {
            builder.addDimensionsScanComparisons(dimensionsScanComparison.toProto(serializationContext));
        }
        builder.setSuffixScanComparisons(this.suffixScanComparisons.toProto(serializationContext));
        return builder.build();
    }

    @Override
    @Nonnull
    public PIndexScanParameters toIndexScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanParameters.newBuilder().setMultidimensionalIndexScanComparisons(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static MultidimensionalIndexScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMultidimensionalIndexScanComparisons multidimensionalIndexScanComparisonsProto) {
        ImmutableList.Builder dimensionScanComparisonsBuilder = ImmutableList.builder();
        for (int i = 0; i < multidimensionalIndexScanComparisonsProto.getDimensionsScanComparisonsCount(); ++i) {
            dimensionScanComparisonsBuilder.add(ScanComparisons.fromProto(serializationContext, multidimensionalIndexScanComparisonsProto.getDimensionsScanComparisons(i)));
        }
        return new MultidimensionalIndexScanComparisons(ScanComparisons.fromProto(serializationContext, Objects.requireNonNull(multidimensionalIndexScanComparisonsProto.getPrefixScanComparisons())), (List<ScanComparisons>)((Object)dimensionScanComparisonsBuilder.build()), ScanComparisons.fromProto(serializationContext, Objects.requireNonNull(multidimensionalIndexScanComparisonsProto.getSuffixScanComparisons())));
    }

    @Nonnull
    public static MultidimensionalIndexScanComparisons byValue(@Nullable ScanComparisons prefixScanComparisons, @Nonnull List<ScanComparisons> dimensionsComparisonRanges, @Nullable ScanComparisons suffixKeyScanComparisons) {
        if (prefixScanComparisons == null) {
            prefixScanComparisons = ScanComparisons.EMPTY;
        }
        if (suffixKeyScanComparisons == null) {
            suffixKeyScanComparisons = ScanComparisons.EMPTY;
        }
        return new MultidimensionalIndexScanComparisons(prefixScanComparisons, dimensionsComparisonRanges, suffixKeyScanComparisons);
    }

    public static class Deserializer
    implements PlanDeserializer<PMultidimensionalIndexScanComparisons, MultidimensionalIndexScanComparisons> {
        @Override
        @Nonnull
        public Class<PMultidimensionalIndexScanComparisons> getProtoMessageClass() {
            return PMultidimensionalIndexScanComparisons.class;
        }

        @Override
        @Nonnull
        public MultidimensionalIndexScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMultidimensionalIndexScanComparisons multidimensionalIndexScanComparisonsProto) {
            return MultidimensionalIndexScanComparisons.fromProto(serializationContext, multidimensionalIndexScanComparisonsProto);
        }
    }
}

