/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintenanceFilter;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationConfig;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.subspace.Subspace;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class OnlineIndexOperationBaseBuilder<B extends OnlineIndexOperationBaseBuilder<B>> {
    @Nullable
    private FDBDatabaseRunner runner;
    @Nullable
    private FDBRecordStore.Builder recordStoreBuilder;
    @Nullable
    private UnaryOperator<OnlineIndexOperationConfig> configLoader = null;
    @Nonnull
    private final OnlineIndexOperationConfig.Builder configBuilder = OnlineIndexOperationConfig.newBuilder();
    private boolean trackProgress = true;

    protected OnlineIndexOperationBaseBuilder() {
    }

    abstract B self();

    @Nullable
    public FDBDatabaseRunner getRunner() {
        return this.runner;
    }

    public B setRunner(@Nullable FDBDatabaseRunner runner) {
        this.runner = runner;
        return this.self();
    }

    private void setRunnerDefaults() {
        this.setPriority(FDBTransactionPriority.BATCH);
    }

    public B setDatabase(@Nonnull FDBDatabase database) {
        this.runner = database.newRunner();
        this.setRunnerDefaults();
        return this.self();
    }

    @Nullable
    public FDBRecordStore.Builder getRecordStoreBuilder() {
        return this.recordStoreBuilder;
    }

    public B setRecordStoreBuilder(@Nonnull FDBRecordStore.Builder recordStoreBuilder) {
        this.recordStoreBuilder = recordStoreBuilder.copyBuilder().setContext(null);
        if (this.runner == null && recordStoreBuilder.getContext() != null) {
            this.runner = recordStoreBuilder.getContext().newRunner();
            this.setRunnerDefaults();
        }
        return this.self();
    }

    public B setRecordStore(@Nonnull FDBRecordStore recordStore) {
        this.recordStoreBuilder = recordStore.asBuilder().setContext(null);
        if (this.runner == null) {
            this.runner = recordStore.getRecordContext().newRunner();
            this.setRunnerDefaults();
        }
        return this.self();
    }

    @Nullable
    public UnaryOperator<OnlineIndexOperationConfig> getConfigLoader() {
        return this.configLoader;
    }

    @Nonnull
    public B setConfigLoader(@Nonnull UnaryOperator<OnlineIndexOperationConfig> configLoader) {
        this.configLoader = configLoader;
        return this.self();
    }

    public int getLimit() {
        return this.configBuilder.getMaxLimit();
    }

    @Nonnull
    public B setLimit(int limit) {
        this.configBuilder.setMaxLimit(limit);
        return this.self();
    }

    @Nonnull
    public B setInitialLimit(int limit) {
        this.configBuilder.setInitialLimit(limit);
        return this.self();
    }

    public int getMaxWriteLimitBytes() {
        return this.configBuilder.getWriteLimitBytes();
    }

    @Nonnull
    public B setMaxWriteLimitBytes(int max) {
        this.configBuilder.setWriteLimitBytes(max);
        return this.self();
    }

    public int getMaxRetries() {
        return this.configBuilder.getMaxRetries();
    }

    @Nonnull
    public B setMaxRetries(int maxRetries) {
        this.configBuilder.setMaxRetries(maxRetries);
        return this.self();
    }

    public int getRecordsPerSecond() {
        return this.configBuilder.getRecordsPerSecond();
    }

    @Nonnull
    public B setRecordsPerSecond(int recordsPerSecond) {
        this.configBuilder.setRecordsPerSecond(recordsPerSecond);
        return this.self();
    }

    @Nullable
    public FDBStoreTimer getTimer() {
        if (this.runner == null) {
            throw new MetaDataException("timer is only known after runner has been set", new Object[0]);
        }
        return this.runner.getTimer();
    }

    @Nonnull
    public B setTimer(@Nullable FDBStoreTimer timer) {
        if (this.runner == null) {
            throw new MetaDataException("timer can only be set after runner has been set", new Object[0]);
        }
        this.runner.setTimer(timer);
        return this.self();
    }

    @Nullable
    public Map<String, String> getMdcContext() {
        if (this.runner == null) {
            throw new MetaDataException("logging context is only known after runner has been set", new Object[0]);
        }
        return this.runner.getMdcContext();
    }

    @Nonnull
    public B setMdcContext(@Nullable Map<String, String> mdcContext) {
        if (this.runner == null) {
            throw new MetaDataException("logging context can only be set after runner has been set", new Object[0]);
        }
        this.runner.setMdcContext(mdcContext);
        return this.self();
    }

    @Nullable
    public FDBDatabase.WeakReadSemantics getWeakReadSemantics() {
        if (this.runner == null) {
            throw new MetaDataException("weak read semantics is only known after runner has been set", new Object[0]);
        }
        return this.runner.getWeakReadSemantics();
    }

    @Nonnull
    public B setWeakReadSemantics(@Nullable FDBDatabase.WeakReadSemantics weakReadSemantics) {
        if (this.runner == null) {
            throw new MetaDataException("weak read semantics can only be set after runner has been set", new Object[0]);
        }
        this.runner.setWeakReadSemantics(weakReadSemantics);
        return this.self();
    }

    @Nonnull
    public FDBTransactionPriority getPriority() {
        if (this.runner == null) {
            throw new MetaDataException("transaction priority is only known after runner has been set", new Object[0]);
        }
        return this.runner.getPriority();
    }

    @Nonnull
    public B setPriority(@Nonnull FDBTransactionPriority priority) {
        if (this.runner == null) {
            throw new MetaDataException("transaction priority can only be set after runner has been set", new Object[0]);
        }
        this.runner.setPriority(priority);
        return this.self();
    }

    public int getMaxAttempts() {
        if (this.runner == null) {
            throw new MetaDataException("maximum attempts is only known after runner has been set", new Object[0]);
        }
        return this.runner.getMaxAttempts();
    }

    public B setMaxAttempts(int maxAttempts) {
        if (this.runner == null) {
            throw new MetaDataException("maximum attempts can only be set after runner has been set", new Object[0]);
        }
        this.runner.setMaxAttempts(maxAttempts);
        return this.self();
    }

    public B setIncreaseLimitAfter(int increaseLimitAfter) {
        this.configBuilder.setIncreaseLimitAfter(increaseLimitAfter);
        return this.self();
    }

    public int getIncreaseLimitAfter() {
        return this.configBuilder.getIncreaseLimitAfter();
    }

    public long getMaxDelayMillis() {
        if (this.runner == null) {
            throw new MetaDataException("maximum delay is only known after runner has been set", new Object[0]);
        }
        return this.runner.getMaxDelayMillis();
    }

    public B setMaxDelayMillis(long maxDelayMillis) {
        if (this.runner == null) {
            throw new MetaDataException("maximum delay can only be set after runner has been set", new Object[0]);
        }
        this.runner.setMaxDelayMillis(maxDelayMillis);
        return this.self();
    }

    public long getInitialDelayMillis() {
        if (this.runner == null) {
            throw new MetaDataException("initial delay is only known after runner has been set", new Object[0]);
        }
        return this.runner.getInitialDelayMillis();
    }

    public B setInitialDelayMillis(long initialDelayMillis) {
        if (this.runner == null) {
            throw new MetaDataException("initial delay can only be set after runner has been set", new Object[0]);
        }
        this.runner.setInitialDelayMillis(initialDelayMillis);
        return this.self();
    }

    public long getProgressLogIntervalMillis() {
        return this.configBuilder.getProgressLogIntervalMillis();
    }

    public B setProgressLogIntervalMillis(long millis) {
        this.configBuilder.setProgressLogIntervalMillis(millis);
        return this.self();
    }

    public boolean isTrackProgress() {
        return this.trackProgress;
    }

    public B setTrackProgress(boolean trackProgress) {
        this.trackProgress = trackProgress;
        return this.self();
    }

    public B setIndexMaintenanceFilter(@Nonnull IndexMaintenanceFilter indexMaintenanceFilter) {
        if (this.recordStoreBuilder == null) {
            throw new MetaDataException("index filter can only be set after record store builder has been set", new Object[0]);
        }
        this.recordStoreBuilder.setIndexMaintenanceFilter(indexMaintenanceFilter);
        return this.self();
    }

    public B setSerializer(@Nonnull RecordSerializer<Message> serializer) {
        if (this.recordStoreBuilder == null) {
            throw new MetaDataException("serializer can only be set after record store builder has been set", new Object[0]);
        }
        this.recordStoreBuilder.setSerializer((RecordSerializer)serializer);
        return this.self();
    }

    @Deprecated(forRemoval=true)
    public B setFormatVersion(int formatVersion) {
        if (this.recordStoreBuilder == null) {
            throw new MetaDataException("format version can only be set after record store builder has been set", new Object[0]);
        }
        this.recordStoreBuilder.setFormatVersion(formatVersion);
        return this.self();
    }

    @Nonnull
    protected RecordMetaData getRecordMetaData() {
        if (this.recordStoreBuilder == null) {
            throw new MetaDataException("record store must be set", new Object[0]);
        }
        if (this.recordStoreBuilder.getMetaDataProvider() == null) {
            throw new MetaDataException("record store builder must include metadata", new Object[0]);
        }
        return this.recordStoreBuilder.getMetaDataProvider().getRecordMetaData();
    }

    public B setMetaData(@Nonnull RecordMetaDataProvider metaDataProvider) {
        if (this.recordStoreBuilder == null) {
            this.recordStoreBuilder = FDBRecordStore.newBuilder();
        }
        this.recordStoreBuilder.setMetaDataProvider(metaDataProvider);
        return this.self();
    }

    public B setSubspaceProvider(@Nonnull SubspaceProvider subspaceProvider) {
        if (this.recordStoreBuilder == null) {
            this.recordStoreBuilder = FDBRecordStore.newBuilder();
        }
        this.recordStoreBuilder.setSubspaceProvider(subspaceProvider);
        return this.self();
    }

    public B setSubspace(@Nonnull Subspace subspace) {
        if (this.recordStoreBuilder == null) {
            this.recordStoreBuilder = FDBRecordStore.newBuilder();
        }
        this.recordStoreBuilder.setSubspace(subspace);
        return this.self();
    }

    @Nonnull
    public B setTimeLimitMilliseconds(long timeLimitMilliseconds) {
        this.configBuilder.setTimeLimitMilliseconds(timeLimitMilliseconds);
        return this.self();
    }

    @Nonnull
    public B setTransactionTimeLimitMilliseconds(long timeLimitMilliseconds) {
        this.configBuilder.setTransactionTimeLimitMilliseconds(timeLimitMilliseconds);
        return this.self();
    }

    @API(value=API.Status.DEPRECATED)
    public B setUseSynchronizedSession(boolean useSynchronizedSession) {
        return this.self();
    }

    public B setLeaseLengthMillis(long leaseLengthMillis) {
        this.configBuilder.setLeaseLengthMillis(leaseLengthMillis);
        return this.self();
    }

    @Nonnull
    protected OnlineIndexOperationConfig getConfig() {
        return this.configBuilder.build();
    }

    protected void validateLimits() {
        OnlineIndexOperationBaseBuilder.checkPositive(this.getMaxRetries(), "maximum retries");
        OnlineIndexOperationBaseBuilder.checkPositive(this.getLimit(), "record limit");
        OnlineIndexOperationBaseBuilder.checkPositive(this.getRecordsPerSecond(), "records per second value");
    }

    private static void checkPositive(int value, String desc) {
        if (value <= 0) {
            throw new RecordCoreException("Non-positive value " + value + " given for " + desc, new Object[0]);
        }
    }
}

