/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class OnlineIndexOperationConfig {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_WRITE_LIMIT_BYTES = 900000;
    public static final int DEFAULT_RECORDS_PER_SECOND = 10000;
    public static final int DEFAULT_MAX_RETRIES = 100;
    public static final int DEFAULT_PROGRESS_LOG_INTERVAL = -1;
    public static final long DEFAULT_LEASE_LENGTH_MILLIS = 10000L;
    public static final long DEFAULT_TRANSACTION_TIME_LIMIT = 4000L;
    public static final int DO_NOT_RE_INCREASE_LIMIT = -1;
    private final int maxLimit;
    private final int initialLimit;
    private final int maxWriteLimitBytes;
    private final int maxRetries;
    private final int recordsPerSecond;
    private final long progressLogIntervalMillis;
    private final int increaseLimitAfter;
    private final long timeLimitMilliseconds;
    private final long transactionTimeLimitMilliseconds;
    private final long leaseLengthMillis;
    public static final long UNLIMITED_TIME = 0L;

    OnlineIndexOperationConfig(int maxLimit, int initialLimit, int maxRetries, int recordsPerSecond, long progressLogIntervalMillis, int increaseLimitAfter, int maxWriteLimitBytes, long timeLimitMilliseconds, long transactionTimeLimitMilliseconds, long leaseLengthMillis) {
        this.maxLimit = maxLimit;
        this.initialLimit = initialLimit;
        this.maxRetries = maxRetries;
        this.recordsPerSecond = recordsPerSecond;
        this.progressLogIntervalMillis = progressLogIntervalMillis;
        this.increaseLimitAfter = increaseLimitAfter;
        this.maxWriteLimitBytes = maxWriteLimitBytes;
        this.timeLimitMilliseconds = timeLimitMilliseconds;
        this.transactionTimeLimitMilliseconds = transactionTimeLimitMilliseconds;
        this.leaseLengthMillis = leaseLengthMillis;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public int getInitialLimit() {
        return this.initialLimit > 0 ? Math.min(this.initialLimit, this.maxLimit) : this.maxLimit;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRecordsPerSecond() {
        return this.recordsPerSecond;
    }

    public long getProgressLogIntervalMillis() {
        return this.progressLogIntervalMillis;
    }

    public int getIncreaseLimitAfter() {
        return this.increaseLimitAfter;
    }

    public long getMaxWriteLimitBytes() {
        return this.maxWriteLimitBytes;
    }

    public long getTimeLimitMilliseconds() {
        return this.timeLimitMilliseconds;
    }

    public long getTransactionTimeLimitMilliseconds() {
        return this.transactionTimeLimitMilliseconds;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @API(value=API.Status.DEPRECATED)
    public boolean shouldUseSynchronizedSession() {
        return true;
    }

    public long getLeaseLengthMillis() {
        return this.leaseLengthMillis;
    }

    @Nonnull
    public Builder toBuilder() {
        return OnlineIndexOperationConfig.newBuilder().setMaxLimit(this.maxLimit).setInitialLimit(this.initialLimit).setWriteLimitBytes(this.maxWriteLimitBytes).setIncreaseLimitAfter(this.increaseLimitAfter).setProgressLogIntervalMillis(this.progressLogIntervalMillis).setRecordsPerSecond(this.recordsPerSecond).setMaxRetries(this.maxRetries).setTimeLimitMilliseconds(this.timeLimitMilliseconds).setTransactionTimeLimitMilliseconds(this.transactionTimeLimitMilliseconds).setLeaseLengthMillis(this.leaseLengthMillis);
    }

    @API(value=API.Status.UNSTABLE)
    public static class Builder {
        private int maxLimit = 100;
        private int initialLimit = 0;
        private int maxWriteLimitBytes = 900000;
        private int maxRetries = 100;
        private int recordsPerSecond = 10000;
        private long progressLogIntervalMillis = -1L;
        private int increaseLimitAfter = -1;
        private long timeLimitMilliseconds = 0L;
        private long transactionTimeLimitMilliseconds = 4000L;
        private long leaseLengthMillis = 10000L;

        protected Builder() {
        }

        public int getMaxLimit() {
            return this.maxLimit;
        }

        @Nonnull
        public Builder setMaxLimit(int limit) {
            this.maxLimit = limit;
            return this;
        }

        public int getInitialLimit() {
            return this.initialLimit;
        }

        @Nonnull
        public Builder setInitialLimit(int limit) {
            this.initialLimit = limit;
            return this;
        }

        public int getWriteLimitBytes() {
            return this.maxWriteLimitBytes;
        }

        @Nonnull
        public Builder setWriteLimitBytes(int limit) {
            this.maxWriteLimitBytes = limit;
            return this;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Nonnull
        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public int getRecordsPerSecond() {
            return this.recordsPerSecond;
        }

        @Nonnull
        public Builder setRecordsPerSecond(int recordsPerSecond) {
            this.recordsPerSecond = recordsPerSecond;
            return this;
        }

        public long getProgressLogIntervalMillis() {
            return this.progressLogIntervalMillis;
        }

        @Nonnull
        public Builder setProgressLogIntervalMillis(long progressLogIntervalMillis) {
            this.progressLogIntervalMillis = progressLogIntervalMillis;
            return this;
        }

        public int getIncreaseLimitAfter() {
            return this.increaseLimitAfter;
        }

        @Nonnull
        public Builder setIncreaseLimitAfter(int increaseLimitAfter) {
            this.increaseLimitAfter = increaseLimitAfter;
            return this;
        }

        public long getTimeLimitMilliseconds() {
            return this.timeLimitMilliseconds;
        }

        @Nonnull
        public Builder setTimeLimitMilliseconds(long timeLimitMilliseconds) {
            if (timeLimitMilliseconds < 0L) {
                timeLimitMilliseconds = 0L;
            }
            this.timeLimitMilliseconds = timeLimitMilliseconds;
            return this;
        }

        public long getTransactionTimeLimitMilliseconds() {
            return this.transactionTimeLimitMilliseconds;
        }

        @Nonnull
        public Builder setTransactionTimeLimitMilliseconds(long timeLimitMilliseconds) {
            this.transactionTimeLimitMilliseconds = timeLimitMilliseconds;
            return this;
        }

        @API(value=API.Status.DEPRECATED)
        public Builder setUseSynchronizedSession(boolean useSynchronizedSession) {
            return this;
        }

        public Builder setLeaseLengthMillis(long leaseLengthMillis) {
            this.leaseLengthMillis = leaseLengthMillis;
            return this;
        }

        @Nonnull
        public OnlineIndexOperationConfig build() {
            return new OnlineIndexOperationConfig(this.maxLimit, this.initialLimit, this.maxRetries, this.recordsPerSecond, this.progressLogIntervalMillis, this.increaseLimitAfter, this.maxWriteLimitBytes, this.timeLimitMilliseconds, this.transactionTimeLimitMilliseconds, this.leaseLengthMillis);
        }
    }
}

