/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbing;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationBaseBuilder;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationConfig;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class OnlineIndexScrubber
implements AutoCloseable {
    @Nonnull
    private final IndexingCommon common;
    @Nonnull
    private final FDBDatabaseRunner runner;
    @Nonnull
    private final ScrubbingPolicy scrubbingPolicy;

    OnlineIndexScrubber(@Nonnull FDBDatabaseRunner runner, @Nonnull FDBRecordStore.Builder recordStoreBuilder, @Nonnull Index index, @Nonnull Collection<RecordType> recordTypes, @Nonnull UnaryOperator<OnlineIndexOperationConfig> configLoader, @Nonnull OnlineIndexOperationConfig config, boolean trackProgress, @Nonnull ScrubbingPolicy scrubbingPolicy) {
        this.runner = runner;
        this.scrubbingPolicy = scrubbingPolicy;
        this.common = new IndexingCommon(runner, recordStoreBuilder, Collections.singletonList(index), recordTypes, configLoader, config, trackProgress);
    }

    @Override
    public void close() {
        this.common.close();
    }

    private IndexingBase getScrubber(IndexScrubbingTools.ScrubbingType type, AtomicLong count) {
        return new IndexScrubbing(this.common, OnlineIndexer.IndexingPolicy.DEFAULT, this.scrubbingPolicy, count, type);
    }

    @Nonnull
    private CompletableFuture<Void> scrubIndexAsync(IndexScrubbingTools.ScrubbingType type, AtomicLong count) {
        return AsyncUtil.composeHandle(this.getScrubber(type, count).buildIndexAsync(false), (ignore, ex) -> {
            if (ex != null) {
                throw FDBExceptions.wrapException(ex);
            }
            return AsyncUtil.DONE;
        });
    }

    public long scrubDanglingIndexEntries() {
        AtomicLong danglingCount = new AtomicLong(0L);
        this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_BUILD_INDEX, this.scrubIndexAsync(IndexScrubbingTools.ScrubbingType.DANGLING, danglingCount));
        return danglingCount.get();
    }

    public long scrubMissingIndexEntries() {
        AtomicLong missingCount = new AtomicLong(0L);
        this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_BUILD_INDEX, this.scrubIndexAsync(IndexScrubbingTools.ScrubbingType.MISSING, missingCount));
        return missingCount.get();
    }

    public void eraseAllIndexingScrubbingData(@Nonnull FDBRecordContext context, @Nonnull FDBRecordStore store) {
        IndexingSubspaces.eraseAllIndexingScrubbingData(context, store, this.common.getIndex());
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class ScrubbingPolicy {
        public static final ScrubbingPolicy DEFAULT = new ScrubbingPolicy(1000, true, 0L, 0, false);
        private final int logWarningsLimit;
        private final boolean allowRepair;
        private final long entriesScanLimit;
        private final int rangeId;
        private final boolean rangeReset;

        private ScrubbingPolicy(int logWarningsLimit, boolean allowRepair, long entriesScanLimit, int rangeId, boolean rangeReset) {
            this.logWarningsLimit = logWarningsLimit;
            this.allowRepair = allowRepair;
            this.entriesScanLimit = entriesScanLimit;
            this.rangeId = rangeId;
            this.rangeReset = rangeReset;
        }

        boolean allowRepair() {
            return this.allowRepair;
        }

        long getEntriesScanLimit() {
            return this.entriesScanLimit;
        }

        public int getLogWarningsLimit() {
            return this.logWarningsLimit;
        }

        public int getScrubbingRangeId() {
            return this.rangeId;
        }

        public boolean isScrubbingRangeReset() {
            return this.rangeReset;
        }

        @Nonnull
        public static Builder newBuilder() {
            return new Builder();
        }

        @API(value=API.Status.UNSTABLE)
        public static class Builder {
            int logWarningsLimit = 1000;
            boolean allowRepair = true;
            long entriesScanLimit = 0L;
            int rangeId = 0;
            boolean rangeReset = false;

            protected Builder() {
            }

            public Builder setLogWarningsLimit(int logWarningsLimit) {
                this.logWarningsLimit = logWarningsLimit;
                return this;
            }

            public Builder setAllowRepair(boolean val) {
                this.allowRepair = val;
                return this;
            }

            public Builder setEntriesScanLimit(long entriesScanLimit) {
                this.entriesScanLimit = entriesScanLimit;
                return this;
            }

            public Builder setScrubbingRangeId(int rangeId) {
                this.rangeId = rangeId;
                return this;
            }

            public Builder setScrubbingRangeReset(boolean rangeReset) {
                this.rangeReset = rangeReset;
                return this;
            }

            public ScrubbingPolicy build() {
                return new ScrubbingPolicy(this.logWarningsLimit, this.allowRepair, this.entriesScanLimit, this.rangeId, this.rangeReset);
            }
        }
    }

    @API(value=API.Status.UNSTABLE)
    public static class Builder
    extends OnlineIndexOperationBaseBuilder<Builder> {
        @Nullable
        protected Index index;
        @Nullable
        protected Collection<RecordType> recordTypes;
        ScrubbingPolicy scrubbingPolicy = null;
        ScrubbingPolicy.Builder scrubbingPolicyBuilder = null;

        protected Builder() {
            this.setLimit(2000);
        }

        @Override
        Builder self() {
            return this;
        }

        @Nonnull
        public Builder setIndex(@Nullable Index index) {
            this.index = index;
            return this;
        }

        @Nonnull
        public Builder setIndex(@Nonnull String indexName) {
            this.index = this.getRecordMetaData().getIndex(indexName);
            return this;
        }

        @Nonnull
        public Builder setRecordTypes(@Nullable Collection<RecordType> recordTypes) {
            this.recordTypes = recordTypes;
            return this;
        }

        public Builder setScrubbingPolicy(@Nonnull ScrubbingPolicy scrubbingPolicy) {
            this.scrubbingPolicyBuilder = null;
            this.scrubbingPolicy = scrubbingPolicy;
            return this;
        }

        public Builder setScrubbingPolicy(@Nonnull ScrubbingPolicy.Builder scrubbingPolicyBuilder) {
            this.scrubbingPolicy = null;
            this.scrubbingPolicyBuilder = scrubbingPolicyBuilder;
            return this;
        }

        public OnlineIndexScrubber build() {
            this.validate();
            OnlineIndexOperationConfig conf = this.getConfig();
            if (this.scrubbingPolicyBuilder != null) {
                this.scrubbingPolicy = this.scrubbingPolicyBuilder.build();
            }
            if (this.scrubbingPolicy == null) {
                this.scrubbingPolicy = ScrubbingPolicy.DEFAULT;
            }
            return new OnlineIndexScrubber(this.getRunner(), this.getRecordStoreBuilder(), this.index, this.recordTypes, this.getConfigLoader(), conf, this.isTrackProgress(), this.scrubbingPolicy);
        }

        protected void validate() {
            this.validateIndex();
            this.validateLimits();
        }

        private void validateIndex() {
            if (this.index == null) {
                throw new IllegalArgumentException("index must be set");
            }
            RecordMetaData metaData = this.getRecordMetaData();
            if (!metaData.hasIndex(this.index.getName()) || this.index != metaData.getIndex(this.index.getName())) {
                throw new MetaDataException("Index " + this.index.getName() + " not contained within specified metadata", new Object[0]);
            }
            if (this.recordTypes != null) {
                for (RecordType recordType : this.recordTypes) {
                    if (recordType == metaData.getIndexableRecordType(recordType.getName())) continue;
                    throw new MetaDataException("Record type " + recordType.getName() + " not contained within specified metadata", new Object[0]);
                }
            }
        }
    }
}

