/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingByIndex;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.IndexingMultiTargetByRecords;
import com.apple.foundationdb.record.provider.foundationdb.IndexingMutuallyByRecords;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationBaseBuilder;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationConfig;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingHeartbeat;
import com.apple.foundationdb.synchronizedsession.SynchronizedSession;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class OnlineIndexer
implements AutoCloseable {
    public static final int UNLIMITED = Integer.MAX_VALUE;
    public static final int INDEXING_ATTEMPTS_RECURSION_LIMIT = 5;
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineIndexer.class);
    @Nonnull
    private final IndexingCommon common;
    @Nullable
    private IndexingBase indexer = null;
    @Nonnull
    private final FDBDatabaseRunner runner;
    @Nonnull
    private final Index index;
    @Nonnull
    private IndexingPolicy indexingPolicy;
    private boolean fallbackToRecordsScan = false;

    OnlineIndexer(@Nonnull FDBDatabaseRunner runner, @Nonnull FDBRecordStore.Builder recordStoreBuilder, @Nonnull List<Index> targetIndexes, @Nullable Collection<RecordType> recordTypes, @Nullable UnaryOperator<OnlineIndexOperationConfig> configLoader, @Nonnull OnlineIndexOperationConfig config, boolean trackProgress, @Nonnull IndexingPolicy indexingPolicy) {
        this.runner = runner;
        this.index = targetIndexes.get(0);
        this.indexingPolicy = indexingPolicy;
        this.common = new IndexingCommon(runner, recordStoreBuilder, targetIndexes, recordTypes, configLoader, config, trackProgress);
    }

    @Nonnull
    private CompletableFuture<Void> indexingLauncher(Supplier<CompletableFuture<Void>> indexingFunc) {
        return this.indexingLauncher(indexingFunc, 0);
    }

    @Nonnull
    private CompletableFuture<Void> indexingLauncher(Supplier<CompletableFuture<Void>> indexingFunc, int attemptCount) {
        return this.indexingLauncher(indexingFunc, attemptCount, null);
    }

    @Nonnull
    private CompletableFuture<Void> indexingLauncher(Supplier<CompletableFuture<Void>> indexingFunc, int attemptCount, @Nullable IndexingPolicy requestedPolicy) {
        return AsyncUtil.composeHandle(indexingFunc.get(), (ignore, ex) -> this.indexingCatcher((Throwable)ex, indexingFunc, attemptCount + 1, requestedPolicy));
    }

    @Nonnull
    private CompletableFuture<Void> indexingCatcher(Throwable ex, Supplier<CompletableFuture<Void>> indexingFunc, int attemptCount, @Nullable IndexingPolicy requestedPolicy) {
        IndexingBase.UnexpectedReadableException unexpectedReadableException;
        if (ex == null) {
            return AsyncUtil.DONE;
        }
        if (attemptCount > 5) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(KeyValueLogMessage.build("Too many indexing attempts", new Object[]{LogMessageKeys.CURR_ATTEMPT, attemptCount}).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
            }
            throw FDBExceptions.wrapException(ex);
        }
        this.indexer = null;
        IndexingBase.PartlyBuiltException partlyBuiltException = IndexingBase.getAPartlyBuiltExceptionIfApplicable(ex);
        if (partlyBuiltException != null) {
            IndexBuildProto.IndexBuildIndexingStamp conflictingIndexingTypeStamp = partlyBuiltException.getSavedStamp();
            IndexingPolicy.DesiredAction desiredAction = this.indexingPolicy.getIfMismatchPrevious();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.build("conflicting indexing type stamp", new Object[]{LogMessageKeys.CURR_ATTEMPT, attemptCount, LogMessageKeys.INDEXING_POLICY_DESIRED_ACTION, desiredAction, LogMessageKeys.ACTUAL, partlyBuiltException.getSavedStampString(), LogMessageKeys.EXPECTED, partlyBuiltException.getExpectedStampString()}).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
            }
            if (desiredAction == IndexingPolicy.DesiredAction.CONTINUE) {
                IndexBuildProto.IndexBuildIndexingStamp.Method method = conflictingIndexingTypeStamp.getMethod();
                if (method == IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS && !this.common.isMultiTarget()) {
                    this.fallbackToRecordsScan = true;
                    return this.indexingLauncher(indexingFunc, attemptCount);
                }
                if (method == IndexBuildProto.IndexBuildIndexingStamp.Method.MULTI_TARGET_BY_RECORDS && !this.common.isMultiTarget()) {
                    this.fallbackToRecordsScan = true;
                    return this.indexingLauncher(indexingFunc, attemptCount);
                }
                if (method == IndexBuildProto.IndexBuildIndexingStamp.Method.BY_INDEX && !this.common.isMultiTarget()) {
                    Object sourceIndexSubspaceKey = Index.decodeSubspaceKey(conflictingIndexingTypeStamp.getSourceIndexSubspaceKey());
                    IndexingPolicy origPolicy = this.indexingPolicy;
                    this.indexingPolicy = origPolicy.toBuilder().setSourceIndexSubspaceKey(sourceIndexSubspaceKey).build();
                    return this.indexingLauncher(indexingFunc, attemptCount, origPolicy);
                }
                throw partlyBuiltException;
            }
            if (desiredAction == IndexingPolicy.DesiredAction.REBUILD) {
                this.indexingPolicy = this.indexingPolicy.toBuilder().setIfWriteOnly(IndexingPolicy.DesiredAction.REBUILD).build();
                return this.indexingLauncher(indexingFunc, attemptCount);
            }
            throw partlyBuiltException;
        }
        if (this.indexingPolicy.isByIndex() && IndexingByIndex.isValidationException(ex)) {
            if (requestedPolicy != null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.build("The previous method's source index isn't usable. Rebuild by the requested policy", new Object[]{LogMessageKeys.CURR_ATTEMPT, attemptCount}).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
                }
                this.indexingPolicy = requestedPolicy.toBuilder().setIfWriteOnly(IndexingPolicy.DesiredAction.REBUILD).build();
                return this.indexingLauncher(indexingFunc, attemptCount);
            }
            if (!this.indexingPolicy.isForbidRecordScan() && !this.fallbackToRecordsScan) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.build("Fallback to a by-record scan", new Object[]{LogMessageKeys.CURR_ATTEMPT, attemptCount}).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
                }
                this.fallbackToRecordsScan = true;
                return this.indexingLauncher(indexingFunc, attemptCount);
            }
        }
        if (this.indexingPolicy.isMutual() && (unexpectedReadableException = IndexingBase.getUnexpectedReadableIfApplicable(ex)) != null) {
            if (unexpectedReadableException.allReadable) {
                return AsyncUtil.DONE;
            }
            this.fallbackToRecordsScan = true;
            return this.indexingLauncher(indexingFunc, attemptCount);
        }
        throw FDBExceptions.wrapException(ex);
    }

    @Nonnull
    private IndexingByIndex getIndexerByIndex() {
        if (!(this.indexer instanceof IndexingByIndex)) {
            this.indexer = new IndexingByIndex(this.common, this.indexingPolicy);
        }
        return (IndexingByIndex)this.indexer;
    }

    @Nonnull
    private IndexingMultiTargetByRecords getIndexerMultiTargetByRecords() {
        if (!(this.indexer instanceof IndexingMultiTargetByRecords)) {
            this.indexer = new IndexingMultiTargetByRecords(this.common, this.indexingPolicy);
        }
        return (IndexingMultiTargetByRecords)this.indexer;
    }

    @Nonnull
    private IndexingMutuallyByRecords getMutualIndexerByRecords() {
        if (!(this.indexer instanceof IndexingMutuallyByRecords)) {
            this.indexer = new IndexingMutuallyByRecords(this.common, this.indexingPolicy, this.indexingPolicy.mutualIndexingBoundaries);
        }
        return (IndexingMutuallyByRecords)this.indexer;
    }

    @Nonnull
    private IndexingBase getIndexer() {
        if (this.indexingPolicy.isMutual() && !this.fallbackToRecordsScan) {
            return this.getMutualIndexerByRecords();
        }
        if (this.indexingPolicy.isByIndex() && !this.common.isMultiTarget() && !this.fallbackToRecordsScan) {
            return this.getIndexerByIndex();
        }
        IndexingMultiTargetByRecords indexingBase = this.getIndexerMultiTargetByRecords();
        if (this.fallbackToRecordsScan) {
            indexingBase.enforceStampOverwrite();
        }
        return indexingBase;
    }

    @Nonnull
    @VisibleForTesting
    OnlineIndexOperationConfig getConfig() {
        return this.common.config;
    }

    @VisibleForTesting
    int getConfigLoaderInvocationCount() {
        return this.common.getConfigLoaderInvocationCount();
    }

    public int getLimit() {
        return this.getIndexer().getLimit();
    }

    private CompletableFuture<FDBRecordStore> openRecordStore(@Nonnull FDBRecordContext context) {
        return this.common.getRecordStoreBuilder().copyBuilder().setContext(context).openAsync();
    }

    @Override
    public void close() {
        this.common.close();
    }

    @VisibleForTesting
    <R> CompletableFuture<R> buildCommitRetryAsync(@Nonnull BiFunction<FDBRecordStore, AtomicLong, CompletableFuture<R>> buildFunction, @Nullable List<Object> additionalLogMessageKeyValues) {
        return this.getIndexer().buildCommitRetryAsync(buildFunction, additionalLogMessageKeyValues, true);
    }

    @VisibleForTesting
    public CompletableFuture<Void> eraseIndexingTypeStampTestOnly() {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> {
            Transaction transaction = store.getContext().ensureActive();
            for (Index targetIndex : this.common.getTargetIndexes()) {
                byte[] stampKey = IndexingSubspaces.indexBuildTypeSubspace(store, targetIndex).getKey();
                transaction.clear(stampKey);
            }
            return AsyncUtil.DONE;
        }));
    }

    @Nonnull
    public CompletableFuture<Void> rebuildIndexAsync(@Nonnull FDBRecordStore store) {
        return this.indexingLauncher(() -> this.getIndexer().rebuildIndexAsync(store));
    }

    public void rebuildIndex(@Nonnull FDBRecordStore store) {
        this.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_BUILD_INDEX, this.rebuildIndexAsync(store));
    }

    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<Void> mergeIndexAsync() {
        return this.indexingLauncher(() -> this.getIndexer().mergeIndexes());
    }

    @API(value=API.Status.EXPERIMENTAL)
    public void mergeIndex() {
        this.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_MERGE_INDEX, this.mergeIndexAsync());
    }

    @API(value=API.Status.DEPRECATED)
    public CompletableFuture<Void> stopOngoingOnlineIndexBuildsAsync() {
        return this.runner.runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenAccept(recordStore -> OnlineIndexer.stopOngoingOnlineIndexBuilds(recordStore, this.index)), this.common.indexLogMessageKeyValues("OnlineIndexer::stopOngoingOnlineIndexBuilds"));
    }

    @API(value=API.Status.DEPRECATED)
    public void stopOngoingOnlineIndexBuilds() {
        this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_STOP_ONLINE_INDEX_BUILD, this.stopOngoingOnlineIndexBuildsAsync());
    }

    @API(value=API.Status.DEPRECATED)
    public static void stopOngoingOnlineIndexBuilds(@Nonnull FDBRecordStore recordStore, @Nonnull Index index) {
        SynchronizedSession.endAnySession(recordStore.ensureContextActive(), IndexingSubspaces.indexBuildLockSubspace(recordStore, index));
    }

    public boolean checkAnyOngoingOnlineIndexBuilds() {
        return this.runner.asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_ONGOING_ONLINE_INDEX_BUILD, this.checkAnyOngoingOnlineIndexBuildsAsync());
    }

    public CompletableFuture<Boolean> checkAnyOngoingOnlineIndexBuildsAsync() {
        return this.runner.runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(recordStore -> OnlineIndexer.checkAnyOngoingOnlineIndexBuildsAsync(recordStore, this.index, this.common.config.getLeaseLengthMillis())), this.common.indexLogMessageKeyValues("OnlineIndexer::checkAnyOngoingOnlineIndexBuilds"));
    }

    public static CompletableFuture<Boolean> checkAnyOngoingOnlineIndexBuildsAsync(@Nonnull FDBRecordStore recordStore, @Nonnull Index index) {
        return OnlineIndexer.checkAnyOngoingOnlineIndexBuildsAsync(recordStore, index, 10000L);
    }

    public static CompletableFuture<Boolean> checkAnyOngoingOnlineIndexBuildsAsync(@Nonnull FDBRecordStore recordStore, @Nonnull Index index, long leasingMilliseconds) {
        return IndexingHeartbeat.getIndexingHeartbeats(recordStore, index, 0).thenApply(list -> {
            long activeTime = System.currentTimeMillis() + leasingMilliseconds;
            return list.values().stream().anyMatch(item -> item.getHeartbeatTimeMilliseconds() < activeTime);
        });
    }

    @Nonnull
    public CompletableFuture<Void> buildIndexAsync() {
        return this.buildIndexAsync(true);
    }

    @Nonnull
    @VisibleForTesting
    CompletableFuture<Void> buildIndexAsync(boolean markReadable) {
        return this.indexingLauncher(() -> this.getIndexer().buildIndexAsync(markReadable));
    }

    public void buildIndex(boolean markReadable) {
        this.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_BUILD_INDEX, this.buildIndexAsync(markReadable));
    }

    public void buildIndex() {
        this.asyncToSync(FDBStoreTimer.Waits.WAIT_ONLINE_BUILD_INDEX, this.buildIndexAsync());
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<Boolean> markReadableIfBuilt() {
        return this.getIndexer().markReadableIfBuilt();
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<Boolean> markReadable() {
        return this.getIndexer().markIndexReadable(true);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public Map<String, IndexBuildProto.IndexBuildIndexingStamp> queryIndexingStamps() {
        return this.indexingStamp(IndexingBase.IndexingStampOperation.QUERY, null, null);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public Map<String, IndexBuildProto.IndexBuildIndexingStamp> blockIndexBuilds(@Nullable String id, @Nullable Long ttlSeconds) {
        return this.indexingStamp(IndexingBase.IndexingStampOperation.BLOCK, id, ttlSeconds);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public Map<String, IndexBuildProto.IndexBuildIndexingStamp> unblockIndexBuilds(@Nullable String id) {
        return this.indexingStamp(IndexingBase.IndexingStampOperation.UNBLOCK, id, null);
    }

    private Map<String, IndexBuildProto.IndexBuildIndexingStamp> indexingStamp(@Nullable IndexingBase.IndexingStampOperation op, @Nullable String id, @Nullable Long ttlSeconds) {
        return this.asyncToSync(FDBStoreTimer.Waits.WAIT_INDEX_TYPESTAMP_OPERATION, this.getIndexer().performIndexingStampOperation(op, id, ttlSeconds));
    }

    @API(value=API.Status.EXPERIMENTAL)
    public Map<UUID, IndexBuildProto.IndexBuildHeartbeat> getIndexingHeartbeats(int maxCount) {
        return this.asyncToSync(FDBStoreTimer.Waits.WAIT_INDEX_READ_HEARTBEATS, this.getIndexer().getIndexingHeartbeats(maxCount));
    }

    @API(value=API.Status.EXPERIMENTAL)
    public int clearIndexingHeartbeats(long minAgeMilliseconds, int maxIteration) {
        return this.asyncToSync(FDBStoreTimer.Waits.WAIT_INDEX_CLEAR_HEARTBEATS, this.getIndexer().clearIndexingHeartbeats(minAgeMilliseconds, maxIteration));
    }

    @API(value=API.Status.INTERNAL)
    public <T> T asyncToSync(@Nonnull StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        return this.getRunner().asyncToSync(event, async);
    }

    @API(value=API.Status.INTERNAL)
    @VisibleForTesting
    long getTotalRecordsScanned() {
        return this.common.getTotalRecordsScanned().get();
    }

    private FDBDatabaseRunner getRunner() {
        return this.runner;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static OnlineIndexer forRecordStoreAndIndex(@Nonnull FDBRecordStore recordStore, @Nonnull String index) {
        return ((Builder)OnlineIndexer.newBuilder().setRecordStore(recordStore)).setIndex(index).build();
    }

    public static class IndexingPolicy {
        public static final IndexingPolicy DEFAULT = IndexingPolicy.newBuilder().build();
        @Nullable
        private final String sourceIndex;
        @Nullable
        private final Object sourceIndexSubspaceKey;
        private final boolean forbidRecordScan;
        private final DesiredAction ifDisabled;
        private final DesiredAction ifWriteOnly;
        private final DesiredAction ifMismatchPrevious;
        private final DesiredAction ifReadable;
        private final boolean allowUniquePendingState;
        private final Set<TakeoverTypes> allowedTakeoverSet;
        private final boolean mutualIndexing;
        private final List<Tuple> mutualIndexingBoundaries;
        private final boolean allowUnblock;
        private final String allowUnblockId;
        private final long initialMergesCountLimit;
        private final boolean reverseScanOrder;

        private IndexingPolicy(@Nullable String sourceIndex, @Nullable Object sourceIndexSubspaceKey, boolean forbidRecordScan, DesiredAction ifDisabled, DesiredAction ifWriteOnly, DesiredAction ifMismatchPrevious, DesiredAction ifReadable, boolean allowUniquePendingState, Set<TakeoverTypes> allowedTakeoverSet, boolean mutualIndexing, List<Tuple> mutualIndexingBoundaries, boolean allowUnblock, String allowUnblockId, long initialMergesCountLimit, boolean reverseScanOrder) {
            this.sourceIndex = sourceIndex;
            this.forbidRecordScan = forbidRecordScan;
            this.sourceIndexSubspaceKey = sourceIndexSubspaceKey;
            this.ifDisabled = ifDisabled;
            this.ifWriteOnly = ifWriteOnly;
            this.ifMismatchPrevious = ifMismatchPrevious;
            this.ifReadable = ifReadable;
            this.allowUniquePendingState = allowUniquePendingState;
            this.allowedTakeoverSet = allowedTakeoverSet;
            this.mutualIndexing = mutualIndexing;
            this.mutualIndexingBoundaries = mutualIndexingBoundaries;
            this.allowUnblock = allowUnblock;
            this.allowUnblockId = allowUnblockId;
            this.initialMergesCountLimit = initialMergesCountLimit;
            this.reverseScanOrder = reverseScanOrder;
        }

        public boolean isByIndex() {
            return this.sourceIndex != null || this.sourceIndexSubspaceKey != null;
        }

        @Nullable
        public String getSourceIndex() {
            return this.sourceIndex;
        }

        @Nullable
        public Object getSourceIndexSubspaceKey() {
            return this.sourceIndexSubspaceKey;
        }

        public boolean isForbidRecordScan() {
            return this.forbidRecordScan;
        }

        public boolean isMutual() {
            return this.mutualIndexing;
        }

        @Nonnull
        public static Builder newBuilder() {
            return new Builder();
        }

        @Nonnull
        public Builder toBuilder() {
            return IndexingPolicy.newBuilder().setSourceIndex(this.sourceIndex).setSourceIndexSubspaceKey(this.sourceIndexSubspaceKey).setForbidRecordScan(this.forbidRecordScan).setIfDisabled(this.ifDisabled).setIfWriteOnly(this.ifWriteOnly).setIfMismatchPrevious(this.ifMismatchPrevious).setIfReadable(this.ifReadable).allowUniquePendingState(this.allowUniquePendingState).allowTakeoverContinue(this.allowedTakeoverSet).setMutualIndexing(this.mutualIndexing).setMutualIndexingBoundaries(this.mutualIndexingBoundaries).setAllowUnblock(this.allowUnblock, this.allowUnblockId).setInitialMergesCountLimit(this.initialMergesCountLimit).setReverseScanOrder(this.reverseScanOrder);
        }

        public DesiredAction getIfDisabled() {
            return this.ifDisabled;
        }

        public DesiredAction getIfWriteOnly() {
            return this.ifWriteOnly;
        }

        public DesiredAction getIfMismatchPrevious() {
            return this.ifMismatchPrevious;
        }

        public DesiredAction getIfReadable() {
            return this.ifReadable;
        }

        public DesiredAction getStateDesiredAction(IndexState state) {
            switch (state) {
                case DISABLED: {
                    return this.getIfDisabled();
                }
                case WRITE_ONLY: {
                    return this.getIfWriteOnly();
                }
                case READABLE: {
                    return this.getIfReadable();
                }
                case READABLE_UNIQUE_PENDING: {
                    return DesiredAction.MARK_READABLE;
                }
            }
            throw new RecordCoreException("bad index state: " + String.valueOf((Object)state), new Object[0]);
        }

        public boolean shouldAllowUniquePendingState(FDBRecordStore store) {
            return this.allowUniquePendingState && store.getFormatVersionEnum().isAtLeast(FormatVersion.READABLE_UNIQUE_PENDING);
        }

        public boolean shouldAllowTypeConversionContinue(IndexBuildProto.IndexBuildIndexingStamp newStamp, IndexBuildProto.IndexBuildIndexingStamp oldStamp) {
            IndexBuildProto.IndexBuildIndexingStamp.Method newMethod = newStamp.getMethod();
            IndexBuildProto.IndexBuildIndexingStamp.Method oldMethod = oldStamp.getMethod();
            if (newMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS) {
                if (oldMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.MULTI_TARGET_BY_RECORDS) {
                    return this.isTypeConversionAllowed(TakeoverTypes.MULTI_TARGET_TO_SINGLE);
                }
                if (oldMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.MUTUAL_BY_RECORDS) {
                    return this.isTypeConversionAllowed(TakeoverTypes.MUTUAL_TO_SINGLE);
                }
            }
            if (newMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.MUTUAL_BY_RECORDS) {
                if (!this.isTypeConversionAllowed(TakeoverTypes.BY_RECORDS_TO_MUTUAL)) {
                    return false;
                }
                if (oldMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.MULTI_TARGET_BY_RECORDS) {
                    return newStamp.getTargetIndexCount() == 1 || newStamp.getTargetIndexCount() == oldStamp.getTargetIndexCount() && new HashSet<String>(newStamp.getTargetIndexList()).containsAll(oldStamp.getTargetIndexList());
                }
                if (oldMethod == IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS) {
                    return newStamp.getTargetIndexCount() == 1;
                }
            }
            return false;
        }

        private boolean isTypeConversionAllowed(TakeoverTypes takeoverType) {
            return this.allowedTakeoverSet != null && this.allowedTakeoverSet.contains((Object)takeoverType);
        }

        public boolean shouldAllowUnblock(String stampBlockId) {
            return this.allowUnblock && (this.allowUnblockId == null || this.allowUnblockId.isEmpty() || this.allowUnblockId.equals(stampBlockId));
        }

        @API(value=API.Status.DEPRECATED)
        public long getCheckIndexingMethodFrequencyMilliseconds() {
            return 0L;
        }

        @API(value=API.Status.EXPERIMENTAL)
        public long getInitialMergesCountLimit() {
            return this.initialMergesCountLimit;
        }

        public boolean isReverseScanOrder() {
            return this.reverseScanOrder;
        }

        public static enum DesiredAction {
            ERROR,
            REBUILD,
            CONTINUE,
            MARK_READABLE;

        }

        @API(value=API.Status.UNSTABLE)
        public static class Builder {
            boolean forbidRecordScan = false;
            String sourceIndex = null;
            private Object sourceIndexSubspaceKey = null;
            private DesiredAction ifDisabled = DesiredAction.REBUILD;
            private DesiredAction ifWriteOnly = DesiredAction.CONTINUE;
            private DesiredAction ifMismatchPrevious = DesiredAction.CONTINUE;
            private DesiredAction ifReadable = DesiredAction.CONTINUE;
            private boolean doAllowUniquePendingState = false;
            private Set<TakeoverTypes> allowedTakeoverSet = null;
            private boolean useMutualIndexing = false;
            private List<Tuple> useMutualIndexingBoundaries = null;
            private boolean allowUnblock = false;
            private String allowUnblockId = null;
            private long initialMergesCountLimit = 0L;
            private boolean reverseScanOrder = false;

            protected Builder() {
            }

            public Builder setSourceIndex(@Nonnull String sourceIndex) {
                this.sourceIndex = sourceIndex;
                return this;
            }

            public Builder setSourceIndexSubspaceKey(@Nullable Object sourceIndexSubspaceKey) {
                this.sourceIndexSubspaceKey = sourceIndexSubspaceKey;
                return this;
            }

            public Builder setForbidRecordScan(boolean forbidRecordScan) {
                this.forbidRecordScan = forbidRecordScan;
                return this;
            }

            public Builder forbidRecordScan() {
                this.forbidRecordScan = true;
                return this;
            }

            public Builder setIfDisabled(DesiredAction ifDisabled) {
                this.ifDisabled = ifDisabled;
                return this;
            }

            public Builder setIfWriteOnly(DesiredAction ifWriteOnly) {
                this.ifWriteOnly = ifWriteOnly;
                return this;
            }

            public Builder setIfMismatchPrevious(DesiredAction ifMismatchPrevious) {
                this.ifMismatchPrevious = ifMismatchPrevious;
                return this;
            }

            public Builder setIfReadable(DesiredAction ifReadable) {
                this.ifReadable = ifReadable;
                return this;
            }

            public Builder allowUniquePendingState() {
                return this.allowUniquePendingState(true);
            }

            public Builder allowUniquePendingState(boolean allow) {
                this.doAllowUniquePendingState = allow;
                return this;
            }

            public Builder allowTakeoverContinue() {
                return this.allowTakeoverContinue(true);
            }

            public Builder allowTakeoverContinue(boolean allow) {
                this.allowedTakeoverSet = allow ? EnumSet.allOf(TakeoverTypes.class) : EnumSet.noneOf(TakeoverTypes.class);
                return this;
            }

            public Builder allowTakeoverContinue(@Nullable Collection<TakeoverTypes> allowedSet) {
                this.allowedTakeoverSet = allowedSet == null ? null : EnumSet.copyOf(allowedSet);
                return this;
            }

            @API(value=API.Status.DEPRECATED)
            public Builder checkIndexingStampFrequencyMilliseconds(long frequency) {
                return this;
            }

            @API(value=API.Status.EXPERIMENTAL)
            public Builder setMutualIndexing() {
                this.useMutualIndexing = true;
                return this;
            }

            @API(value=API.Status.EXPERIMENTAL)
            public Builder setMutualIndexing(boolean useMutualIndexing) {
                this.useMutualIndexing = useMutualIndexing;
                if (!useMutualIndexing) {
                    this.useMutualIndexingBoundaries = null;
                }
                return this;
            }

            @API(value=API.Status.EXPERIMENTAL)
            public Builder setMutualIndexingBoundaries(List<Tuple> primaryKeysBoundaries) {
                this.useMutualIndexingBoundaries = primaryKeysBoundaries == null || primaryKeysBoundaries.isEmpty() ? null : new ArrayList<Tuple>(primaryKeysBoundaries);
                return this;
            }

            @API(value=API.Status.EXPERIMENTAL)
            public Builder setAllowUnblock(boolean allowUnblock, @Nullable String allowUnblockId) {
                this.allowUnblock = allowUnblock;
                this.allowUnblockId = allowUnblockId;
                return this;
            }

            @API(value=API.Status.EXPERIMENTAL)
            public Builder setAllowUnblock(boolean allowUnblock) {
                return this.setAllowUnblock(allowUnblock, null);
            }

            public Builder setInitialMergesCountLimit(long initialMergesCountLimit) {
                this.initialMergesCountLimit = initialMergesCountLimit;
                return this;
            }

            public Builder setReverseScanOrder(boolean reverseScanOrder) {
                this.reverseScanOrder = reverseScanOrder;
                return this;
            }

            public IndexingPolicy build() {
                if (this.useMutualIndexingBoundaries != null) {
                    this.useMutualIndexing = true;
                }
                return new IndexingPolicy(this.sourceIndex, this.sourceIndexSubspaceKey, this.forbidRecordScan, this.ifDisabled, this.ifWriteOnly, this.ifMismatchPrevious, this.ifReadable, this.doAllowUniquePendingState, this.allowedTakeoverSet, this.useMutualIndexing, this.useMutualIndexingBoundaries, this.allowUnblock, this.allowUnblockId, this.initialMergesCountLimit, this.reverseScanOrder);
            }
        }

        public static enum TakeoverTypes {
            MULTI_TARGET_TO_SINGLE,
            MUTUAL_TO_SINGLE,
            BY_RECORDS_TO_MUTUAL;

        }
    }

    @API(value=API.Status.UNSTABLE)
    public static class Builder
    extends OnlineIndexOperationBaseBuilder<Builder> {
        @Nonnull
        private List<Index> targetIndexes = new ArrayList<Index>();
        @Nullable
        private Collection<RecordType> recordTypes;
        private IndexingPolicy indexingPolicy = null;
        private IndexingPolicy.Builder indexingPolicyBuilder = null;
        private IndexStatePrecondition indexStatePrecondition = null;

        protected Builder() {
        }

        @Override
        Builder self() {
            return this;
        }

        @Nonnull
        public Builder setIndex(@Nullable Index index) {
            if (!this.targetIndexes.isEmpty()) {
                throw new IndexingBase.ValidationException("setIndex may not be used when other target indexes are already set", new Object[0]);
            }
            if (index != null) {
                this.addTargetIndex(index);
            }
            return this;
        }

        @Nonnull
        public Builder setIndex(@Nonnull String indexName) {
            if (!this.targetIndexes.isEmpty()) {
                throw new IndexingBase.ValidationException("setIndex may not be used when other target indexes are already set", new Object[0]);
            }
            return this.addTargetIndex(indexName);
        }

        public Builder setTargetIndexes(@Nonnull List<Index> indexes) {
            this.targetIndexes = new ArrayList<Index>(indexes);
            return this;
        }

        public Builder setTargetIndexesByName(@Nonnull List<String> indexes) {
            RecordMetaData metaData = this.getRecordMetaData();
            return this.setTargetIndexes(indexes.stream().map(metaData::getIndex).collect(Collectors.toList()));
        }

        public Builder addTargetIndex(@Nonnull Index index) {
            this.targetIndexes.add(index);
            return this;
        }

        public Builder addTargetIndex(@Nonnull String indexName) {
            RecordMetaData metaData = this.getRecordMetaData();
            return this.addTargetIndex(metaData.getIndex(indexName));
        }

        @Nullable
        public Collection<RecordType> getRecordTypes() {
            return this.recordTypes;
        }

        @Nonnull
        public Builder setRecordTypes(@Nullable Collection<RecordType> recordTypes) {
            this.recordTypes = recordTypes;
            return this;
        }

        @Deprecated
        public Builder setIndexStatePrecondition(@Nonnull IndexStatePrecondition indexStatePrecondition) {
            this.indexStatePrecondition = indexStatePrecondition;
            return this;
        }

        public Builder setIndexingPolicy(@Nullable IndexingPolicy indexingPolicy) {
            this.indexingPolicyBuilder = null;
            this.indexingPolicy = indexingPolicy == null ? IndexingPolicy.DEFAULT : indexingPolicy;
            return this;
        }

        public Builder setIndexingPolicy(@Nonnull IndexingPolicy.Builder builder) {
            this.indexingPolicy = null;
            this.indexingPolicyBuilder = builder;
            return this;
        }

        public OnlineIndexer build() {
            this.determineIndexingPolicy();
            this.validate();
            OnlineIndexOperationConfig conf = this.getConfig();
            return new OnlineIndexer(this.getRunner(), this.getRecordStoreBuilder(), this.targetIndexes, this.recordTypes, this.getConfigLoader(), conf, this.isTrackProgress(), this.indexingPolicy);
        }

        private void determineIndexingPolicy() {
            if (this.indexStatePrecondition != null) {
                if (this.indexingPolicy != null) {
                    this.indexingPolicyBuilder = this.indexingPolicy.toBuilder();
                }
                if (this.indexingPolicyBuilder == null) {
                    this.indexingPolicyBuilder = IndexingPolicy.newBuilder();
                }
                this.indexingPolicyBuilder.setIfDisabled(this.indexStatePrecondition.ifDisabled).setIfWriteOnly(this.indexStatePrecondition.ifWriteOnly).setIfMismatchPrevious(this.indexStatePrecondition.ifMismatchPrevious).setIfReadable(this.indexStatePrecondition.ifReadable);
            }
            if (this.indexingPolicyBuilder != null) {
                this.indexingPolicy = this.indexingPolicyBuilder.build();
            }
            if (this.indexingPolicy == null) {
                this.indexingPolicy = IndexingPolicy.DEFAULT;
            }
        }

        private void validate() {
            RecordMetaData metaData = this.getRecordMetaData();
            this.validateIndexSetting(metaData);
            this.validateTypes(metaData);
            this.validateLimits();
        }

        private void validateIndexSetting(RecordMetaData metaData) {
            if (this.targetIndexes.isEmpty()) {
                throw new MetaDataException("index must be set", new Object[0]);
            }
            if (this.targetIndexes.size() > 1) {
                if (this.indexingPolicy.isByIndex()) {
                    throw new IndexingBase.ValidationException("Indexing multi targets by a source index is not supported (yet)", new Object[0]);
                }
                HashSet<Index> set = new HashSet<Index>(this.targetIndexes);
                if (set.size() < this.targetIndexes.size()) {
                    this.targetIndexes = new ArrayList<Index>(set);
                }
            }
            if (this.indexingPolicy.isMutual() && this.indexingPolicy.isByIndex()) {
                throw new IndexingBase.ValidationException("Indexing mutually by a source index is not supported (yet)", new Object[0]);
            }
            this.targetIndexes.sort(Comparator.comparing(Index::getName));
            for (Index index : this.targetIndexes) {
                if (metaData.hasIndex(index.getName()) && index == metaData.getIndex(index.getName())) continue;
                throw new MetaDataException("Index " + index.getName() + " not contained within specified metadata", new Object[0]);
            }
        }

        private void validateTypes(RecordMetaData metaData) {
            if (this.recordTypes != null) {
                for (RecordType recordType : this.recordTypes) {
                    if (recordType == metaData.getIndexableRecordType(recordType.getName())) continue;
                    throw new MetaDataException("Record type " + recordType.getName() + " not contained within specified metadata", new Object[0]);
                }
            }
        }
    }

    public static enum IndexStatePrecondition {
        BUILD_IF_DISABLED(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.ERROR, IndexingPolicy.DesiredAction.ERROR, IndexingPolicy.DesiredAction.ERROR),
        BUILD_IF_DISABLED_CONTINUE_BUILD_IF_WRITE_ONLY_ERROR_IF_POLICY_CHANGED(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.CONTINUE, IndexingPolicy.DesiredAction.ERROR, IndexingPolicy.DesiredAction.CONTINUE),
        BUILD_IF_DISABLED_CONTINUE_BUILD_IF_WRITE_ONLY(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.CONTINUE, IndexingPolicy.DesiredAction.CONTINUE, IndexingPolicy.DesiredAction.CONTINUE),
        BUILD_IF_DISABLED_CONTINUE_BUILD_IF_WRITE_ONLY_REBUILD_IF_POLICY_CHANGED(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.CONTINUE, IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.CONTINUE),
        BUILD_IF_DISABLED_REBUILD_IF_WRITE_ONLY(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.CONTINUE),
        FORCE_BUILD(IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.REBUILD, IndexingPolicy.DesiredAction.REBUILD),
        ERROR_IF_DISABLED_CONTINUE_IF_WRITE_ONLY(IndexingPolicy.DesiredAction.ERROR, IndexingPolicy.DesiredAction.CONTINUE, IndexingPolicy.DesiredAction.ERROR, IndexingPolicy.DesiredAction.ERROR);

        public final IndexingPolicy.DesiredAction ifDisabled;
        public final IndexingPolicy.DesiredAction ifWriteOnly;
        public final IndexingPolicy.DesiredAction ifMismatchPrevious;
        public final IndexingPolicy.DesiredAction ifReadable;

        private IndexStatePrecondition(IndexingPolicy.DesiredAction ifDisabled, IndexingPolicy.DesiredAction ifWriteOnly, IndexingPolicy.DesiredAction ifMismatchPrevious, IndexingPolicy.DesiredAction ifReadable) {
            this.ifDisabled = ifDisabled;
            this.ifWriteOnly = ifWriteOnly;
            this.ifMismatchPrevious = ifMismatchPrevious;
            this.ifReadable = ifReadable;
        }
    }

    @API(value=API.Status.DEPRECATED)
    public static class RecordBuiltRangeException
    extends RecordCoreException {
        public RecordBuiltRangeException(@Nullable Tuple start, @Nullable Tuple end) {
            super("Range specified as unbuilt contained subranges that had already been built", new Object[0]);
            this.addLogInfo(new Object[]{LogMessageKeys.RANGE_START, start});
            this.addLogInfo(new Object[]{LogMessageKeys.RANGE_END, end});
        }
    }
}

