/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordSortingProto;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class SortedRecordSerializer<M extends Message> {
    @Nonnull
    private final RecordSerializer<M> serializer;
    @Nonnull
    private final RecordMetaData recordMetaData;
    @Nullable
    private final StoreTimer timer;

    public SortedRecordSerializer(@Nonnull RecordSerializer<M> serializer, @Nonnull RecordMetaData recordMetaData, @Nullable StoreTimer timer) {
        this.serializer = serializer;
        this.recordMetaData = recordMetaData;
        this.timer = timer;
    }

    public void write(@Nonnull FDBRecord<M> rec, CodedOutputStream stream) throws IOException {
        stream.writeMessageNoTag(this.toProto(rec));
    }

    @Nonnull
    public byte[] serialize(@Nonnull FDBRecord<M> rec) {
        return this.toProto(rec).toByteArray();
    }

    @Nonnull
    public RecordSortingProto.SortedRecord toProto(@Nonnull FDBRecord<M> rec) {
        RecordSortingProto.SortedRecord.Builder builder = RecordSortingProto.SortedRecord.newBuilder();
        builder.setPrimaryKey(ZeroCopyByteString.wrap(rec.getPrimaryKey().pack()));
        builder.setMessage(ZeroCopyByteString.wrap(this.serializer.serialize(this.recordMetaData, rec.getRecordType(), rec.getRecord(), this.timer)));
        if (rec.hasVersion()) {
            builder.setVersion(ZeroCopyByteString.wrap(rec.getVersion().toBytes()));
        }
        return builder.build();
    }

    @Nonnull
    public FDBQueriedRecord<M> read(@Nonnull CodedInputStream stream) throws IOException {
        RecordSortingProto.SortedRecord.Builder builder = RecordSortingProto.SortedRecord.newBuilder();
        stream.readMessage(builder, ExtensionRegistryLite.getEmptyRegistry());
        return this.deserialize(builder.build());
    }

    @Nonnull
    public FDBQueriedRecord<M> deserialize(@Nonnull byte[] serialized) {
        RecordSortingProto.SortedRecord sortedRecord;
        try {
            sortedRecord = RecordSortingProto.SortedRecord.parseFrom(serialized);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException(ex);
        }
        return this.deserialize(sortedRecord);
    }

    @Nonnull
    public FDBQueriedRecord<M> deserialize(@Nonnull RecordSortingProto.SortedRecord sortedRecord) {
        byte[] primaryKeyBytes = sortedRecord.getPrimaryKey().toByteArray();
        Tuple primaryKey = Tuple.fromBytes(primaryKeyBytes);
        byte[] recordBytes = sortedRecord.getMessage().toByteArray();
        M record = this.serializer.deserialize(this.recordMetaData, primaryKey, recordBytes, this.timer);
        RecordType recordType = this.recordMetaData.getRecordTypeForDescriptor(record.getDescriptorForType());
        FDBRecordVersion version = sortedRecord.hasVersion() ? FDBRecordVersion.fromBytes(sortedRecord.getVersion().toByteArray()) : null;
        return new Sorted<M>(primaryKey, recordType, record, version);
    }

    public void writeSortKeyAndRecord(@Nonnull Tuple sortKey, @Nonnull FDBRecord<M> rec, @Nonnull CodedOutputStream stream) throws IOException {
        stream.writeByteArrayNoTag(sortKey.pack());
        this.write(rec, stream);
    }

    @Nonnull
    public Map.Entry<Tuple, FDBQueriedRecord<M>> readSortKeyAndRecord(@Nonnull CodedInputStream stream) throws IOException {
        return new AbstractMap.SimpleEntry<Tuple, FDBQueriedRecord<M>>(Tuple.fromBytes(stream.readByteArray()), this.read(stream));
    }

    @Nonnull
    public FDBQueriedRecord<M> skipSortKeyAndReadRecord(@Nonnull CodedInputStream stream) throws IOException {
        stream.skipRawBytes(stream.readRawVarint32());
        return this.read(stream);
    }

    static class Sorted<M extends Message>
    extends FDBQueriedRecord<M> {
        @Nonnull
        private final Tuple primaryKey;
        @Nonnull
        private final RecordType recordType;
        @Nonnull
        private final M protoRecord;
        @Nullable
        private final FDBRecordVersion version;

        public Sorted(@Nonnull Tuple primaryKey, @Nonnull RecordType recordType, @Nonnull M protoRecord, FDBRecordVersion version) {
            this.primaryKey = primaryKey;
            this.recordType = recordType;
            this.protoRecord = protoRecord;
            this.version = version;
        }

        @Override
        @Nullable
        public Index getIndex() {
            return null;
        }

        @Override
        @Nullable
        public IndexEntry getIndexEntry() {
            return null;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.recordType;
        }

        @Override
        @Nonnull
        public M getRecord() {
            return this.protoRecord;
        }

        @Override
        public boolean hasVersion() {
            return this.version != null;
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return this.version;
        }

        @Override
        @Nullable
        public FDBStoredRecord<M> getStoredRecord() {
            return null;
        }

        @Override
        @Nullable
        public FDBSyntheticRecord getSyntheticRecord() {
            return null;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(@Nonnull String constituentName) {
            return null;
        }

        @Override
        @Nullable
        public String getConstituentName() {
            return null;
        }
    }
}

