/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class SubspaceProviderByKeySpacePath
implements SubspaceProvider {
    @Nonnull
    private final KeySpacePath keySpacePath;
    @Nonnull
    private final ConcurrentHashMap<Optional<String>, Subspace> databases;

    SubspaceProviderByKeySpacePath(@Nonnull KeySpacePath keySpacePath) {
        this.keySpacePath = keySpacePath;
        this.databases = new ConcurrentHashMap();
    }

    @Nonnull
    public KeySpacePath getKeySpacePath() {
        return this.keySpacePath;
    }

    @Override
    @Nonnull
    public Subspace getSubspace(@Nonnull FDBRecordContext context) {
        return context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.getSubspaceAsync(context));
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getSubspaceAsync(@Nonnull FDBRecordContext context) {
        String clusterFile = context.getDatabase().getClusterFile();
        Optional<String> key = Optional.ofNullable(clusterFile);
        Subspace subspace = this.databases.get(key);
        CompletionStage<Subspace> subspaceFuture = subspace == null ? this.keySpacePath.toSubspaceAsync(context).whenComplete((s2, e) -> {
            if (e == null) {
                this.databases.put(key, (Subspace)s2);
            }
        }) : CompletableFuture.completedFuture(subspace);
        return subspaceFuture;
    }

    @Override
    @Nonnull
    public LogMessageKeys logKey() {
        return LogMessageKeys.KEY_SPACE_PATH;
    }

    @Override
    public String toString(@Nonnull FDBRecordContext context) {
        Optional<String> key = Optional.ofNullable(context.getDatabase().getClusterFile());
        Subspace subspace = this.databases.get(key);
        if (subspace != null) {
            return this.keySpacePath.toString(Tuple.fromBytes(subspace.pack()));
        }
        return this.toString();
    }

    @Override
    public String toString() {
        return this.keySpacePath.toString();
    }

    public int hashCode() {
        return this.keySpacePath.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        SubspaceProviderByKeySpacePath that = (SubspaceProviderByKeySpacePath)other;
        return this.keySpacePath.equals(that.keySpacePath);
    }
}

