/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class SubspaceProviderBySubspace
implements SubspaceProvider {
    @Nonnull
    private Subspace subspace;
    private int memoizedHashCode = 0;

    @API(value=API.Status.INTERNAL)
    public SubspaceProviderBySubspace(@Nonnull Subspace subspace) {
        this.subspace = subspace;
    }

    @Override
    @Nonnull
    public Subspace getSubspace(@Nonnull FDBRecordContext context) {
        return this.subspace;
    }

    @Override
    @Nonnull
    public CompletableFuture<Subspace> getSubspaceAsync(@Nonnull FDBRecordContext context) {
        return CompletableFuture.completedFuture(this.subspace);
    }

    @Override
    @Nonnull
    public LogMessageKeys logKey() {
        return LogMessageKeys.SUBSPACE;
    }

    @Override
    public String toString(@Nonnull FDBRecordContext context) {
        return this.toString();
    }

    @Override
    public String toString() {
        return ByteArrayUtil2.loggable(this.subspace.pack());
    }

    public int hashCode() {
        if (this.memoizedHashCode == 0) {
            this.memoizedHashCode = this.subspace.hashCode();
        }
        return this.memoizedHashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        SubspaceProviderBySubspace that = (SubspaceProviderBySubspace)other;
        return this.subspace.equals(that.subspace);
    }
}

