/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.clientlog;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.clientlog.TupleKeyCountTree;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpace;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpaceTreeResolver;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KeySpaceCountTree
extends TupleKeyCountTree {
    @Nullable
    private KeySpaceTreeResolver.Resolved resolved;

    public KeySpaceCountTree(@Nonnull KeySpace keySpace) {
        this.resolved = new KeySpaceTreeResolver.ResolvedRoot(keySpace);
    }

    public KeySpaceCountTree(@Nullable KeySpaceCountTree parent, @Nonnull byte[] bytes, @Nullable Object object) {
        super(parent, bytes, object);
    }

    @Override
    @Nonnull
    protected TupleKeyCountTree newChild(@Nonnull byte[] childBytes, @Nonnull Object object) {
        return new KeySpaceCountTree(this, childBytes, object);
    }

    @Override
    @Nonnull
    protected TupleKeyCountTree newPrefixChild(@Nonnull byte[] prefixBytes, @Nonnull Object prefix) {
        TupleKeyCountTree result = super.newPrefixChild(prefixBytes, prefix);
        ((KeySpaceCountTree)result).resolved = new KeySpaceTreeResolver.ResolvedPrefixRoot(this.resolved, prefix);
        return result;
    }

    public CompletableFuture<Void> resolveVisibleChildren(@Nonnull KeySpaceTreeResolver resolver) {
        if (this.resolved != null) {
            Iterator<TupleKeyCountTree> children = this.getChildren().iterator();
            return AsyncUtil.whileTrue(() -> {
                if (!children.hasNext()) {
                    return AsyncUtil.READY_FALSE;
                }
                KeySpaceCountTree child = (KeySpaceCountTree)children.next();
                if (!child.isVisible()) {
                    return AsyncUtil.READY_TRUE;
                }
                return ((CompletableFuture)child.resolve(resolver, this.resolved).thenCompose(vignore -> child.resolveVisibleChildren(resolver))).thenApply(vignore -> true);
            });
        }
        return AsyncUtil.DONE;
    }

    protected CompletableFuture<Void> resolve(@Nonnull KeySpaceTreeResolver resolver, @Nonnull KeySpaceTreeResolver.Resolved resolvedParent) {
        if (this.resolved != null || !this.hasObject()) {
            return AsyncUtil.DONE;
        }
        return resolver.resolve(resolvedParent, this.getObject()).thenAccept(resolved -> {
            if (resolved != null) {
                this.resolved = resolved;
            }
        });
    }

    @Override
    public String toString() {
        if (this.resolved != null) {
            return this.resolved.toString();
        }
        return super.toString();
    }
}

