/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BloomFilterCursorContinuation
implements RecordCursorContinuation {
    @Nonnull
    private final RecordCursorContinuation childContinuation;
    @Nullable
    private final ByteString bloomBytes;
    @Nullable
    private RecordCursorProto.ProbableIntersectionContinuation.CursorState cachedProto;
    @Nullable
    private byte[] cachedBytes;
    @Nullable
    private ByteString cachedByteString;

    BloomFilterCursorContinuation(@Nonnull RecordCursorContinuation childContinuation, @Nullable ByteString bloomBytes) {
        this.childContinuation = childContinuation;
        this.bloomBytes = bloomBytes;
    }

    @Nonnull
    RecordCursorProto.ProbableIntersectionContinuation.CursorState toProto() {
        if (this.cachedProto == null) {
            RecordCursorProto.ProbableIntersectionContinuation.CursorState.Builder builder = RecordCursorProto.ProbableIntersectionContinuation.CursorState.newBuilder();
            if (this.childContinuation.isEnd()) {
                builder.setExhausted(true);
            } else {
                ByteString childBytes = this.childContinuation.toByteString();
                if (!childBytes.isEmpty()) {
                    builder.setContinuation(childBytes);
                }
            }
            if (this.bloomBytes != null) {
                builder.setBloomFilter(this.bloomBytes);
            }
            this.cachedProto = builder.build();
        }
        return this.cachedProto;
    }

    @Override
    @Nullable
    public byte[] toBytes() {
        if (this.cachedBytes == null) {
            this.cachedBytes = this.toByteString().toByteArray();
        }
        return this.cachedBytes;
    }

    @Override
    @Nonnull
    public ByteString toByteString() {
        if (this.cachedByteString == null) {
            this.cachedByteString = this.toProto().toByteString();
        }
        return this.cachedByteString;
    }

    @Nonnull
    RecordCursorContinuation getChild() {
        return this.childContinuation;
    }

    @Nullable
    ByteString getBloomBytes() {
        return this.bloomBytes;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    boolean isChildEnd() {
        return this.childContinuation.isEnd();
    }
}

