/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ComparatorCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyComparisons;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyedMergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursor;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class ComparatorCursor<T>
extends MergeCursor<T, T, KeyedMergeCursorState<T>> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(ComparatorCursor.class);
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_COMPARATOR);
    @Nonnull
    private static final Set<StoreTimer.Count> matchesCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_COMPARATOR_MATCH);
    @Nonnull
    private static final Set<StoreTimer.Count> mismatchesCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_COMPARATOR_MISMATCH);
    @Nonnull
    private static final Set<StoreTimer.Count> compareCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_COMPARATOR_COMPARED);
    private final int referencePlanIndex;
    @Nonnull
    private final Supplier<String> planStringSupplier;
    @Nonnull
    private final Supplier<Integer> planHashSupplier;
    private boolean errorLogged = false;
    private final boolean abortOnComparisonFailure;

    private ComparatorCursor(@Nonnull List<KeyedMergeCursorState<T>> cursorStates, @Nullable FDBStoreTimer timer, int referencePlanIndex, boolean abortOnComparisonFailure, @Nonnull Supplier<String> planStringSupplier, @Nonnull Supplier<Integer> planHashSupplier) {
        super(cursorStates, timer);
        this.referencePlanIndex = referencePlanIndex;
        this.abortOnComparisonFailure = abortOnComparisonFailure;
        this.planStringSupplier = planStringSupplier;
        this.planHashSupplier = planHashSupplier;
    }

    @Nonnull
    public static <M extends Message> ComparatorCursor<QueryResult> create(@Nonnull FDBRecordStoreBase<M> store, @Nonnull KeyExpression comparisonKey, @Nonnull List<Function<byte[], RecordCursor<QueryResult>>> cursorFunctions, @Nullable byte[] continuation, int referencePlanIndex, boolean abortOnComparisonFailure, @Nonnull Supplier<String> planStringSupplier, @Nonnull Supplier<Integer> planHashSupplier) {
        return ComparatorCursor.create((? super T queryResult) -> ComparatorCursor.evaluateKey(comparisonKey, queryResult.getMessage()), cursorFunctions, continuation, store.getTimer(), referencePlanIndex, abortOnComparisonFailure, planStringSupplier, planHashSupplier);
    }

    @Nonnull
    public static <T> ComparatorCursor<T> create(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, @Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] continuation, @Nullable FDBStoreTimer timer, int referencePlanIndex, boolean abortOnComparisonFailure, @Nonnull Supplier<String> planStringSupplier, @Nonnull Supplier<Integer> planHashSupplier) {
        return new ComparatorCursor<T>(ComparatorCursor.createCursorStates(cursorFunctions, continuation, comparisonKeyFunction, referencePlanIndex), timer, referencePlanIndex, abortOnComparisonFailure, planStringSupplier, planHashSupplier);
    }

    @Override
    @Nonnull
    protected RecordCursor.NoNextReason mergeNoNextReasons() {
        return ComparatorCursor.getStrongestNoNextReason(this.getCursorStates());
    }

    @Override
    @Nonnull
    public ComparatorCursorContinuation getContinuationObject() {
        return ComparatorCursorContinuation.from(this);
    }

    public int getReferencePlanIndex() {
        return this.referencePlanIndex;
    }

    @Override
    @Nonnull
    protected T getNextResult(@Nonnull List<KeyedMergeCursorState<T>> cursorStates) {
        return Objects.requireNonNull(Objects.requireNonNull(this.getReferenceState(cursorStates).getResult()).get());
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<KeyedMergeCursorState<T>>> computeNextResultStates() {
        List cursorStates = this.getCursorStates();
        return ComparatorCursor.whenAll(cursorStates).thenApply(vignore -> {
            if (cursorStates.stream().allMatch(this::hasNext)) {
                this.compareAllStates(cursorStates);
                return cursorStates;
            }
            if (cursorStates.stream().anyMatch(this::isOutOfBand)) {
                return Collections.emptyList();
            }
            long exhaustedCount = cursorStates.stream().filter(this::isSourceExhausted).count();
            if (exhaustedCount == (long)cursorStates.size()) {
                return Collections.emptyList();
            }
            if (exhaustedCount > 0L) {
                this.logTerminationFailure(this.getReferenceState(cursorStates));
                if (this.abortOnComparisonFailure) {
                    throw new RecordCoreException("Not all cursors are exhausted", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, this.isSourceExhausted(this.getReferenceState(cursorStates))}).addLogInfo(new Object[]{LogMessageKeys.PLAN_HASH, this.planHashSupplier.get()});
                }
            }
            if (!this.hasNext(this.getReferenceState(cursorStates))) {
                return Collections.emptyList();
            }
            return cursorStates;
        });
    }

    @Nonnull
    protected KeyedMergeCursorState<T> getReferenceState(List<KeyedMergeCursorState<T>> cursorStates) {
        return cursorStates.get(this.referencePlanIndex);
    }

    @Nonnull
    private static <T> List<KeyedMergeCursorState<T>> createCursorStates(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, int referencePlanIndex) {
        ArrayList<KeyedMergeCursorState<T>> cursorStates = new ArrayList<KeyedMergeCursorState<T>>(cursorFunctions.size());
        ComparatorCursorContinuation continuation = ComparatorCursorContinuation.from(byteContinuation, cursorFunctions.size(), referencePlanIndex);
        int i = 0;
        for (Function<byte[], RecordCursor<T>> cursorFunction : cursorFunctions) {
            cursorStates.add(KeyedMergeCursorState.from(cursorFunction, (RecordCursorContinuation)continuation.getContinuations().get(i), comparisonKeyFunction));
            ++i;
        }
        return cursorStates;
    }

    @Nonnull
    private static <M extends Message> List<Object> evaluateKey(@Nonnull KeyExpression comparisonKey, M message) {
        List<Key.Evaluated> keys = comparisonKey.evaluateMessage(null, message);
        if (keys.size() != 1) {
            return Collections.singletonList(new Unequal());
        }
        return keys.get(0).toTupleAppropriateList();
    }

    @CanIgnoreReturnValue
    private boolean compareAllStates(@Nonnull List<KeyedMergeCursorState<T>> cursorStates) {
        long startTime = System.nanoTime();
        List<Object> referenceKey = this.getReferenceState(cursorStates).getComparisonKey();
        for (KeyedMergeCursorState<T> cursorState : cursorStates) {
            int compare;
            if (cursorState.getComparisonKey() == referenceKey || (compare = KeyComparisons.KEY_COMPARATOR.compare(cursorState.getComparisonKey(), referenceKey)) == 0) continue;
            this.logComparisonFailure(referenceKey, cursorState.getComparisonKey());
            if (this.abortOnComparisonFailure) {
                throw new RecordCoreException("Comparison of plans failed", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, referenceKey}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL, cursorState.getComparisonKey()}).addLogInfo(new Object[]{LogMessageKeys.PLAN_HASH, this.planHashSupplier.get()});
            }
            return false;
        }
        this.logCounters(cursorStates, startTime);
        return true;
    }

    private boolean hasNext(KeyedMergeCursorState<T> cursorState) {
        return cursorState.getResult() != null && cursorState.getResult().hasNext();
    }

    private boolean isSourceExhausted(KeyedMergeCursorState<T> cursorState) {
        if (this.hasNext(cursorState)) {
            return false;
        }
        return Objects.requireNonNull(cursorState.getResult()).getNoNextReason().isSourceExhausted();
    }

    private boolean isOutOfBand(KeyedMergeCursorState<T> cursorState) {
        if (this.hasNext(cursorState)) {
            return false;
        }
        return Objects.requireNonNull(cursorState.getResult()).getNoNextReason().isOutOfBand();
    }

    private void logCounters(@Nonnull List<?> states, long startTime) {
        if (this.getTimer() != null) {
            this.getTimer().record(duringEvents, System.nanoTime() - startTime);
            this.getTimer().increment(matchesCounts, 1);
            this.getTimer().increment(compareCounts, states.size() - 1);
        }
    }

    private void logComparisonFailure(List<Object> expectedKey, List<Object> actualKey) {
        if (this.getTimer() != null) {
            this.getTimer().increment(mismatchesCounts, 1);
            if (!this.errorLogged) {
                this.errorLogged = true;
                KeyValueLogMessage message = KeyValueLogMessage.build("Cursor Result Comparison Failed", new Object[]{LogMessageKeys.EXPECTED, expectedKey, LogMessageKeys.ACTUAL, actualKey, LogMessageKeys.PLAN_HASH, this.planHashSupplier.get(), LogMessageKeys.PLAN, this.planStringSupplier.get()});
                logger.error("comparison failure: {}", (Object)message);
            }
        }
    }

    private void logTerminationFailure(KeyedMergeCursorState<T> referenceCursorState) {
        if (this.getTimer() != null) {
            this.getTimer().increment(mismatchesCounts, 1);
            if (!this.errorLogged) {
                this.errorLogged = true;
                KeyValueLogMessage message = KeyValueLogMessage.build("Not all cursors are exhausted", new Object[]{LogMessageKeys.EXPECTED, this.isSourceExhausted(referenceCursorState), LogMessageKeys.PLAN_HASH, this.planHashSupplier.get(), LogMessageKeys.PLAN, this.planStringSupplier.get()});
                logger.error("comparison failure: {}", (Object)message);
            }
        }
    }

    private static class Unequal
    implements Comparable<Object> {
        private Unequal() {
        }

        @Override
        public int compareTo(@Nonnull Object o) {
            if (this == o) {
                return 0;
            }
            return 1;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

