/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ComparatorCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorContinuation;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ComparatorCursorContinuation
extends MergeCursorContinuation<RecordCursorProto.ComparatorContinuation.Builder, RecordCursorContinuation> {
    private final int referencePlanIndex;
    @Nonnull
    private static final RecordCursorProto.ComparatorContinuation.CursorState EXHAUSTED_PROTO = RecordCursorProto.ComparatorContinuation.CursorState.newBuilder().setStarted(true).build();
    @Nonnull
    private static final RecordCursorProto.ComparatorContinuation.CursorState START_PROTO = RecordCursorProto.ComparatorContinuation.CursorState.newBuilder().setStarted(false).build();

    private ComparatorCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations, @Nullable RecordCursorProto.ComparatorContinuation originalProto, int referencePlanIndex) {
        super(continuations, originalProto);
        this.referencePlanIndex = referencePlanIndex;
    }

    private ComparatorCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations, int referencePlanIndex) {
        this(continuations, null, referencePlanIndex);
    }

    @Override
    protected void setFirstChild(@Nonnull RecordCursorProto.ComparatorContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        this.addOtherChild(builder, continuation);
    }

    @Override
    protected void setSecondChild(@Nonnull RecordCursorProto.ComparatorContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        this.addOtherChild(builder, continuation);
    }

    @Override
    protected void addOtherChild(@Nonnull RecordCursorProto.ComparatorContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes;
        RecordCursorProto.ComparatorContinuation.CursorState cursorState = continuation.isEnd() ? EXHAUSTED_PROTO : ((asBytes = continuation.toByteString()).isEmpty() && !continuation.isEnd() ? START_PROTO : RecordCursorProto.ComparatorContinuation.CursorState.newBuilder().setStarted(true).setContinuation(asBytes).build());
        builder.addChildState(cursorState);
    }

    @Override
    @Nonnull
    protected RecordCursorProto.ComparatorContinuation.Builder newProtoBuilder() {
        return RecordCursorProto.ComparatorContinuation.newBuilder();
    }

    @Override
    public boolean isEnd() {
        return ((RecordCursorContinuation)this.getContinuations().get(this.referencePlanIndex)).isEnd();
    }

    @Nonnull
    static ComparatorCursorContinuation from(@Nonnull ComparatorCursor<?> cursor) {
        return new ComparatorCursorContinuation(cursor.getChildContinuations(), cursor.getReferencePlanIndex());
    }

    @Nonnull
    static ComparatorCursorContinuation from(@Nullable byte[] bytes, int numberOfChildren, int referencePlanIndex) {
        if (bytes == null) {
            return new ComparatorCursorContinuation(Collections.nCopies(numberOfChildren, RecordCursorStartContinuation.START), referencePlanIndex);
        }
        try {
            return ComparatorCursorContinuation.from(RecordCursorProto.ComparatorContinuation.parseFrom(bytes), numberOfChildren, referencePlanIndex);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
    }

    @Nonnull
    static ComparatorCursorContinuation from(@Nonnull RecordCursorProto.ComparatorContinuation parsed, int numberOfChildren, int referencePlanIndex) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordCursorProto.ComparatorContinuation.CursorState state : parsed.getChildStateList()) {
            if (!state.getStarted()) {
                builder.add(RecordCursorStartContinuation.START);
                continue;
            }
            if (state.hasContinuation()) {
                builder.add(ByteArrayContinuation.fromNullable(state.getContinuation().toByteArray()));
                continue;
            }
            builder.add(RecordCursorEndContinuation.END);
        }
        ImmutableCollection children = builder.build();
        if (children.size() != numberOfChildren) {
            throw new RecordCoreArgumentException("invalid continuation (extraneous child state information present)", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED_CHILD_COUNT, numberOfChildren - 2}).addLogInfo(new Object[]{LogMessageKeys.READ_CHILD_COUNT, parsed.getChildStateCount()});
        }
        return new ComparatorCursorContinuation((List<RecordCursorContinuation>)((Object)children), parsed, referencePlanIndex);
    }
}

