/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyComparisons;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyedMergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class IntersectionCursorBase<T, U>
extends MergeCursor<T, U, KeyedMergeCursorState<T>> {
    @Nonnull
    private final Function<? super T, ? extends List<Object>> comparisonKeyFunction;
    private final boolean reverse;
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_INTERSECTION);
    @Nonnull
    private static final Set<StoreTimer.Count> matchesCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_INTERSECTION_PLAN_MATCHES);
    @Nonnull
    private static final Set<StoreTimer.Count> nonmatchesCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_INTERSECTION_PLAN_NONMATCHES, FDBStoreTimer.Counts.QUERY_DISCARDED);

    protected IntersectionCursorBase(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, boolean reverse, @Nonnull List<KeyedMergeCursorState<T>> cursorStates, @Nullable FDBStoreTimer timer) {
        super(cursorStates, timer);
        this.comparisonKeyFunction = comparisonKeyFunction;
        this.reverse = reverse;
    }

    private void findMaxStates(@Nonnull List<KeyedMergeCursorState<T>> maxStates, @Nonnull List<KeyedMergeCursorState<T>> nonMaxCursors) {
        List cursorStates = this.getCursorStates();
        maxStates.add((KeyedMergeCursorState)cursorStates.get(0));
        List<Object> maxKey = ((KeyedMergeCursorState)cursorStates.get(0)).getComparisonKey();
        for (KeyedMergeCursorState cursorState : cursorStates.subList(1, cursorStates.size())) {
            int compare = KeyComparisons.KEY_COMPARATOR.compare(cursorState.getComparisonKey(), maxKey) * (this.reverse ? -1 : 1);
            if (compare == 0) {
                maxStates.add(cursorState);
                continue;
            }
            if (compare < 0) {
                nonMaxCursors.add(cursorState);
                continue;
            }
            nonMaxCursors.addAll(maxStates);
            maxStates.clear();
            maxKey = cursorState.getComparisonKey();
            maxStates.add(cursorState);
        }
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<KeyedMergeCursorState<T>>> computeNextResultStates() {
        List cursorStates = this.getCursorStates();
        return AsyncUtil.whileTrue(() -> IntersectionCursorBase.whenAll(cursorStates).thenApply(vignore -> {
            if (cursorStates.stream().anyMatch(cursorState -> !cursorState.getResult().hasNext())) {
                return false;
            }
            long startTime = System.nanoTime();
            ArrayList<KeyedMergeCursorState<T>> maxCursors = new ArrayList<KeyedMergeCursorState<T>>(cursorStates.size());
            ArrayList<KeyedMergeCursorState<KeyedMergeCursorState>> nonMaxCursors = new ArrayList<KeyedMergeCursorState<KeyedMergeCursorState>>(cursorStates.size());
            this.findMaxStates(maxCursors, nonMaxCursors);
            this.logDuplicates(maxCursors, nonMaxCursors, startTime);
            if (!nonMaxCursors.isEmpty()) {
                nonMaxCursors.forEach(KeyedMergeCursorState::consume);
            }
            return !nonMaxCursors.isEmpty();
        }), this.getExecutor()).thenApply(vignore -> {
            if (cursorStates.stream().anyMatch(cursorState -> !cursorState.getResult().hasNext())) {
                return Collections.emptyList();
            }
            return cursorStates;
        });
    }

    private void logDuplicates(@Nonnull List<?> maxStates, @Nonnull List<?> nonMaxStates, long startTime) {
        if (this.getTimer() != null) {
            if (nonMaxStates.isEmpty()) {
                this.getTimer().record(duringEvents, System.nanoTime() - startTime);
                this.getTimer().increment(matchesCounts, maxStates.size() - 1);
            } else {
                this.getTimer().record(duringEvents, System.nanoTime() - startTime);
                this.getTimer().increment(nonmatchesCounts, nonMaxStates.size());
            }
        }
    }

    @Nonnull
    protected Function<? super T, ? extends List<Object>> getComparisonKeyFunction() {
        return this.comparisonKeyFunction;
    }

    @Override
    @Nonnull
    protected RecordCursor.NoNextReason mergeNoNextReasons() {
        return IntersectionCursorBase.getWeakestNoNextReason(this.getCursorStates());
    }

    @Override
    @Nonnull
    public IntersectionCursorContinuation getContinuationObject() {
        return IntersectionCursorContinuation.from(this);
    }

    @Nonnull
    protected static <T> List<KeyedMergeCursorState<T>> createCursorStates(@Nonnull Function<byte[], RecordCursor<T>> left, @Nonnull Function<byte[], RecordCursor<T>> right, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        IntersectionCursorContinuation continuation = IntersectionCursorContinuation.from(byteContinuation, 2);
        return ImmutableList.of(KeyedMergeCursorState.from(left, (RecordCursorContinuation)continuation.getContinuations().get(0), comparisonKeyFunction), KeyedMergeCursorState.from(right, (RecordCursorContinuation)continuation.getContinuations().get(1), comparisonKeyFunction));
    }

    @Nonnull
    protected static <T> List<KeyedMergeCursorState<T>> createCursorStates(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        if (cursorFunctions.size() < 2) {
            throw new RecordCoreArgumentException("not enough child cursors provided to IntersectionCursor", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CHILD_COUNT, cursorFunctions.size()});
        }
        ArrayList<KeyedMergeCursorState<T>> cursorStates = new ArrayList<KeyedMergeCursorState<T>>(cursorFunctions.size());
        IntersectionCursorContinuation continuation = IntersectionCursorContinuation.from(byteContinuation, cursorFunctions.size());
        int i = 0;
        for (Function<byte[], RecordCursor<T>> cursorFunction : cursorFunctions) {
            cursorStates.add(KeyedMergeCursorState.from(cursorFunction, (RecordCursorContinuation)continuation.getContinuations().get(i), comparisonKeyFunction));
            ++i;
        }
        return cursorStates;
    }
}

