/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionCursorBase;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorContinuation;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class IntersectionCursorContinuation
extends MergeCursorContinuation<RecordCursorProto.IntersectionContinuation.Builder, RecordCursorContinuation> {
    @Nonnull
    private static final RecordCursorProto.IntersectionContinuation.CursorState EXHAUSTED_PROTO = RecordCursorProto.IntersectionContinuation.CursorState.newBuilder().setStarted(true).build();
    @Nonnull
    private static final RecordCursorProto.IntersectionContinuation.CursorState START_PROTO = RecordCursorProto.IntersectionContinuation.CursorState.newBuilder().setStarted(false).build();

    private IntersectionCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations, @Nullable RecordCursorProto.IntersectionContinuation originalProto) {
        super(continuations, originalProto);
    }

    private IntersectionCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations) {
        this(continuations, null);
    }

    @Override
    protected void setFirstChild(@Nonnull RecordCursorProto.IntersectionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes = continuation.toByteString();
        if (asBytes.isEmpty() && !continuation.isEnd()) {
            builder.setFirstStarted(false);
        } else {
            builder.setFirstStarted(true);
            if (!asBytes.isEmpty()) {
                builder.setFirstContinuation(asBytes);
            }
        }
    }

    @Override
    protected void setSecondChild(@Nonnull RecordCursorProto.IntersectionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes = continuation.toByteString();
        if (asBytes.isEmpty() && !continuation.isEnd()) {
            builder.setSecondStarted(false);
        } else {
            builder.setSecondStarted(true);
            if (!asBytes.isEmpty()) {
                builder.setSecondContinuation(asBytes);
            }
        }
    }

    @Override
    protected void addOtherChild(@Nonnull RecordCursorProto.IntersectionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes;
        RecordCursorProto.IntersectionContinuation.CursorState cursorState = continuation.isEnd() ? EXHAUSTED_PROTO : ((asBytes = continuation.toByteString()).isEmpty() && !continuation.isEnd() ? START_PROTO : RecordCursorProto.IntersectionContinuation.CursorState.newBuilder().setStarted(true).setContinuation(asBytes).build());
        builder.addOtherChildState(cursorState);
    }

    @Override
    @Nonnull
    protected RecordCursorProto.IntersectionContinuation.Builder newProtoBuilder() {
        return RecordCursorProto.IntersectionContinuation.newBuilder();
    }

    @Override
    public boolean isEnd() {
        return this.getContinuations().stream().anyMatch(RecordCursorContinuation::isEnd);
    }

    @Nonnull
    static IntersectionCursorContinuation from(@Nonnull IntersectionCursorBase<?, ?> cursor) {
        return new IntersectionCursorContinuation(cursor.getChildContinuations());
    }

    @Nonnull
    static IntersectionCursorContinuation from(@Nullable byte[] bytes, int numberOfChildren) {
        if (bytes == null) {
            return new IntersectionCursorContinuation(Collections.nCopies(numberOfChildren, RecordCursorStartContinuation.START));
        }
        try {
            return IntersectionCursorContinuation.from(RecordCursorProto.IntersectionContinuation.parseFrom(bytes), numberOfChildren);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
    }

    @Nonnull
    static IntersectionCursorContinuation from(@Nonnull RecordCursorProto.IntersectionContinuation parsed, int numberOfChildren) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!parsed.getFirstStarted()) {
            builder.add(RecordCursorStartContinuation.START);
        } else if (parsed.hasFirstContinuation()) {
            builder.add(ByteArrayContinuation.fromNullable(parsed.getFirstContinuation().toByteArray()));
        } else {
            builder.add(RecordCursorEndContinuation.END);
        }
        if (!parsed.getSecondStarted()) {
            builder.add(RecordCursorStartContinuation.START);
        } else if (parsed.hasSecondContinuation()) {
            builder.add(ByteArrayContinuation.fromNullable(parsed.getSecondContinuation().toByteArray()));
        } else {
            builder.add(RecordCursorEndContinuation.END);
        }
        for (RecordCursorProto.IntersectionContinuation.CursorState state : parsed.getOtherChildStateList()) {
            if (!state.getStarted()) {
                builder.add(RecordCursorStartContinuation.START);
                continue;
            }
            if (state.hasContinuation()) {
                builder.add(ByteArrayContinuation.fromNullable(state.getContinuation().toByteArray()));
                continue;
            }
            builder.add(RecordCursorEndContinuation.END);
        }
        ImmutableCollection children = builder.build();
        if (children.size() != numberOfChildren) {
            throw new RecordCoreArgumentException("invalid continuation (extraneous child state information present)", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED_CHILD_COUNT, numberOfChildren - 2}).addLogInfo(new Object[]{LogMessageKeys.READ_CHILD_COUNT, parsed.getOtherChildStateCount()});
        }
        return new IntersectionCursorContinuation((List<RecordCursorContinuation>)((Object)children), parsed);
    }
}

