/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.Comparator;
import java.util.List;

@API(value=API.Status.UNSTABLE)
public class KeyComparisons {
    public static final Comparator<Object> FIELD_COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof byte[]) {
            return ByteArrayUtil.compareUnsigned((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof List) {
            return KEY_COMPARATOR.compare((List)o1, (List)o2);
        }
        return ((Comparable)o1).compareTo(o2);
    };
    public static final Comparator<List<Object>> KEY_COMPARATOR = (l1, l2) -> {
        int i = 0;
        while (true) {
            if (i >= l1.size()) {
                if (i >= l2.size()) {
                    return 0;
                }
                return -1;
            }
            if (i >= l2.size()) {
                return 1;
            }
            int compare = FIELD_COMPARATOR.compare(l1.get(i), l2.get(i));
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
    };

    private KeyComparisons() {
    }
}

