/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorState;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class KeyedMergeCursorState<T>
extends MergeCursorState<T> {
    @Nonnull
    private final Function<? super T, ? extends List<Object>> comparisonKeyFunction;
    @Nullable
    private List<Object> comparisonKey;

    KeyedMergeCursorState(@Nonnull RecordCursor<T> cursor, @Nonnull RecordCursorContinuation continuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        super(cursor, continuation);
        this.comparisonKeyFunction = comparisonKeyFunction;
    }

    @Override
    protected void handleNextCursorResult(@Nonnull RecordCursorResult<T> cursorResult) {
        super.handleNextCursorResult(cursorResult);
        if (cursorResult.hasNext()) {
            this.comparisonKey = this.comparisonKeyFunction.apply(cursorResult.get());
        }
    }

    @Nullable
    public List<Object> getComparisonKey() {
        return this.comparisonKey;
    }

    @Override
    public void consume() {
        super.consume();
        this.comparisonKey = null;
    }

    @Nonnull
    public static <T> KeyedMergeCursorState<T> from(@Nonnull Function<byte[], RecordCursor<T>> cursorFunction, @Nonnull RecordCursorContinuation continuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        if (continuation.isEnd()) {
            return new KeyedMergeCursorState<T>(RecordCursor.empty(), RecordCursorEndContinuation.END, comparisonKeyFunction);
        }
        return new KeyedMergeCursorState<T>(cursorFunction.apply(continuation.toBytes()), continuation, comparisonKeyFunction);
    }
}

