/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.cursors.EmptyCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnorderedUnionCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class MergeCursor<T, U, S extends MergeCursorState<T>>
implements RecordCursor<U> {
    private static final long MAX_NEXT_STATE_MILLIS = TimeUnit.SECONDS.toMillis(15L);
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(UnorderedUnionCursor.class);
    @Nonnull
    private final List<S> cursorStates;
    @Nullable
    private final FDBStoreTimer timer;
    @Nonnull
    private final Executor executor;
    @Nullable
    private RecordCursorResult<U> nextResult;

    protected MergeCursor(@Nonnull List<S> cursorStates, @Nullable FDBStoreTimer timer) {
        this.cursorStates = cursorStates;
        this.timer = timer;
        Executor cursorExecutor = null;
        for (MergeCursorState cursorState : cursorStates) {
            if (cursorState.getCursor() instanceof EmptyCursor) continue;
            cursorExecutor = cursorState.getExecutor();
            break;
        }
        this.executor = cursorExecutor != null ? cursorExecutor : ((MergeCursorState)cursorStates.get(0)).getExecutor();
    }

    private static <T, S extends MergeCursorState<T>> CompletableFuture<?>[] getOnNextFutures(@Nonnull List<S> cursorStates) {
        CompletableFuture[] futures = new CompletableFuture[cursorStates.size()];
        int i = 0;
        for (MergeCursorState cursorState : cursorStates) {
            futures[i] = cursorState.getOnNextFuture();
            ++i;
        }
        return futures;
    }

    @Nonnull
    protected static <T, S extends MergeCursorState<T>> CompletableFuture<Void> whenAll(@Nonnull List<S> cursorStates) {
        return CompletableFuture.allOf(MergeCursor.getOnNextFutures(cursorStates));
    }

    @Nonnull
    protected static <T, S extends MergeCursorState<T>> CompletableFuture<?> whenAny(@Nonnull List<S> cursorStates) {
        ArrayList<MergeCursorState> nonDoneCursors = new ArrayList<MergeCursorState>(cursorStates.size());
        for (MergeCursorState cursorState : cursorStates) {
            if (!cursorState.mightHaveNext()) continue;
            if (MoreAsyncUtil.isCompletedNormally(cursorState.getOnNextFuture())) {
                return AsyncUtil.DONE;
            }
            nonDoneCursors.add(cursorState);
        }
        if (nonDoneCursors.isEmpty()) {
            return AsyncUtil.DONE;
        }
        return CompletableFuture.anyOf(MergeCursor.getOnNextFutures(nonDoneCursors));
    }

    protected void checkNextStateTimeout(long startTime) {
        long checkStateTime = System.currentTimeMillis();
        if (checkStateTime - startTime > MAX_NEXT_STATE_MILLIS) {
            KeyValueLogMessage logMessage = KeyValueLogMessage.build("time computing next state exceeded", new Object[]{LogMessageKeys.TIME_STARTED, (double)startTime * 0.001, LogMessageKeys.TIME_ENDED, (double)checkStateTime * 0.001, LogMessageKeys.DURATION_MILLIS, checkStateTime - startTime, LogMessageKeys.CHILD_COUNT, this.cursorStates.size()});
            if (LOGGER.isDebugEnabled()) {
                logMessage.addKeyAndValue("child_states", this.cursorStates.stream().map((? super T cursorState) -> "(future=" + String.valueOf(cursorState.getOnNextFuture()) + ", result=" + String.valueOf(cursorState.getResult() == null ? "null" : Boolean.valueOf(cursorState.getResult().hasNext())) + ", cursorClass=" + cursorState.getCursor().getClass().getName() + ")").collect(Collectors.toList()));
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(logMessage.toString());
            }
            throw new RecordCoreException("time computing next state exceeded", new Object[0]);
        }
    }

    @Nonnull
    protected static <T, S extends MergeCursorState<T>> RecordCursor.NoNextReason getStrongestNoNextReason(@Nonnull List<S> cursorStates) {
        RecordCursor.NoNextReason reason = null;
        for (MergeCursorState cursorState : cursorStates) {
            RecordCursorResult childResult = cursorState.getResult();
            if (childResult == null || childResult.hasNext()) continue;
            RecordCursor.NoNextReason childReason = cursorState.getResult().getNoNextReason();
            if (reason != null && !childReason.isOutOfBand() && !reason.isSourceExhausted()) continue;
            reason = childReason;
        }
        if (reason == null) {
            throw new RecordCoreException("mergeNoNextReason should not be called when all children have next", new Object[0]);
        }
        return reason;
    }

    @Nonnull
    protected static <T, S extends MergeCursorState<T>> RecordCursor.NoNextReason getWeakestNoNextReason(@Nonnull List<S> cursorStates) {
        RecordCursor.NoNextReason reason = null;
        for (MergeCursorState cursorState : cursorStates) {
            RecordCursorResult childResult = cursorState.getResult();
            if (childResult == null || childResult.hasNext()) continue;
            RecordCursor.NoNextReason childReason = childResult.getNoNextReason();
            if (childReason.isSourceExhausted()) {
                return childReason;
            }
            if (reason != null && (!reason.isOutOfBand() || childReason.isOutOfBand())) continue;
            reason = childReason;
        }
        if (reason == null) {
            throw new RecordCoreException("mergeNoNextReason should not be called when all children have next", new Object[0]);
        }
        return reason;
    }

    @Nonnull
    protected List<S> getCursorStates() {
        return this.cursorStates;
    }

    @Nonnull
    protected abstract CompletableFuture<List<S>> computeNextResultStates();

    @Nonnull
    protected abstract U getNextResult(@Nonnull List<S> var1);

    @Nonnull
    protected abstract RecordCursor.NoNextReason mergeNoNextReasons();

    @Nonnull
    protected abstract RecordCursorContinuation getContinuationObject();

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<U>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return this.computeNextResultStates().thenApply(resultStates -> {
            boolean hasNext;
            boolean bl = hasNext = !resultStates.isEmpty();
            if (!hasNext) {
                this.nextResult = RecordCursorResult.withoutNextValue(this.getContinuationObject(), this.mergeNoNextReasons());
            } else {
                U result = this.getNextResult((List<S>)resultStates);
                resultStates.forEach(MergeCursorState::consume);
                this.nextResult = RecordCursorResult.withNextValue(result, this.getContinuationObject());
            }
            return this.nextResult;
        });
    }

    @Nonnull
    protected List<RecordCursorContinuation> getChildContinuations() {
        return this.cursorStates.stream().map(MergeCursorState::getContinuation).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.cursorStates.forEach(MergeCursorState::close);
    }

    @Override
    public boolean isClosed() {
        return this.cursorStates.stream().allMatch(MergeCursorState::isClosed);
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Nullable
    public FDBStoreTimer getTimer() {
        return this.timer;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        block1: {
            MergeCursorState cursorState;
            if (!visitor.visitEnter(this)) break block1;
            Iterator<S> iterator = this.getCursorStates().iterator();
            while (iterator.hasNext() && (cursorState = (MergeCursorState)iterator.next()).getCursor().accept(visitor)) {
            }
        }
        return visitor.visitLeave(this);
    }
}

