/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class MergeCursorContinuation<B extends Message.Builder, C extends RecordCursorContinuation>
implements RecordCursorContinuation {
    @Nonnull
    private final List<C> continuations;
    @Nullable
    private Message cachedProto;
    @Nullable
    private byte[] cachedBytes;
    @Nullable
    private ByteString cachedByteString;

    protected MergeCursorContinuation(@Nonnull List<C> continuations, @Nullable Message originalProto) {
        this.continuations = continuations;
        this.cachedProto = originalProto;
    }

    protected abstract void setFirstChild(@Nonnull B var1, @Nonnull C var2);

    protected abstract void setSecondChild(@Nonnull B var1, @Nonnull C var2);

    protected abstract void addOtherChild(@Nonnull B var1, @Nonnull C var2);

    @Nonnull
    protected abstract B newProtoBuilder();

    @Nonnull
    protected Message toProto() {
        if (this.cachedProto == null) {
            B builder = this.newProtoBuilder();
            Iterator<C> continuationIterator = this.continuations.iterator();
            this.setFirstChild(builder, (RecordCursorContinuation)continuationIterator.next());
            this.setSecondChild(builder, (RecordCursorContinuation)continuationIterator.next());
            while (continuationIterator.hasNext()) {
                this.addOtherChild(builder, (RecordCursorContinuation)continuationIterator.next());
            }
            this.cachedProto = builder.build();
        }
        return this.cachedProto;
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"EI"})
    public byte[] toBytes() {
        if (this.isEnd()) {
            return null;
        }
        if (this.cachedBytes == null) {
            this.cachedBytes = this.toByteString().toByteArray();
        }
        return this.cachedBytes;
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI"})
    public ByteString toByteString() {
        if (this.isEnd()) {
            return ByteString.EMPTY;
        }
        if (this.cachedByteString == null) {
            this.cachedByteString = this.toProto().toByteString();
        }
        return this.cachedByteString;
    }

    @Nonnull
    protected List<C> getContinuations() {
        return this.continuations;
    }
}

