/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class MergeCursorState<T>
implements AutoCloseable {
    @Nonnull
    private final RecordCursor<T> cursor;
    @Nullable
    private CompletableFuture<RecordCursorResult<T>> onNextFuture;
    @Nonnull
    private RecordCursorContinuation continuation;
    @Nullable
    private RecordCursorResult<T> result;

    protected MergeCursorState(@Nonnull RecordCursor<T> cursor, @Nonnull RecordCursorContinuation continuation) {
        this.cursor = cursor;
        this.continuation = continuation;
    }

    protected void handleNextCursorResult(@Nonnull RecordCursorResult<T> cursorResult) {
        this.result = cursorResult;
        if (!this.result.hasNext()) {
            this.continuation = this.result.getContinuation();
        }
    }

    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> getOnNextFuture() {
        if (this.onNextFuture == null) {
            this.onNextFuture = this.cursor.onNext().thenApply(cursorResult -> {
                this.handleNextCursorResult((RecordCursorResult<T>)cursorResult);
                return cursorResult;
            });
        }
        return this.onNextFuture;
    }

    public void consume() {
        this.onNextFuture = null;
        this.continuation = this.result.getContinuation();
    }

    public boolean mightHaveNext() {
        return this.result == null || this.result.hasNext();
    }

    @Nullable
    public RecordCursorResult<T> getResult() {
        return this.result;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    public boolean isClosed() {
        return this.cursor.isClosed();
    }

    @Nonnull
    public Executor getExecutor() {
        return this.cursor.getExecutor();
    }

    @Nonnull
    public RecordCursor<T> getCursor() {
        return this.cursor;
    }

    @Nonnull
    public RecordCursorContinuation getContinuation() {
        return this.continuation;
    }

    @Nonnull
    public static <T> MergeCursorState<T> from(@Nonnull Function<byte[], RecordCursor<T>> cursorFunction, @Nonnull RecordCursorContinuation continuation) {
        if (continuation.isEnd()) {
            return new MergeCursorState(RecordCursor.empty(), RecordCursorEndContinuation.END);
        }
        return new MergeCursorState<T>(cursorFunction.apply(continuation.toBytes()), continuation);
    }
}

