/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.BloomFilterCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ProbableIntersectionCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ProbableIntersectionCursorState;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ProbableIntersectionCursor<T>
extends MergeCursor<T, T, ProbableIntersectionCursorState<T>> {
    public static final long DEFAULT_EXPECTED_RESULTS = 500L;
    public static final double DEFAULT_FALSE_POSITIVE_PERCENTAGE = 0.01;
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_INTERSECTION);
    @Nonnull
    private static final Set<StoreTimer.Count> matchesCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_INTERSECTION_PLAN_MATCHES);
    @Nonnull
    private static final Set<StoreTimer.Count> nonmatchesCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_INTERSECTION_PLAN_NONMATCHES, FDBStoreTimer.Counts.QUERY_DISCARDED);

    ProbableIntersectionCursor(@Nonnull List<ProbableIntersectionCursorState<T>> cursorStates, @Nullable FDBStoreTimer timer) {
        super(cursorStates, timer);
    }

    private boolean checkIfInRest(@Nonnull ProbableIntersectionCursorState<T> cursorState) {
        List cursorStates = this.getCursorStates();
        List<Object> key = cursorState.getComparisonKey();
        boolean allContain = true;
        for (ProbableIntersectionCursorState otherCursorState : cursorStates) {
            if (otherCursorState == cursorState || otherCursorState.mightContain(key)) continue;
            allContain = false;
            break;
        }
        return allContain;
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<ProbableIntersectionCursorState<T>>> computeNextResultStates() {
        long startComputingStateTime = System.currentTimeMillis();
        AtomicReference resultStateRef = new AtomicReference();
        return AsyncUtil.whileTrue(() -> ProbableIntersectionCursor.whenAny(this.getCursorStates()).thenApply(vignore -> {
            this.checkNextStateTimeout(startComputingStateTime);
            long startTime = System.nanoTime();
            List cursorStates = this.getCursorStates();
            boolean allDone = true;
            for (ProbableIntersectionCursorState cursorState : cursorStates) {
                CompletableFuture onNextFuture = cursorState.getOnNextFuture();
                if (!MoreAsyncUtil.isCompletedNormally(onNextFuture)) {
                    allDone = false;
                    continue;
                }
                RecordCursorResult resultState = onNextFuture.join();
                if (!resultState.hasNext()) continue;
                allDone = false;
                if (!cursorState.isDefiniteDuplicate() && this.checkIfInRest(cursorState)) {
                    resultStateRef.set(cursorState);
                    if (this.getTimer() != null) {
                        this.getTimer().increment(matchesCounts);
                        this.getTimer().record(duringEvents, System.nanoTime() - startTime);
                    }
                    return false;
                }
                cursorState.consume();
                if (this.getTimer() == null) continue;
                this.getTimer().increment(nonmatchesCounts);
            }
            if (this.getTimer() != null) {
                this.getTimer().record(duringEvents, System.nanoTime() - startTime);
            }
            return !allDone;
        }), this.getExecutor()).thenApply(vignore -> {
            if (resultStateRef.get() == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList((ProbableIntersectionCursorState)resultStateRef.get());
        });
    }

    @Override
    @Nonnull
    protected T getNextResult(@Nonnull List<ProbableIntersectionCursorState<T>> resultStates) {
        return resultStates.get(0).getResult().get();
    }

    @Override
    @Nonnull
    protected RecordCursor.NoNextReason mergeNoNextReasons() {
        return ProbableIntersectionCursor.getStrongestNoNextReason(this.getCursorStates());
    }

    @Override
    @Nonnull
    protected ProbableIntersectionCursorContinuation getContinuationObject() {
        return ProbableIntersectionCursorContinuation.from(this);
    }

    @Nonnull
    static <T> List<ProbableIntersectionCursorState<T>> createCursorStates(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, long expectedInsertions, double falsePositiveRate) {
        ArrayList<ProbableIntersectionCursorState<T>> cursorStates = new ArrayList<ProbableIntersectionCursorState<T>>(cursorFunctions.size());
        ProbableIntersectionCursorContinuation continuation = ProbableIntersectionCursorContinuation.from(byteContinuation, cursorFunctions.size());
        int i = 0;
        for (Function<byte[], RecordCursor<T>> cursorFunction : cursorFunctions) {
            cursorStates.add(ProbableIntersectionCursorState.from(cursorFunction, (BloomFilterCursorContinuation)continuation.getContinuations().get(i), comparisonKeyFunction, expectedInsertions, falsePositiveRate));
            ++i;
        }
        return cursorStates;
    }

    @Nonnull
    public static <T> ProbableIntersectionCursor<T> create(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, @Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] continuation, @Nullable FDBStoreTimer timer) {
        return ProbableIntersectionCursor.create(comparisonKeyFunction, cursorFunctions, 500L, 0.01, continuation, timer);
    }

    @Nonnull
    public static <T> ProbableIntersectionCursor<T> create(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, @Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, long expectedResults, double falsePositivePercentage, @Nullable byte[] continuation, @Nullable FDBStoreTimer timer) {
        return new ProbableIntersectionCursor<T>(ProbableIntersectionCursor.createCursorStates(cursorFunctions, continuation, comparisonKeyFunction, expectedResults, falsePositivePercentage), timer);
    }
}

