/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.cursors.BloomFilterCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ProbableIntersectionCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ProbableIntersectionCursorState;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ProbableIntersectionCursorContinuation
extends MergeCursorContinuation<RecordCursorProto.ProbableIntersectionContinuation.Builder, BloomFilterCursorContinuation> {
    protected ProbableIntersectionCursorContinuation(@Nonnull List<BloomFilterCursorContinuation> continuations, @Nullable Message originalProto) {
        super(continuations, originalProto);
    }

    protected ProbableIntersectionCursorContinuation(@Nonnull List<BloomFilterCursorContinuation> continuations) {
        this(continuations, (Message)null);
    }

    private void addChild(@Nonnull RecordCursorProto.ProbableIntersectionContinuation.Builder builder, @Nonnull BloomFilterCursorContinuation continuation) {
        builder.addChildState(continuation.toProto());
    }

    @Override
    protected void setFirstChild(@Nonnull RecordCursorProto.ProbableIntersectionContinuation.Builder builder, @Nonnull BloomFilterCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    @Override
    protected void setSecondChild(@Nonnull RecordCursorProto.ProbableIntersectionContinuation.Builder builder, @Nonnull BloomFilterCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    @Override
    protected void addOtherChild(@Nonnull RecordCursorProto.ProbableIntersectionContinuation.Builder builder, @Nonnull BloomFilterCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    @Override
    @Nonnull
    protected RecordCursorProto.ProbableIntersectionContinuation.Builder newProtoBuilder() {
        return RecordCursorProto.ProbableIntersectionContinuation.newBuilder();
    }

    @Override
    public boolean isEnd() {
        return this.getContinuations().stream().allMatch(BloomFilterCursorContinuation::isChildEnd);
    }

    @Nonnull
    static ProbableIntersectionCursorContinuation from(@Nonnull ProbableIntersectionCursor<?> cursor) {
        List<BloomFilterCursorContinuation> childContinuations = cursor.getCursorStates().stream().map(ProbableIntersectionCursorState::getContinuation).collect(Collectors.toList());
        return new ProbableIntersectionCursorContinuation(childContinuations);
    }

    @Nonnull
    static ProbableIntersectionCursorContinuation from(@Nullable byte[] bytes, int numberOfChildren) {
        if (bytes == null) {
            return new ProbableIntersectionCursorContinuation(Collections.nCopies(numberOfChildren, new BloomFilterCursorContinuation(RecordCursorStartContinuation.START, null)));
        }
        try {
            return ProbableIntersectionCursorContinuation.from(RecordCursorProto.ProbableIntersectionContinuation.parseFrom(bytes), numberOfChildren);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
    }

    @Nonnull
    static ProbableIntersectionCursorContinuation from(@Nonnull RecordCursorProto.ProbableIntersectionContinuation parsed, int numberOfChildren) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordCursorProto.ProbableIntersectionContinuation.CursorState state : parsed.getChildStateList()) {
            if (state.getExhausted()) {
                builder.add(new BloomFilterCursorContinuation(RecordCursorEndContinuation.END, state.getBloomFilter()));
                continue;
            }
            if (state.hasContinuation()) {
                builder.add(new BloomFilterCursorContinuation(ByteArrayContinuation.fromNullable(state.getContinuation().toByteArray()), state.getBloomFilter()));
                continue;
            }
            builder.add(new BloomFilterCursorContinuation(RecordCursorStartContinuation.START, state.getBloomFilter()));
        }
        ImmutableCollection children = builder.build();
        if (children.size() != numberOfChildren) {
            throw new RecordCoreArgumentException("invalid continuation (extraneous child state information present)", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED_CHILD_COUNT, numberOfChildren}).addLogInfo(new Object[]{LogMessageKeys.READ_CHILD_COUNT, parsed.getChildStateCount()});
        }
        return new ProbableIntersectionCursorContinuation((List<BloomFilterCursorContinuation>)((Object)children), (Message)parsed);
    }
}

