/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.BloomFilterCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyedMergeCursorState;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Verify;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

class ProbableIntersectionCursorState<T>
extends KeyedMergeCursorState<T> {
    @Nonnull
    private final BloomFilter<List<Object>> bloomFilter;
    @Nonnull
    private final Set<List<Object>> seenSet;
    private final boolean firstIteration;

    private ProbableIntersectionCursorState(@Nonnull RecordCursor<T> cursor, @Nonnull BloomFilterCursorContinuation continuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, @Nonnull BloomFilter<List<Object>> bloomFilter, @Nonnull Set<List<Object>> seenSet, boolean firstIteration) {
        super(cursor, continuation.getChild(), comparisonKeyFunction);
        this.bloomFilter = bloomFilter;
        this.seenSet = seenSet;
        this.firstIteration = firstIteration;
    }

    @Override
    public void consume() {
        this.bloomFilter.put(this.getComparisonKey());
        this.seenSet.add(this.getComparisonKey());
        super.consume();
    }

    @Override
    @Nonnull
    public BloomFilterCursorContinuation getContinuation() {
        BloomFilterCursorContinuation bloomFilterCursorContinuation;
        block8: {
            ByteString.Output bloomOutput = ByteString.newOutput();
            try {
                this.bloomFilter.writeTo(bloomOutput);
                bloomFilterCursorContinuation = new BloomFilterCursorContinuation(super.getContinuation(), bloomOutput.toByteString());
                if (bloomOutput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bloomOutput != null) {
                        try {
                            bloomOutput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RecordCoreException("unable to serialize bloom filter", e);
                }
            }
            bloomOutput.close();
        }
        return bloomFilterCursorContinuation;
    }

    @VisibleForTesting
    BloomFilter<List<Object>> getBloomFilter() {
        return this.bloomFilter;
    }

    boolean mightContain(@Nonnull List<Object> otherComparisonKey) {
        return this.seenSet.contains(otherComparisonKey) || !this.firstIteration && this.bloomFilter.mightContain(otherComparisonKey);
    }

    boolean isDefiniteDuplicate() {
        return this.seenSet.contains(this.getComparisonKey());
    }

    @Nonnull
    static <T> ProbableIntersectionCursorState<T> from(@Nonnull Function<byte[], RecordCursor<T>> cursorFunction, @Nonnull BloomFilterCursorContinuation continuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, long expectedInsertions, double falsePositiveRate) {
        BloomFilter<List<Object>> bloomFilter;
        if (continuation.getBloomBytes() == null) {
            bloomFilter = BloomFilter.create(KeyFunnel.VERSION_0, expectedInsertions, falsePositiveRate);
        } else {
            try {
                bloomFilter = BloomFilter.readFrom(continuation.getBloomBytes().newInput(), KeyFunnel.VERSION_0);
            }
            catch (IOException e) {
                throw new RecordCoreException("unable to deserialize bloom filter", e);
            }
        }
        if (continuation.isChildEnd()) {
            return new ProbableIntersectionCursorState<T>(RecordCursor.empty(), continuation, comparisonKeyFunction, bloomFilter, Collections.emptySet(), false);
        }
        return new ProbableIntersectionCursorState<T>(cursorFunction.apply(continuation.getChild().toBytes()), continuation, comparisonKeyFunction, bloomFilter, new HashSet<List<Object>>(), continuation.getBloomBytes() == null);
    }

    private static enum KeyFunnel implements Funnel<List<Object>>
    {
        VERSION_0;


        @Override
        public void funnel(List<Object> objects, PrimitiveSink primitiveSink) {
            for (Object o : Verify.verifyNotNull(objects)) {
                if (o == null) {
                    primitiveSink.putByte((byte)0);
                    continue;
                }
                if (o instanceof byte[]) {
                    primitiveSink.putBytes((byte[])o);
                    continue;
                }
                if (o instanceof ByteString) {
                    primitiveSink.putBytes(((ByteString)o).toByteArray());
                    continue;
                }
                if (o instanceof ByteBuffer) {
                    primitiveSink.putBytes((ByteBuffer)o);
                    continue;
                }
                if (o instanceof String) {
                    primitiveSink.putString((String)o, Charsets.UTF_8);
                    continue;
                }
                if (o instanceof Float) {
                    primitiveSink.putFloat(((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    primitiveSink.putDouble((Double)o);
                    continue;
                }
                if (o instanceof Integer) {
                    primitiveSink.putInt((Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    primitiveSink.putLong((Long)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    primitiveSink.putBoolean((Boolean)o);
                    continue;
                }
                if (o instanceof Enum) {
                    primitiveSink.putInt(((Enum)o).ordinal());
                    continue;
                }
                primitiveSink.putBytes(Tuple.from(o).pack());
            }
        }
    }
}

