/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProviderBySubspace;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.DEPRECATED)
public class SizeStatisticsCollectorCursor
implements RecordCursor<SizeStatisticsResults> {
    @Nonnull
    private final SubspaceProvider subspaceProvider;
    @Nonnull
    private final FDBRecordContext context;
    @Nonnull
    private final ScanProperties scanProperties;
    @Nullable
    private RecordCursorResult<SizeStatisticsResults> nextStatsResult;
    private boolean finalResultsEmitted;
    @Nullable
    private byte[] kvCursorContinuation;
    @Nonnull
    private SizeStatisticsResults sizeStatisticsResults;
    private boolean closed;

    private SizeStatisticsCollectorCursor(@Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        this.subspaceProvider = subspaceProvider;
        this.sizeStatisticsResults = new SizeStatisticsResults();
        this.context = context;
        this.scanProperties = scanProperties;
        this.finalResultsEmitted = false;
        this.kvCursorContinuation = null;
        this.nextStatsResult = null;
        this.closed = false;
        if (continuation != null) {
            try {
                RecordCursorProto.SizeStatisticsContinuation statsContinuation = RecordCursorProto.SizeStatisticsContinuation.parseFrom(continuation);
                if (statsContinuation.hasPartialResults()) {
                    this.sizeStatisticsResults.fromProto(statsContinuation.getPartialResults());
                    this.kvCursorContinuation = statsContinuation.getContinuation().toByteArray();
                } else {
                    this.finalResultsEmitted = true;
                }
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("Error parsing SizeStatisticsCollectorCursor continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<SizeStatisticsResults>> onNext() {
        if (this.finalResultsEmitted) {
            return CompletableFuture.completedFuture(RecordCursorResult.exhausted());
        }
        if (this.nextStatsResult != null && !this.nextStatsResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextStatsResult);
        }
        return this.subspaceProvider.getSubspaceAsync(this.context).thenCompose(subspace -> {
            KeyValueCursor kvCursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(subspace).setContext(this.context)).setContinuation(this.kvCursorContinuation)).setScanProperties(this.scanProperties)).build();
            return ((CompletableFuture)kvCursor.forEachResult(nextKv -> this.sizeStatisticsResults.updateStatistics((KeyValue)nextKv.get())).thenApply(resultKv -> {
                if (resultKv.getNoNextReason() == RecordCursor.NoNextReason.SOURCE_EXHAUSTED) {
                    this.finalResultsEmitted = true;
                    this.nextStatsResult = RecordCursorResult.withNextValue(this.sizeStatisticsResults, new SizeStatisticsCollectorCursorContinuation((RecordCursorResult<KeyValue>)resultKv, this.sizeStatisticsResults, this.finalResultsEmitted));
                } else {
                    this.nextStatsResult = RecordCursorResult.withoutNextValue(new SizeStatisticsCollectorCursorContinuation((RecordCursorResult<KeyValue>)resultKv, this.sizeStatisticsResults, this.finalResultsEmitted), resultKv.getNoNextReason());
                    this.kvCursorContinuation = resultKv.getContinuation().toBytes();
                }
                return this.nextStatsResult;
            })).whenComplete((ignore, err) -> kvCursor.close());
        });
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Nonnull
    public static SizeStatisticsCollectorCursor ofStore(@Nonnull FDBRecordStore store, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        return new SizeStatisticsCollectorCursor(store.getSubspaceProvider(), context, scanProperties, continuation);
    }

    @Nonnull
    public static SizeStatisticsCollectorCursor ofRecords(@Nonnull FDBRecordStore store, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        return new SizeStatisticsCollectorCursor(new SubspaceProviderBySubspace(store.recordsSubspace()), context, scanProperties, continuation);
    }

    @Nonnull
    public static SizeStatisticsCollectorCursor ofIndex(@Nonnull FDBRecordStore store, @Nonnull String indexName, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        RecordMetaData metaData = store.getRecordMetaData();
        return SizeStatisticsCollectorCursor.ofIndex(store, metaData.getIndex(indexName), context, scanProperties, continuation);
    }

    @Nonnull
    public static SizeStatisticsCollectorCursor ofIndex(@Nonnull FDBRecordStore store, @Nonnull Index index, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        return new SizeStatisticsCollectorCursor(new SubspaceProviderBySubspace(store.indexSubspace(index)), context, scanProperties, continuation);
    }

    @Nonnull
    public static SizeStatisticsCollectorCursor ofSubspace(@Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation) {
        return new SizeStatisticsCollectorCursor(new SubspaceProviderBySubspace(subspace), context, scanProperties, continuation);
    }

    @API(value=API.Status.DEPRECATED)
    public static class SizeStatisticsResults {
        private long keyCount = 0L;
        private long keySize = 0L;
        private long maxKeySize = 0L;
        private long valueSize = 0L;
        private long maxValueSize = 0L;
        private long[] sizeBuckets = new long[32];

        private SizeStatisticsResults() {
        }

        private void updateStatistics(@Nonnull KeyValue kv) {
            ++this.keyCount;
            this.keySize += (long)kv.getKey().length;
            this.maxKeySize = Math.max(this.maxKeySize, (long)kv.getKey().length);
            this.valueSize += (long)kv.getValue().length;
            this.maxValueSize = Math.max(this.maxValueSize, (long)kv.getValue().length);
            int totalSize = kv.getKey().length + kv.getValue().length;
            if (totalSize > 0) {
                int n = 32 - Integer.numberOfLeadingZeros(totalSize) - 1;
                this.sizeBuckets[n] = this.sizeBuckets[n] + 1L;
            }
        }

        private void fromProto(RecordCursorProto.SizeStatisticsPartialResults partialResults) {
            this.keyCount = partialResults.getKeyCount();
            this.keySize = partialResults.getKeySize();
            this.maxKeySize = partialResults.getMaxKeySize();
            this.valueSize = partialResults.getValueSize();
            this.maxValueSize = partialResults.getMaxValueSize();
            List<Long> bucketList = partialResults.getSizeBucketsList();
            Arrays.setAll(this.sizeBuckets, i -> (Long)bucketList.get(i));
        }

        private RecordCursorProto.SizeStatisticsPartialResults toProto() {
            RecordCursorProto.SizeStatisticsPartialResults.Builder pr = RecordCursorProto.SizeStatisticsPartialResults.newBuilder().setKeyCount(this.getKeyCount()).setKeySize(this.getKeySize()).setMaxKeySize(this.getMaxKeySize()).setValueSize(this.getValueSize()).setMaxValueSize(this.getMaxValueSize());
            List bucketList = Arrays.stream(this.getSizeBuckets()).boxed().collect(Collectors.toList());
            pr.addAllSizeBuckets(bucketList);
            return pr.build();
        }

        private SizeStatisticsResults copy() {
            SizeStatisticsResults target = new SizeStatisticsResults();
            target.setKeyCount(this.getKeyCount());
            target.setKeySize(this.getKeySize());
            target.setMaxKeySize(this.getMaxKeySize());
            target.setValueSize(this.getValueSize());
            target.setMaxValueSize(this.getMaxValueSize());
            target.setSizeBuckets(this.getSizeBuckets());
            return target;
        }

        private void setKeyCount(long keyCount) {
            this.keyCount = keyCount;
        }

        private void setKeySize(long keySize) {
            this.keySize = keySize;
        }

        private void setValueSize(long valueSize) {
            this.valueSize = valueSize;
        }

        private void setMaxKeySize(long maxKeySize) {
            this.maxKeySize = maxKeySize;
        }

        private void setMaxValueSize(long maxValueSize) {
            this.maxValueSize = maxValueSize;
        }

        private void setSizeBuckets(long[] sizeBuckets) {
            this.sizeBuckets = Arrays.copyOf(sizeBuckets, sizeBuckets.length);
        }

        public long getKeyCount() {
            return this.keyCount;
        }

        public long getKeySize() {
            return this.keySize;
        }

        public long getMaxKeySize() {
            return this.maxKeySize;
        }

        public long getValueSize() {
            return this.valueSize;
        }

        public long getMaxValueSize() {
            return this.maxValueSize;
        }

        public long getTotalSize() {
            return this.keySize + this.valueSize;
        }

        public double getAverageKeySize() {
            return (double)this.keySize * 1.0 / (double)this.keyCount;
        }

        public double getAverageValueSize() {
            return (double)this.valueSize * 1.0 / (double)this.keyCount;
        }

        public double getAverage() {
            return (double)this.getTotalSize() * 1.0 / (double)this.keyCount;
        }

        @Nonnull
        public long[] getSizeBuckets() {
            return Arrays.copyOf(this.sizeBuckets, this.sizeBuckets.length);
        }

        public double getProportion(double proportion) {
            if (proportion < 0.0 || proportion >= 1.0) {
                throw new RecordCoreArgumentException("proportion " + proportion + " outside legal range", new Object[0]);
            }
            long target = (long)((double)this.keyCount * proportion);
            long soFar = 0L;
            int i = 0;
            while (soFar < target) {
                soFar += this.sizeBuckets[i];
                ++i;
            }
            if (i == 0) {
                return 1.0;
            }
            long before = 1L << i - 1;
            long after = 1L << i;
            long inBucket = this.sizeBuckets[i - 1];
            return (double)before + (double)((target - soFar + inBucket) * (after - before)) * 1.0 / (double)inBucket;
        }

        public double getMedian() {
            return this.getProportion(0.5);
        }

        public double getP90() {
            return this.getProportion(0.9);
        }

        public double getP95() {
            return this.getProportion(0.95);
        }
    }

    private static class SizeStatisticsCollectorCursorContinuation
    implements RecordCursorContinuation {
        @Nonnull
        private final RecordCursorResult<KeyValue> currentKvResult;
        @Nonnull
        private final Function<ByteString, RecordCursorProto.SizeStatisticsContinuation> continuationFunction;
        @Nonnull
        private final SizeStatisticsResults sizeStatisticsResults;
        @Nullable
        private byte[] cachedBytes = null;
        @Nullable
        private ByteString cachedByteString;
        private boolean finalResultsEmitted;

        private SizeStatisticsCollectorCursorContinuation(RecordCursorResult<KeyValue> currentKvResult, SizeStatisticsResults sizeStatisticsResults, boolean finalResultsEmitted) {
            this.currentKvResult = currentKvResult;
            this.sizeStatisticsResults = sizeStatisticsResults.copy();
            this.finalResultsEmitted = finalResultsEmitted;
            this.continuationFunction = b -> {
                if (!this.finalResultsEmitted) {
                    return RecordCursorProto.SizeStatisticsContinuation.newBuilder().setPartialResults(this.sizeStatisticsResults.toProto()).setContinuation((ByteString)b).build();
                }
                return RecordCursorProto.SizeStatisticsContinuation.getDefaultInstance();
            };
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.cachedBytes == null) {
                this.cachedBytes = this.toByteString().toByteArray();
            }
            return this.cachedBytes;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.cachedByteString == null) {
                this.cachedByteString = this.continuationFunction.apply(this.currentKvResult.getContinuation().toByteString()).toByteString();
            }
            return this.cachedByteString;
        }

        @Override
        public boolean isEnd() {
            return false;
        }
    }
}

