/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.provider.foundationdb.cursors.SizeStatisticsResults;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SizeStatisticsGroupingContinuation
implements RecordCursorContinuation {
    public static final SizeStatisticsGroupingContinuation LAST_RESULT_CONTINUATION = new SizeStatisticsGroupingContinuation();
    private final boolean lastResultContinuation;
    @Nullable
    private RecordCursorContinuation innerContinuation;
    @Nullable
    private SizeStatisticsResults partialResults;
    private Tuple currentGroupingKey;
    @Nullable
    private byte[] cachedBytes;
    @Nullable
    private ByteString cachedByteString;

    private SizeStatisticsGroupingContinuation() {
        this.lastResultContinuation = true;
    }

    SizeStatisticsGroupingContinuation(@Nonnull RecordCursorResult<KeyValue> currentKvResult, @Nonnull SizeStatisticsResults partialResults, @Nonnull Tuple currentGroupingKey) {
        this.lastResultContinuation = false;
        this.innerContinuation = currentKvResult.getContinuation();
        this.partialResults = partialResults.copy();
        this.currentGroupingKey = currentGroupingKey;
    }

    public static boolean isLastResultContinuation(RecordCursorProto.SizeStatisticsGroupingContinuation statsContinuation) {
        return statsContinuation.getLastResultContinuation();
    }

    public boolean isLastResultContinuation() {
        return this.lastResultContinuation;
    }

    @Override
    @Nullable
    public byte[] toBytes() {
        if (this.cachedBytes == null) {
            this.cachedBytes = this.toByteString().toByteArray();
        }
        return this.cachedBytes;
    }

    @Override
    @Nonnull
    public ByteString toByteString() {
        if (this.cachedByteString == null) {
            RecordCursorProto.SizeStatisticsGroupingContinuation.Builder builder = RecordCursorProto.SizeStatisticsGroupingContinuation.newBuilder();
            builder.setLastResultContinuation(this.lastResultContinuation);
            if (this.innerContinuation != null) {
                builder.setUnderlyingContinuation(this.innerContinuation.toByteString());
            }
            if (this.partialResults != null) {
                builder.setPartialResults(this.partialResults.toProto());
            }
            if (this.currentGroupingKey != null) {
                builder.setCurrentGroupingKey(ByteString.copyFrom(this.currentGroupingKey.pack()));
            }
            this.cachedByteString = builder.build().toByteString();
        }
        return this.cachedByteString;
    }

    @Override
    public boolean isEnd() {
        return false;
    }
}

