/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.LazyCursor;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProviderBySubspace;
import com.apple.foundationdb.record.provider.foundationdb.cursors.SizeStatisticsGroupedResults;
import com.apple.foundationdb.record.provider.foundationdb.cursors.SizeStatisticsGroupingContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.SizeStatisticsResults;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class SizeStatisticsGroupingCursor
implements RecordCursor<SizeStatisticsGroupedResults> {
    @Nonnull
    private final SubspaceProvider subspaceProvider;
    @Nonnull
    private final FDBRecordContext context;
    @Nonnull
    private final ScanProperties scanProperties;
    private final int aggregationDepth;
    @Nullable
    private RecordCursor<KeyValue> innerCursor;
    private byte[] kvCursorContinuation;
    @Nullable
    private CompletableFuture<Subspace> subspaceFuture;
    private Tuple currentGroupingKey;
    private SizeStatisticsResults intermediateResults;
    @Nullable
    private RecordCursorResult<SizeStatisticsGroupedResults> nextStatsResult;
    private boolean closed;

    private SizeStatisticsGroupingCursor(@Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        this.subspaceProvider = subspaceProvider;
        this.context = context;
        this.scanProperties = scanProperties;
        this.aggregationDepth = aggregationDepth;
        this.closed = false;
        if (continuation == null) {
            this.intermediateResults = new SizeStatisticsResults();
            this.kvCursorContinuation = null;
        } else {
            try {
                RecordCursorProto.SizeStatisticsGroupingContinuation statsContinuation = RecordCursorProto.SizeStatisticsGroupingContinuation.parseFrom(continuation);
                if (SizeStatisticsGroupingContinuation.isLastResultContinuation(statsContinuation)) {
                    this.nextStatsResult = RecordCursorResult.exhausted();
                } else {
                    this.intermediateResults = SizeStatisticsResults.fromProto(Objects.requireNonNull(statsContinuation.getPartialResults()));
                    this.kvCursorContinuation = Objects.requireNonNull(statsContinuation.getUnderlyingContinuation()).toByteArray();
                    this.currentGroupingKey = Tuple.fromBytes(Objects.requireNonNull(statsContinuation.getCurrentGroupingKey()).toByteArray());
                }
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("Error parsing SizeStatisticsGroupingContinuation continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
            }
        }
    }

    @Nonnull
    public static SizeStatisticsGroupingCursor ofStore(@Nonnull FDBRecordStore store, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        return new SizeStatisticsGroupingCursor(store.getSubspaceProvider(), context, scanProperties, continuation, aggregationDepth);
    }

    @Nonnull
    public static SizeStatisticsGroupingCursor ofRecords(@Nonnull FDBRecordStore store, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        return new SizeStatisticsGroupingCursor(new SubspaceProviderBySubspace(store.recordsSubspace()), context, scanProperties, continuation, aggregationDepth);
    }

    @Nonnull
    public static SizeStatisticsGroupingCursor ofIndex(@Nonnull FDBRecordStore store, @Nonnull String indexName, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        RecordMetaData metaData = store.getRecordMetaData();
        return SizeStatisticsGroupingCursor.ofIndex(store, metaData.getIndex(indexName), context, scanProperties, continuation, aggregationDepth);
    }

    @Nonnull
    public static SizeStatisticsGroupingCursor ofIndex(@Nonnull FDBRecordStore store, @Nonnull Index index, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        return new SizeStatisticsGroupingCursor(new SubspaceProviderBySubspace(store.indexSubspace(index)), context, scanProperties, continuation, aggregationDepth);
    }

    @Nonnull
    public static SizeStatisticsGroupingCursor ofSubspace(@Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nullable byte[] continuation, int aggregationDepth) {
        return new SizeStatisticsGroupingCursor(new SubspaceProviderBySubspace(subspace), context, scanProperties, continuation, aggregationDepth);
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<SizeStatisticsGroupedResults>> onNext() {
        if (this.subspaceFuture == null) {
            this.subspaceFuture = this.subspaceProvider.getSubspaceAsync(this.context);
            this.innerCursor = new LazyCursor<KeyValue>((CompletableFuture<RecordCursor<KeyValue>>)this.subspaceFuture.thenApply(sub -> ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(sub).setContext(this.context)).setContinuation(this.kvCursorContinuation)).setScanProperties(this.scanProperties)).build()), this.getExecutor());
        }
        if (this.nextStatsResult != null) {
            if (!this.nextStatsResult.hasNext()) {
                return CompletableFuture.completedFuture(this.nextStatsResult);
            }
            if (((SizeStatisticsGroupingContinuation)this.nextStatsResult.getContinuation()).isLastResultContinuation()) {
                this.nextStatsResult = RecordCursorResult.exhausted();
                return CompletableFuture.completedFuture(this.nextStatsResult);
            }
        }
        return this.subspaceFuture.thenCompose(subspace -> AsyncUtil.whileTrue(() -> this.innerCursor.onNext().thenApply(nextKv -> this.handleOneItem((Subspace)subspace, (RecordCursorResult<KeyValue>)nextKv)), this.getExecutor()).thenApply(ignore -> this.nextStatsResult));
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }

    @Override
    public void close() {
        this.closed = true;
        this.innerCursor.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Nonnull
    private Boolean handleOneItem(Subspace subspace, RecordCursorResult<KeyValue> nextKv) {
        if (nextKv.hasNext()) {
            KeyValue keyValue = Objects.requireNonNull(nextKv.get());
            Tuple nextGroupingKey = this.groupingKeyFrom(subspace, keyValue.getKey());
            if (this.currentGroupingKey == null || !this.groupBreak(this.currentGroupingKey, nextGroupingKey)) {
                this.intermediateResults.updateStatistics(keyValue);
                this.currentGroupingKey = nextGroupingKey;
                return true;
            }
            SizeStatisticsGroupedResults currentResult = new SizeStatisticsGroupedResults(this.currentGroupingKey, this.intermediateResults);
            this.intermediateResults = new SizeStatisticsResults();
            this.intermediateResults.updateStatistics(keyValue);
            this.currentGroupingKey = nextGroupingKey;
            this.nextStatsResult = RecordCursorResult.withNextValue(currentResult, new SizeStatisticsGroupingContinuation(nextKv, this.intermediateResults, this.currentGroupingKey));
            return false;
        }
        this.nextStatsResult = nextKv.getNoNextReason() == RecordCursor.NoNextReason.SOURCE_EXHAUSTED ? RecordCursorResult.withNextValue(new SizeStatisticsGroupedResults(this.currentGroupingKey, this.intermediateResults), SizeStatisticsGroupingContinuation.LAST_RESULT_CONTINUATION) : RecordCursorResult.withoutNextValue(new SizeStatisticsGroupingContinuation(nextKv, this.intermediateResults, this.currentGroupingKey), nextKv.getNoNextReason());
        return false;
    }

    private Tuple groupingKeyFrom(Subspace subspace, byte[] key) {
        if (this.aggregationDepth == 0) {
            return TupleHelpers.EMPTY;
        }
        Tuple unpacked = subspace.unpack(key);
        int actualDepth = Math.min(this.aggregationDepth, unpacked.size());
        return TupleHelpers.subTuple(unpacked, 0, actualDepth);
    }

    private boolean groupBreak(Tuple currentGroupingKey, Tuple nextGroupingKey) {
        return !Objects.equals(currentGroupingKey, nextGroupingKey);
    }
}

