/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursorProto;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class SizeStatisticsResults {
    private long keyCount = 0L;
    private long keySize = 0L;
    private long maxKeySize = 0L;
    private long valueSize = 0L;
    private long maxValueSize = 0L;
    private long[] sizeBuckets = new long[32];

    SizeStatisticsResults() {
    }

    public void updateStatistics(@Nonnull KeyValue kv) {
        ++this.keyCount;
        this.keySize += (long)kv.getKey().length;
        this.maxKeySize = Math.max(this.maxKeySize, (long)kv.getKey().length);
        this.valueSize += (long)kv.getValue().length;
        this.maxValueSize = Math.max(this.maxValueSize, (long)kv.getValue().length);
        int totalSize = kv.getKey().length + kv.getValue().length;
        if (totalSize > 0) {
            int n = 32 - Integer.numberOfLeadingZeros(totalSize) - 1;
            this.sizeBuckets[n] = this.sizeBuckets[n] + 1L;
        }
    }

    public static SizeStatisticsResults fromProto(RecordCursorProto.SizeStatisticsPartialResults partialResults) {
        SizeStatisticsResults result = new SizeStatisticsResults();
        result.keyCount = partialResults.getKeyCount();
        result.keySize = partialResults.getKeySize();
        result.maxKeySize = partialResults.getMaxKeySize();
        result.valueSize = partialResults.getValueSize();
        result.maxValueSize = partialResults.getMaxValueSize();
        List<Long> bucketList = partialResults.getSizeBucketsList();
        Arrays.setAll(result.sizeBuckets, i -> (Long)bucketList.get(i));
        return result;
    }

    public RecordCursorProto.SizeStatisticsPartialResults toProto() {
        RecordCursorProto.SizeStatisticsPartialResults.Builder pr = RecordCursorProto.SizeStatisticsPartialResults.newBuilder().setKeyCount(this.getKeyCount()).setKeySize(this.getKeySize()).setMaxKeySize(this.getMaxKeySize()).setValueSize(this.getValueSize()).setMaxValueSize(this.getMaxValueSize());
        List bucketList = Arrays.stream(this.getSizeBuckets()).boxed().collect(Collectors.toList());
        pr.addAllSizeBuckets(bucketList);
        return pr.build();
    }

    public SizeStatisticsResults copy() {
        SizeStatisticsResults target = new SizeStatisticsResults();
        target.setKeyCount(this.getKeyCount());
        target.setKeySize(this.getKeySize());
        target.setMaxKeySize(this.getMaxKeySize());
        target.setValueSize(this.getValueSize());
        target.setMaxValueSize(this.getMaxValueSize());
        target.setSizeBuckets(this.getSizeBuckets());
        return target;
    }

    private void setKeyCount(long keyCount) {
        this.keyCount = keyCount;
    }

    private void setKeySize(long keySize) {
        this.keySize = keySize;
    }

    private void setValueSize(long valueSize) {
        this.valueSize = valueSize;
    }

    private void setMaxKeySize(long maxKeySize) {
        this.maxKeySize = maxKeySize;
    }

    private void setMaxValueSize(long maxValueSize) {
        this.maxValueSize = maxValueSize;
    }

    private void setSizeBuckets(long[] sizeBuckets) {
        this.sizeBuckets = Arrays.copyOf(sizeBuckets, sizeBuckets.length);
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public long getMaxKeySize() {
        return this.maxKeySize;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public long getMaxValueSize() {
        return this.maxValueSize;
    }

    public long getTotalSize() {
        return this.keySize + this.valueSize;
    }

    public double getAverageKeySize() {
        return (double)this.keySize * 1.0 / (double)this.keyCount;
    }

    public double getAverageValueSize() {
        return (double)this.valueSize * 1.0 / (double)this.keyCount;
    }

    public double getAverage() {
        return (double)this.getTotalSize() * 1.0 / (double)this.keyCount;
    }

    @Nonnull
    public long[] getSizeBuckets() {
        return Arrays.copyOf(this.sizeBuckets, this.sizeBuckets.length);
    }

    public double getProportion(double proportion) {
        if (proportion < 0.0 || proportion >= 1.0) {
            throw new RecordCoreArgumentException("proportion " + proportion + " outside legal range", new Object[0]);
        }
        long target = (long)((double)this.keyCount * proportion);
        long soFar = 0L;
        int i = 0;
        while (soFar < target) {
            soFar += this.sizeBuckets[i];
            ++i;
        }
        if (i == 0) {
            return 1.0;
        }
        long before = 1L << i - 1;
        long after = 1L << i;
        long inBucket = this.sizeBuckets[i - 1];
        return (double)before + (double)((target - soFar + inBucket) * (after - before)) * 1.0 / (double)inBucket;
    }

    public double getMedian() {
        return this.getProportion(0.5);
    }

    public double getP90() {
        return this.getProportion(0.9);
    }

    public double getP95() {
        return this.getProportion(0.95);
    }
}

