/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyComparisons;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyedMergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorBase;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorContinuation;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class UnionCursor<T>
extends UnionCursorBase<T, KeyedMergeCursorState<T>> {
    private final boolean reverse;

    private UnionCursor(boolean reverse, @Nonnull List<KeyedMergeCursorState<T>> cursorStates, @Nullable FDBStoreTimer timer) {
        super(cursorStates, timer);
        this.reverse = reverse;
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<KeyedMergeCursorState<T>>> computeNextResultStates() {
        List cursorStates = this.getCursorStates();
        return UnionCursor.whenAll(cursorStates).thenApply(vignore -> {
            boolean anyHasNext = false;
            for (KeyedMergeCursorState cursorState : cursorStates) {
                if (cursorState.getResult().hasNext()) {
                    anyHasNext = true;
                    continue;
                }
                if (!cursorState.getResult().getNoNextReason().isLimitReached()) continue;
                return Collections.emptyList();
            }
            if (anyHasNext) {
                long startTime = System.nanoTime();
                ArrayList<KeyedMergeCursorState<T>> chosenStates = new ArrayList<KeyedMergeCursorState<T>>(cursorStates.size());
                ArrayList<KeyedMergeCursorState<T>> otherStates = new ArrayList<KeyedMergeCursorState<T>>(cursorStates.size());
                this.chooseStates(cursorStates, chosenStates, otherStates);
                this.logDuplicates(chosenStates, startTime);
                return chosenStates;
            }
            return Collections.emptyList();
        });
    }

    private void chooseStates(@Nonnull List<KeyedMergeCursorState<T>> allStates, @Nonnull List<KeyedMergeCursorState<T>> chosenStates, @Nonnull List<KeyedMergeCursorState<T>> otherStates) {
        List<Object> nextKey = null;
        for (KeyedMergeCursorState<T> cursorState : allStates) {
            RecordCursorResult result = cursorState.getResult();
            if (result.hasNext()) {
                List<Object> resultKey = cursorState.getComparisonKey();
                int compare = nextKey == null ? -1 : KeyComparisons.KEY_COMPARATOR.compare(resultKey, nextKey) * (this.reverse ? -1 : 1);
                if (compare < 0) {
                    otherStates.addAll(chosenStates);
                    chosenStates.clear();
                    nextKey = resultKey;
                }
                if (compare <= 0) {
                    chosenStates.add(cursorState);
                    continue;
                }
                otherStates.add(cursorState);
                continue;
            }
            otherStates.add(cursorState);
        }
    }

    private void logDuplicates(@Nonnull List<?> chosenStates, long startTime) {
        if (chosenStates.isEmpty()) {
            throw new RecordCoreException("union with additional items had no next states", new Object[0]);
        }
        if (this.getTimer() != null) {
            if (chosenStates.size() == 1) {
                this.getTimer().increment(uniqueCounts);
            } else {
                this.getTimer().increment(duplicateCounts, chosenStates.size() - 1);
            }
            this.getTimer().record(duringEvents, System.nanoTime() - startTime);
        }
    }

    @Nonnull
    protected static <T> List<KeyedMergeCursorState<T>> createCursorStates(@Nonnull Function<byte[], RecordCursor<T>> left, @Nonnull Function<byte[], RecordCursor<T>> right, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        UnionCursorContinuation continuation = UnionCursorContinuation.from(byteContinuation, 2);
        return ImmutableList.of(KeyedMergeCursorState.from(left, (RecordCursorContinuation)continuation.getContinuations().get(0), comparisonKeyFunction), KeyedMergeCursorState.from(right, (RecordCursorContinuation)continuation.getContinuations().get(1), comparisonKeyFunction));
    }

    @Nonnull
    protected static <T> List<KeyedMergeCursorState<T>> createCursorStates(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation, @Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction) {
        ArrayList<KeyedMergeCursorState<T>> cursorStates = new ArrayList<KeyedMergeCursorState<T>>(cursorFunctions.size());
        UnionCursorContinuation continuation = UnionCursorContinuation.from(byteContinuation, cursorFunctions.size());
        int i = 0;
        for (Function<byte[], RecordCursor<T>> cursorFunction : cursorFunctions) {
            cursorStates.add(KeyedMergeCursorState.from(cursorFunction, (RecordCursorContinuation)continuation.getContinuations().get(i), comparisonKeyFunction));
            ++i;
        }
        return cursorStates;
    }

    @Nonnull
    public static <M extends Message, S extends FDBRecord<M>> UnionCursor<S> create(@Nonnull FDBRecordStoreBase<M> store, @Nonnull KeyExpression comparisonKey, boolean reverse, @Nonnull Function<byte[], RecordCursor<S>> left, @Nonnull Function<byte[], RecordCursor<S>> right, @Nullable byte[] continuation) {
        return UnionCursor.create((? super T record) -> comparisonKey.evaluateSingleton(record).toTupleAppropriateList(), reverse, left, right, continuation, store.getTimer());
    }

    @Nonnull
    public static <T> UnionCursor<T> create(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, boolean reverse, @Nonnull Function<byte[], RecordCursor<T>> left, @Nonnull Function<byte[], RecordCursor<T>> right, @Nullable byte[] byteContinuation, @Nullable FDBStoreTimer timer) {
        List<KeyedMergeCursorState<T>> cursorStates = UnionCursor.createCursorStates(left, right, byteContinuation, comparisonKeyFunction);
        return new UnionCursor<T>(reverse, cursorStates, timer);
    }

    @Nonnull
    public static <M extends Message, S extends FDBRecord<M>> UnionCursor<S> create(@Nonnull FDBRecordStoreBase<M> store, @Nonnull KeyExpression comparisonKey, boolean reverse, @Nonnull List<Function<byte[], RecordCursor<S>>> cursorFunctions, @Nullable byte[] continuation) {
        return UnionCursor.create((? super T record) -> comparisonKey.evaluateSingleton(record).toTupleAppropriateList(), reverse, cursorFunctions, continuation, store.getTimer());
    }

    @Nonnull
    public static <T> UnionCursor<T> create(@Nonnull Function<? super T, ? extends List<Object>> comparisonKeyFunction, boolean reverse, @Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation, @Nullable FDBStoreTimer timer) {
        if (cursorFunctions.size() < 2) {
            throw new RecordCoreArgumentException("not enough child cursors provided to UnionCursor", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CHILD_COUNT, cursorFunctions.size()});
        }
        List<KeyedMergeCursorState<T>> cursorStates = UnionCursor.createCursorStates(cursorFunctions, byteContinuation, comparisonKeyFunction);
        return new UnionCursor<T>(reverse, cursorStates, timer);
    }
}

