/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorContinuation;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class UnionCursorBase<T, S extends MergeCursorState<T>>
extends MergeCursor<T, T, S> {
    @Nonnull
    static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_UNION);
    @Nonnull
    static final Set<StoreTimer.Count> uniqueCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_UNION_PLAN_UNIQUES);
    @Nonnull
    static final Set<StoreTimer.Count> duplicateCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_UNION_PLAN_DUPLICATES, FDBStoreTimer.Counts.QUERY_DISCARDED);

    UnionCursorBase(@Nonnull List<S> cursorStates, @Nullable FDBStoreTimer timer) {
        super(cursorStates, timer);
    }

    @Override
    @Nonnull
    protected UnionCursorContinuation getContinuationObject() {
        return UnionCursorContinuation.from(this);
    }

    @Override
    @Nonnull
    protected T getNextResult(@Nonnull List<S> chosenStates) {
        return ((MergeCursorState)chosenStates.get(0)).getResult().get();
    }

    @Override
    @Nonnull
    protected RecordCursor.NoNextReason mergeNoNextReasons() {
        return UnionCursorBase.getStrongestNoNextReason(this.getCursorStates());
    }
}

