/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorContinuation;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorBase;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class UnionCursorContinuation
extends MergeCursorContinuation<RecordCursorProto.UnionContinuation.Builder, RecordCursorContinuation> {
    @Nonnull
    private static final RecordCursorProto.UnionContinuation.CursorState EXHAUSTED_PROTO = RecordCursorProto.UnionContinuation.CursorState.newBuilder().setExhausted(true).build();
    @Nonnull
    private static final RecordCursorProto.UnionContinuation.CursorState START_PROTO = RecordCursorProto.UnionContinuation.CursorState.newBuilder().setExhausted(false).build();

    protected UnionCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations, @Nullable RecordCursorProto.UnionContinuation originalProto) {
        super(continuations, originalProto);
    }

    protected UnionCursorContinuation(@Nonnull List<RecordCursorContinuation> continuations) {
        this(continuations, null);
    }

    @Override
    protected void setFirstChild(@Nonnull RecordCursorProto.UnionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        if (continuation.isEnd()) {
            builder.setFirstExhausted(true);
        } else {
            ByteString asBytes = continuation.toByteString();
            if (!asBytes.isEmpty()) {
                builder.setFirstContinuation(asBytes);
            }
        }
    }

    @Override
    protected void setSecondChild(@Nonnull RecordCursorProto.UnionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        if (continuation.isEnd()) {
            builder.setSecondExhausted(true);
        } else {
            ByteString asBytes = continuation.toByteString();
            if (!asBytes.isEmpty()) {
                builder.setSecondContinuation(asBytes);
            }
        }
    }

    @Override
    protected void addOtherChild(@Nonnull RecordCursorProto.UnionContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes;
        RecordCursorProto.UnionContinuation.CursorState cursorState = continuation.isEnd() ? EXHAUSTED_PROTO : ((asBytes = continuation.toByteString()).isEmpty() ? START_PROTO : RecordCursorProto.UnionContinuation.CursorState.newBuilder().setContinuation(asBytes).build());
        builder.addOtherChildState(cursorState);
    }

    @Override
    @Nonnull
    protected RecordCursorProto.UnionContinuation.Builder newProtoBuilder() {
        return RecordCursorProto.UnionContinuation.newBuilder();
    }

    @Override
    public boolean isEnd() {
        return this.getContinuations().stream().allMatch(RecordCursorContinuation::isEnd);
    }

    @Nonnull
    static UnionCursorContinuation from(@Nonnull UnionCursorBase<?, ?> cursor) {
        return new UnionCursorContinuation(cursor.getChildContinuations());
    }

    @Nonnull
    static UnionCursorContinuation from(@Nullable byte[] bytes, int numberOfChildren) {
        if (bytes == null) {
            return new UnionCursorContinuation(Collections.nCopies(numberOfChildren, RecordCursorStartContinuation.START));
        }
        try {
            return UnionCursorContinuation.from(RecordCursorProto.UnionContinuation.parseFrom(bytes), numberOfChildren);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
        catch (RecordCoreArgumentException ex) {
            throw ex.addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
    }

    @Nonnull
    static UnionCursorContinuation from(@Nonnull RecordCursorProto.UnionContinuation parsed, int numberOfChildren) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (parsed.hasFirstContinuation()) {
            builder.add(ByteArrayContinuation.fromNullable(parsed.getFirstContinuation().toByteArray()));
        } else if (parsed.getFirstExhausted()) {
            builder.add(RecordCursorEndContinuation.END);
        } else {
            builder.add(RecordCursorStartContinuation.START);
        }
        if (parsed.hasSecondContinuation()) {
            builder.add(ByteArrayContinuation.fromNullable(parsed.getSecondContinuation().toByteArray()));
        } else if (parsed.getSecondExhausted()) {
            builder.add(RecordCursorEndContinuation.END);
        } else {
            builder.add(RecordCursorStartContinuation.START);
        }
        for (RecordCursorProto.UnionContinuation.CursorState state : parsed.getOtherChildStateList()) {
            if (state.hasContinuation()) {
                builder.add(ByteArrayContinuation.fromNullable(state.getContinuation().toByteArray()));
                continue;
            }
            if (state.getExhausted()) {
                builder.add(RecordCursorEndContinuation.END);
                continue;
            }
            builder.add(RecordCursorStartContinuation.START);
        }
        ImmutableCollection children = builder.build();
        if (children.size() != numberOfChildren) {
            throw new RecordCoreArgumentException("invalid continuation (expected continuation count does not match read)", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED_CHILD_COUNT, numberOfChildren}).addLogInfo(new Object[]{LogMessageKeys.READ_CHILD_COUNT, children.size()});
        }
        return new UnionCursorContinuation((List<RecordCursorContinuation>)((Object)children), parsed);
    }
}

