/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.cursors;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.KeyedMergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorState;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorBase;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursorContinuation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class UnorderedUnionCursor<T>
extends UnionCursorBase<T, MergeCursorState<T>> {
    protected UnorderedUnionCursor(@Nonnull List<MergeCursorState<T>> cursorStates, @Nullable FDBStoreTimer timer) {
        super(cursorStates, timer);
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<MergeCursorState<T>>> computeNextResultStates() {
        long startComputingStateTime = System.currentTimeMillis();
        List cursorStates = this.getCursorStates();
        AtomicReference nextStateRef = new AtomicReference();
        return AsyncUtil.whileTrue(() -> UnorderedUnionCursor.whenAny(cursorStates).thenApply(vignore -> {
            this.checkNextStateTimeout(startComputingStateTime);
            MergeCursorState nextState = null;
            boolean allDone = true;
            for (MergeCursorState cursorState : cursorStates) {
                if (!MoreAsyncUtil.isCompletedNormally(cursorState.getOnNextFuture())) {
                    allDone = false;
                    continue;
                }
                RecordCursorResult result = cursorState.getResult();
                if (!result.hasNext()) continue;
                allDone = false;
                nextState = cursorState;
                break;
            }
            if (nextState != null) {
                nextStateRef.set(nextState);
            }
            return nextState == null && !allDone;
        }), this.getExecutor()).thenApply(vignore -> {
            if (nextStateRef.get() == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList((MergeCursorState)nextStateRef.get());
        });
    }

    @Nonnull
    static <T> List<MergeCursorState<T>> createCursorStates(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] byteContinuation) {
        ArrayList<MergeCursorState<T>> cursorStates = new ArrayList<MergeCursorState<T>>(cursorFunctions.size());
        UnionCursorContinuation continuation = UnionCursorContinuation.from(byteContinuation, cursorFunctions.size());
        int i = 0;
        for (Function<byte[], RecordCursor<T>> cursorFunction : cursorFunctions) {
            cursorStates.add(KeyedMergeCursorState.from(cursorFunction, (RecordCursorContinuation)continuation.getContinuations().get(i)));
            ++i;
        }
        return cursorStates;
    }

    @Nonnull
    public static <T> UnorderedUnionCursor<T> create(@Nonnull List<Function<byte[], RecordCursor<T>>> cursorFunctions, @Nullable byte[] continuation, @Nullable FDBStoreTimer timer) {
        return new UnorderedUnionCursor<T>(UnorderedUnionCursor.createCursorStates(cursorFunctions, continuation), timer);
    }
}

