/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.tuple.Tuple;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface AtomicMutation {
    @Nonnull
    public MutationType getMutationType();

    @Nullable
    public byte[] getMutationParam(IndexEntry var1, boolean var2);

    @Nonnull
    public BiFunction<Tuple, Tuple, Tuple> getAggregator();

    @Nullable
    public Tuple getIdentity();

    public boolean hasValues();

    public boolean hasSingleValue();

    public boolean hasLongValue();

    public boolean allowsNegative();

    public boolean isIdempotent();

    @Nullable
    public byte[] getCompareAndClearParam();

    @API(value=API.Status.UNSTABLE)
    public static enum Standard implements AtomicMutation
    {
        COUNT(MutationType.ADD),
        COUNT_UPDATES(MutationType.ADD),
        COUNT_NOT_NULL(MutationType.ADD),
        SUM_LONG(MutationType.ADD),
        MAX_EVER_TUPLE(MutationType.BYTE_MAX),
        MIN_EVER_TUPLE(MutationType.BYTE_MIN),
        MAX_EVER_LONG(MutationType.MAX),
        MIN_EVER_LONG(MutationType.MIN),
        MAX_EVER_VERSION(MutationType.SET_VERSIONSTAMPED_VALUE),
        COUNT_CLEAR_WHEN_ZERO(MutationType.ADD),
        COUNT_NOT_NULL_CLEAR_WHEN_ZERO(MutationType.ADD),
        SUM_LONG_CLEAR_WHEN_ZERO(MutationType.ADD);

        @Nonnull
        private final MutationType mutationType;

        private Standard(MutationType mutationType) {
            this.mutationType = mutationType;
        }

        @Override
        @Nonnull
        public MutationType getMutationType() {
            return this.mutationType;
        }

        @Override
        @Nullable
        public byte[] getMutationParam(IndexEntry entry, boolean remove) {
            if (entry.getValue().size() != 0) {
                throw new RecordCoreException("Explicit value in atomic index mutation not supported", new Object[0]).addLogInfo("value_size", (Object)entry.getValue().size());
            }
            switch (this) {
                case COUNT_NOT_NULL: 
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: {
                    if (entry.keyContainsNonUniqueNull()) {
                        return null;
                    }
                    return this.getMutationParamForCount(remove);
                }
                case COUNT: 
                case COUNT_CLEAR_WHEN_ZERO: {
                    return this.getMutationParamForCount(remove);
                }
                case COUNT_UPDATES: {
                    if (remove) {
                        return null;
                    }
                    return FDBRecordStore.LITTLE_ENDIAN_INT64_ONE;
                }
                case SUM_LONG: 
                case SUM_LONG_CLEAR_WHEN_ZERO: {
                    Number numVal = (Number)entry.getKey().get(0);
                    if (numVal == null) {
                        return null;
                    }
                    long lval = numVal.longValue();
                    return Standard.encodeUnsignedLong(remove ? -lval : lval);
                }
                case MAX_EVER_LONG: 
                case MIN_EVER_LONG: {
                    if (remove) {
                        return null;
                    }
                    Number numVal = (Number)entry.getKey().get(0);
                    if (numVal == null) {
                        return null;
                    }
                    long lval = numVal.longValue();
                    return Standard.encodeUnsignedLong(lval);
                }
                case MAX_EVER_VERSION: {
                    if (remove) {
                        return null;
                    }
                    if (entry.getKey().hasIncompleteVersionstamp()) {
                        return entry.getKey().packWithVersionstamp();
                    }
                    return entry.getKey().pack();
                }
            }
            return entry.getKey().pack();
        }

        @Nonnull
        private byte[] getMutationParamForCount(boolean remove) {
            if (remove) {
                return FDBRecordStore.LITTLE_ENDIAN_INT64_MINUS_ONE;
            }
            return FDBRecordStore.LITTLE_ENDIAN_INT64_ONE;
        }

        @Nonnull
        public static byte[] encodeUnsignedLong(long value) {
            return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
        }

        public static long decodeUnsignedLong(byte[] bytes) {
            return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
        }

        @Nonnull
        public static byte[] encodeSignedLong(long value) {
            return Standard.encodeUnsignedLong(value - Long.MIN_VALUE);
        }

        public static long decodeSignedLong(byte[] bytes) {
            return Standard.decodeUnsignedLong(bytes) + Long.MIN_VALUE;
        }

        @Override
        @Nonnull
        public BiFunction<Tuple, Tuple, Tuple> getAggregator() {
            switch (this) {
                case COUNT_NOT_NULL: 
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case COUNT: 
                case COUNT_CLEAR_WHEN_ZERO: 
                case COUNT_UPDATES: 
                case SUM_LONG: 
                case SUM_LONG_CLEAR_WHEN_ZERO: {
                    return (total, tuple) -> Tuple.from(total.getLong(0) + tuple.getLong(0));
                }
                case MIN_EVER_LONG: 
                case MIN_EVER_TUPLE: {
                    return (min2, tuple) -> min2 == null || min2.compareTo((Tuple)tuple) > 0 ? tuple : min2;
                }
                case MAX_EVER_LONG: 
                case MAX_EVER_VERSION: 
                case MAX_EVER_TUPLE: {
                    return (max, tuple) -> max == null || max.compareTo((Tuple)tuple) < 0 ? tuple : max;
                }
            }
            return (accum, tuple) -> {
                if (accum != null) {
                    throw new RecordCoreException("No aggregation, can only have one value", new Object[0]);
                }
                return tuple;
            };
        }

        @Override
        @Nullable
        public Tuple getIdentity() {
            switch (this) {
                case COUNT_NOT_NULL: 
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case COUNT: 
                case COUNT_CLEAR_WHEN_ZERO: 
                case COUNT_UPDATES: 
                case SUM_LONG: 
                case SUM_LONG_CLEAR_WHEN_ZERO: {
                    return Tuple.from(0L);
                }
            }
            return null;
        }

        @Override
        public boolean isIdempotent() {
            switch (this) {
                case COUNT_NOT_NULL: 
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case COUNT: 
                case COUNT_CLEAR_WHEN_ZERO: 
                case COUNT_UPDATES: 
                case SUM_LONG: 
                case SUM_LONG_CLEAR_WHEN_ZERO: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasValues() {
            switch (this) {
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case COUNT: 
                case COUNT_CLEAR_WHEN_ZERO: 
                case COUNT_UPDATES: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasSingleValue() {
            switch (this) {
                case COUNT_NOT_NULL: 
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case MAX_EVER_VERSION: 
                case MIN_EVER_TUPLE: 
                case MAX_EVER_TUPLE: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasLongValue() {
            switch (this) {
                case SUM_LONG: 
                case SUM_LONG_CLEAR_WHEN_ZERO: 
                case MAX_EVER_LONG: 
                case MIN_EVER_LONG: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean allowsNegative() {
            switch (this) {
                case MAX_EVER_LONG: 
                case MIN_EVER_LONG: {
                    return false;
                }
            }
            return true;
        }

        @Override
        @Nullable
        public byte[] getCompareAndClearParam() {
            switch (this) {
                case COUNT_NOT_NULL_CLEAR_WHEN_ZERO: 
                case COUNT_CLEAR_WHEN_ZERO: 
                case SUM_LONG_CLEAR_WHEN_ZERO: {
                    return FDBRecordStore.INT64_ZERO;
                }
            }
            return null;
        }
    }
}

