/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.AtomicMutation;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class AtomicMutationIndexMaintainer
extends StandardIndexMaintainer {
    protected final AtomicMutation mutation;

    public AtomicMutationIndexMaintainer(IndexMaintainerState state) {
        super(state);
        this.mutation = AtomicMutationIndexMaintainer.getAtomicMutation(state.index);
    }

    protected AtomicMutationIndexMaintainer(IndexMaintainerState state, AtomicMutation mutation) {
        super(state);
        this.mutation = mutation;
    }

    protected static boolean getClearWhenZero(@Nonnull Index index) {
        return index.getBooleanOption("clearWhenZero", false);
    }

    protected static AtomicMutation getAtomicMutation(@Nonnull Index index) {
        if ("count".equals(index.getType())) {
            return AtomicMutationIndexMaintainer.getClearWhenZero(index) ? AtomicMutation.Standard.COUNT_CLEAR_WHEN_ZERO : AtomicMutation.Standard.COUNT;
        }
        if ("count_updates".equals(index.getType())) {
            return AtomicMutation.Standard.COUNT_UPDATES;
        }
        if ("count_not_null".equals(index.getType())) {
            return AtomicMutationIndexMaintainer.getClearWhenZero(index) ? AtomicMutation.Standard.COUNT_NOT_NULL_CLEAR_WHEN_ZERO : AtomicMutation.Standard.COUNT_NOT_NULL;
        }
        if ("sum".equals(index.getType())) {
            return AtomicMutationIndexMaintainer.getClearWhenZero(index) ? AtomicMutation.Standard.SUM_LONG_CLEAR_WHEN_ZERO : AtomicMutation.Standard.SUM_LONG;
        }
        if ("min_ever_tuple".equals(index.getType())) {
            return AtomicMutation.Standard.MIN_EVER_TUPLE;
        }
        if ("max_ever_tuple".equals(index.getType())) {
            return AtomicMutation.Standard.MAX_EVER_TUPLE;
        }
        if ("min_ever_long".equals(index.getType()) || "min_ever".equals(index.getType())) {
            return AtomicMutation.Standard.MIN_EVER_LONG;
        }
        if ("max_ever_long".equals(index.getType()) || "max_ever".equals(index.getType())) {
            return AtomicMutation.Standard.MAX_EVER_LONG;
        }
        if ("max_ever_version".equals(index.getType())) {
            return AtomicMutation.Standard.MAX_EVER_VERSION;
        }
        throw new MetaDataException("Unknown index type for " + String.valueOf(index), new Object[0]);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!scanType.equals(IndexScanType.BY_GROUP)) {
            throw new RecordCoreException("Can only scan aggregate index by group.", new Object[0]);
        }
        return this.scan(range, continuation, scanProperties);
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        MutationType mutationType = this.mutation.getMutationType();
        int groupPrefixSize = this.getGroupingCount();
        for (IndexEntry indexEntry : indexEntries) {
            Number numVal;
            byte[] param;
            IndexEntry groupedValue;
            Tuple groupKey;
            long startTime = System.nanoTime();
            if (groupPrefixSize <= 0) {
                groupKey = TupleHelpers.EMPTY;
                groupedValue = indexEntry;
            } else if (groupPrefixSize == indexEntry.getKeySize()) {
                groupKey = indexEntry.getKey();
                groupedValue = indexEntry.subKey(0, 0);
            } else {
                groupKey = TupleHelpers.subTuple(indexEntry.getKey(), 0, groupPrefixSize);
                groupedValue = indexEntry.subKey(groupPrefixSize, indexEntry.getKeySize());
            }
            if ((param = this.mutation.getMutationParam(groupedValue, remove)) == null) continue;
            if (!this.mutation.allowsNegative() && (numVal = (Number)groupedValue.getKeyValue(0)) != null && numVal.longValue() < 0L) {
                throw new RecordCoreException("Attempted update of MAX_EVER_LONG or MIN_EVER_LONG index with negative value", new Object[0]);
            }
            byte[] key = this.state.indexSubspace.pack(groupKey);
            if (AtomicMutation.Standard.MAX_EVER_VERSION.equals(this.mutation)) {
                if (groupedValue.getKey().hasIncompleteVersionstamp()) {
                    this.state.context.updateVersionMutation(MutationType.SET_VERSIONSTAMPED_VALUE, key, param, (oldParam, newParam) -> ByteArrayUtil.compareUnsigned(oldParam, newParam) < 0 ? newParam : oldParam);
                } else {
                    this.state.transaction.mutate(MutationType.BYTE_MAX, key, param);
                }
            } else {
                this.state.transaction.mutate(mutationType, key, param);
                byte[] compareAndClear = this.mutation.getCompareAndClearParam();
                if (compareAndClear != null) {
                    this.state.transaction.mutate(MutationType.COMPARE_AND_CLEAR, key, compareAndClear);
                }
            }
            if (this.state.store.getTimer() == null) continue;
            this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.MUTATE_INDEX_ENTRY, startTime);
        }
        return AsyncUtil.DONE;
    }

    @Override
    protected Tuple decodeValue(@Nonnull byte[] value) {
        switch (this.mutation.getMutationType()) {
            case ADD: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case MIN: 
            case MAX: {
                return Tuple.from(AtomicMutation.Standard.decodeUnsignedLong(value));
            }
        }
        return super.decodeValue(value);
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        return this.matchesAggregateFunction(function) && IndexFunctionHelper.isGroupPrefix(function.getOperand(), this.state.index.getRootExpression());
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationveLevel) {
        if (!this.matchesAggregateFunction(function)) {
            throw new MetaDataException("this index does not support aggregate function: " + String.valueOf(function), new Object[0]);
        }
        RecordCursor<IndexEntry> cursor = this.scan(IndexScanType.BY_GROUP, range, null, new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(isolationveLevel).build()));
        BiFunction<Tuple, Tuple, Tuple> aggregator = this.mutation.getAggregator();
        return cursor.reduce(this.mutation.getIdentity(), (accum, kv) -> (Tuple)aggregator.apply((Tuple)accum, kv.getValue()));
    }

    protected boolean matchesAggregateFunction(@Nonnull IndexAggregateFunction function) {
        String indexType;
        String functionName = function.getName();
        return functionName.equals(indexType = this.state.index.getType()) || "max_ever".equals(functionName) && ("max_ever_long".equals(indexType) || "max_ever_tuple".equals(indexType)) || "min_ever".equals(functionName) && ("min_ever_long".equals(indexType) || "min_ever_tuple".equals(indexType));
    }

    @Override
    public boolean isIdempotent() {
        return this.mutation.isIdempotent();
    }

    @Override
    public boolean skipUpdateForUnchangedKeys() {
        return !"count_updates".equals(this.state.index.getType());
    }
}

