/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.AtomicMutation;
import com.apple.foundationdb.record.provider.foundationdb.indexes.AtomicMutationIndexMaintainer;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidateExpansion;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class AtomicMutationIndexMaintainerFactory
implements IndexMaintainerFactory {
    static final String[] TYPES = new String[]{"count", "count_updates", "count_not_null", "sum", "min_ever_tuple", "max_ever_tuple", "min_ever_long", "max_ever_long", "max_ever_version", "min_ever", "max_ever"};

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return Arrays.asList(TYPES);
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){
            final AtomicMutation mutation;
            {
                this.mutation = AtomicMutationIndexMaintainer.getAtomicMutation(this.index);
            }

            private int getGroupedCount() {
                return ((GroupingKeyExpression)this.index.getRootExpression()).getGroupedCount();
            }

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                if (!this.mutation.hasValues()) {
                    this.validateGrouping(0);
                    if (this.getGroupedCount() != 0) {
                        throw new KeyExpression.InvalidExpressionException("index type does not support non-group fields; use COUNT_NOT_NULL", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                    }
                } else if (!this.mutation.hasSingleValue()) {
                    this.validateGrouping(1);
                } else {
                    this.validateGrouping(1);
                    if (this.getGroupedCount() != 1) {
                        throw new KeyExpression.InvalidExpressionException("index type only supports single field", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                    }
                }
                if (AtomicMutation.Standard.MAX_EVER_VERSION.equals(this.mutation)) {
                    this.validateVersionInGroupedKeys();
                } else {
                    this.validateNotVersion();
                }
                if (AtomicMutationIndexMaintainer.getClearWhenZero(this.index) && this.mutation.getCompareAndClearParam() == null) {
                    throw new MetaDataException("index type does not support clearWhenZero", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType()});
                }
            }

            @Override
            public void validateIndexForRecordType(@Nonnull RecordType recordType, @Nonnull MetaDataValidator metaDataValidator) {
                List<Descriptors.FieldDescriptor> fields = metaDataValidator.validateIndexForRecordType(this.index, recordType);
                if (this.mutation.hasLongValue()) {
                    switch (fields.get(fields.size() - 1).getType()) {
                        case INT64: 
                        case UINT64: 
                        case INT32: 
                        case UINT32: 
                        case SINT32: 
                        case SINT64: {
                            break;
                        }
                        default: {
                            throw new KeyExpression.InvalidExpressionException("index type only supports integer field", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression(), "record_type", recordType.getName()});
                        }
                    }
                }
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new AtomicMutationIndexMaintainer(state);
    }

    @Override
    @Nonnull
    public Iterable<MatchCandidate> createMatchCandidates(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse) {
        if (AggregateIndexExpansionVisitor.supportsAggregateIndexType(index.getType())) {
            return MatchCandidateExpansion.expandAggregateIndexMatchCandidate(metaData, index, reverse);
        }
        return ImmutableList.of();
    }
}

