/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordIndexUniquenessViolation;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class BitmapValueIndexMaintainer
extends StandardIndexMaintainer {
    public static final String AGGREGATE_FUNCTION_NAME = "bitmap_value";
    public static final int DEFAULT_ENTRY_SIZE = 10000;
    public static final int MAX_ENTRY_SIZE = 250000;
    private final int entrySize;
    private final boolean unique;

    public BitmapValueIndexMaintainer(IndexMaintainerState state) {
        super(state);
        String sizeArgument = state.index.getOption("bitmapValueEntrySize");
        int n = this.entrySize = sizeArgument != null ? Integer.parseInt(sizeArgument) : 10000;
        if (this.entrySize > 250000) {
            throw new RecordCoreArgumentException("entry size option is too large", new Object[0]).addLogInfo("entrySize", this.entrySize, "maxEntrySize", 250000);
        }
        this.unique = state.index.isUnique();
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        long endPosition;
        long startPosition;
        if (!scanType.equals(IndexScanType.BY_GROUP)) {
            throw new RecordCoreException("Can only scan bitmap index by group.", new Object[0]);
        }
        int groupPrefixSize = this.getGroupingCount();
        if (range.getLow() != null && range.getLow().size() > groupPrefixSize && range.getLow().get(groupPrefixSize) != null) {
            startPosition = range.getLowEndpoint() == EndpointType.RANGE_EXCLUSIVE ? range.getLow().getLong(groupPrefixSize) + 1L : range.getLow().getLong(groupPrefixSize);
            if (startPosition % (long)this.entrySize != 0L) {
                range = new TupleRange(range.getLow().popBack().add(startPosition - Math.floorMod(startPosition, (long)this.entrySize)), range.getHigh(), EndpointType.RANGE_INCLUSIVE, range.getHighEndpoint());
            }
        } else {
            startPosition = Long.MIN_VALUE;
        }
        if (range.getHigh() != null && range.getHigh().size() > groupPrefixSize && range.getHigh().get(groupPrefixSize) != null) {
            endPosition = range.getHighEndpoint() == EndpointType.RANGE_INCLUSIVE ? range.getHigh().getLong(groupPrefixSize) + 1L : range.getHigh().getLong(groupPrefixSize);
            if (endPosition % (long)this.entrySize != 0L) {
                range = new TupleRange(range.getLow(), range.getHigh().popBack().add(endPosition + Math.floorMod((long)this.entrySize - endPosition, (long)this.entrySize)), range.getLowEndpoint(), EndpointType.RANGE_INCLUSIVE);
            }
        } else {
            endPosition = Long.MAX_VALUE;
        }
        return this.scan(range, continuation, scanProperties).map(indexEntry -> {
            long entryStart = indexEntry.getKey().getLong(groupPrefixSize);
            byte[] entryBitmap = indexEntry.getValue().getBytes(0);
            long entryEnd = entryStart + (long)(entryBitmap.length * 8);
            if (entryStart < startPosition || entryEnd > endPosition) {
                long trimmedEnd;
                long trimmedStart = Math.max(entryStart, startPosition);
                if (trimmedStart < (trimmedEnd = Math.min(entryEnd, endPosition))) {
                    Tuple trimmedKey = indexEntry.getKey().popBack().add(trimmedStart);
                    byte[] trimmedBitmap = new byte[((int)(trimmedEnd - trimmedStart) + 7) / 8];
                    for (long i = trimmedStart; i < trimmedEnd; ++i) {
                        int offset = (int)(i - entryStart);
                        if ((entryBitmap[offset / 8] & (byte)(1 << offset % 8)) == 0) continue;
                        int trimmedOffset = (int)(i - trimmedStart);
                        int n = trimmedOffset / 8;
                        trimmedBitmap[n] = (byte)(trimmedBitmap[n] | (byte)(1 << trimmedOffset % 8));
                    }
                    Tuple subValue = Tuple.from(new Object[]{trimmedBitmap});
                    return Optional.of(new IndexEntry(indexEntry.getIndex(), trimmedKey, subValue));
                }
                return Optional.empty();
            }
            return Optional.of(indexEntry);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    @Nonnull
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        int groupPrefixSize = this.getGroupingCount();
        ArrayList<CompletionStage> futures = this.unique && !remove ? new ArrayList<CompletionStage>(indexEntries.size()) : null;
        for (IndexEntry indexEntry : indexEntries) {
            long startTime = System.nanoTime();
            Tuple groupKey = TupleHelpers.subTuple(indexEntry.getKey(), 0, groupPrefixSize);
            Object positionObject = indexEntry.getKey().get(groupPrefixSize);
            if (positionObject == null) continue;
            if (!(positionObject instanceof Number)) {
                throw new RecordCoreException("position field in index entry is not a number", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.KEY, indexEntry.getKey(), LogMessageKeys.INDEX_NAME, this.state.index.getName(), LogMessageKeys.INDEX_TYPE, this.state.index.getType()});
            }
            long position = ((Number)positionObject).longValue();
            int offset = (int)Math.floorMod(position, (long)this.entrySize);
            byte[] key = this.state.indexSubspace.pack(groupKey.add(position -= (long)offset));
            byte[] bitmap = new byte[(this.entrySize + 7) / 8];
            if (remove) {
                if (this.state.store.isIndexWriteOnly(this.state.index)) {
                    this.state.transaction.mutate(MutationType.BIT_OR, key, bitmap);
                }
                Arrays.fill(bitmap, (byte)-1);
                int n = offset / 8;
                bitmap[n] = (byte)(bitmap[n] & ~((byte)(1 << offset % 8)));
                this.state.transaction.mutate(MutationType.BIT_AND, key, bitmap);
                Arrays.fill(bitmap, (byte)0);
                this.state.transaction.mutate(MutationType.COMPARE_AND_CLEAR, key, bitmap);
            } else {
                if (this.unique) {
                    CompletionStage future = this.state.transaction.snapshot().get(key).thenAccept(existing -> {
                        if (existing != null && (existing[offset / 8] & (byte)(1 << offset % 8)) != 0) {
                            throw new RecordIndexUniquenessViolation(this.state.index, indexEntry, savedRecord.getPrimaryKey(), null);
                        }
                    });
                    futures.add(future);
                    byte[] conflictKey = new Subspace(key).pack(offset);
                    this.state.transaction.addReadConflictKey(conflictKey);
                    this.state.transaction.addWriteConflictKey(conflictKey);
                }
                int n = offset / 8;
                bitmap[n] = (byte)(bitmap[n] | (byte)(1 << offset % 8));
                this.state.transaction.mutate(MutationType.BIT_OR, key, bitmap);
            }
            if (this.state.store.getTimer() == null) continue;
            this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.MUTATE_INDEX_ENTRY, startTime);
        }
        return futures != null ? AsyncUtil.whenAll(futures) : AsyncUtil.DONE;
    }

    @Override
    @Nonnull
    protected Tuple decodeValue(@Nonnull byte[] value) {
        return Tuple.from(new Object[]{value});
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        return AGGREGATE_FUNCTION_NAME.equals(function.getName()) && IndexFunctionHelper.isGroupPrefix(function.getOperand(), this.state.index.getRootExpression());
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationveLevel) {
        long endPosition;
        if (!AGGREGATE_FUNCTION_NAME.equals(function.getName())) {
            throw new MetaDataException("this index does not support aggregate function: " + String.valueOf(function), new Object[0]);
        }
        RecordCursor<IndexEntry> cursor = this.scan(IndexScanType.BY_GROUP, range, null, new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(isolationveLevel).build()));
        int groupPrefixSize = this.getGroupingCount();
        long startPosition = 0L;
        if (range.getLow() != null && range.getLow().size() > groupPrefixSize) {
            startPosition = range.getLow().getLong(groupPrefixSize);
        }
        int size = this.entrySize;
        if (range.getHigh() != null && range.getHigh().size() > groupPrefixSize && (long)size > (endPosition = range.getHigh().getLong(groupPrefixSize)) - startPosition) {
            size = (int)(endPosition - startPosition);
        }
        return cursor.reduce(new BitmapAggregator(startPosition, size), (combined, kv) -> combined.append(kv.getKey().getLong(kv.getKeySize() - 1), kv.getValue().getBytes(0))).thenApply(combined -> Tuple.from(new Object[]{combined.asByteArray()}));
    }

    private static class BitmapAggregator {
        private final long offset;
        private ByteBuffer buffer;

        public BitmapAggregator() {
            this(0L, 10000);
        }

        public BitmapAggregator(long offset, int size) {
            this.offset = offset;
            this.buffer = ByteBuffer.allocate(size);
        }

        public BitmapAggregator append(long position, @Nonnull byte[] bytes) {
            if ((position -= this.offset) < 0L) {
                throw new RecordCoreException("For negative positions, must specify negative range start", new Object[0]);
            }
            if (position % 8L != 0L) {
                throw new RecordCoreException("Position must be on even byte boundary", new Object[0]);
            }
            if (position > 0x3FFFFFFF8L) {
                throw new RecordCoreException("For large positions, must specify large range start", new Object[0]);
            }
            int bytePosition = (int)(position / 8L);
            if (bytePosition + bytes.length > this.buffer.capacity()) {
                ByteBuffer newBuffer = ByteBuffer.allocate(bytePosition + bytes.length);
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            this.buffer.position(bytePosition);
            this.buffer.put(bytes);
            return this;
        }

        @Nonnull
        public byte[] asByteArray() {
            return this.buffer.array();
        }
    }
}

