/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.BitmapValueIndexMaintainer;
import com.apple.foundationdb.record.query.plan.cascades.BitmapAggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.IndexExpansionInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidateExpansion;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class BitmapValueIndexMaintainerFactory
implements IndexMaintainerFactory {
    @Nonnull
    private static final List<String> TYPES = Collections.singletonList("bitmap_value");

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return TYPES;
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                this.validateGrouping(1);
                GroupingKeyExpression group = (GroupingKeyExpression)this.index.getRootExpression();
                if (group.getGroupedCount() != 1) {
                    throw new KeyExpression.InvalidExpressionException("index type needs grouped position", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                }
                this.validateNotVersion();
            }

            @Override
            public void validateIndexForRecordType(@Nonnull RecordType recordType, @Nonnull MetaDataValidator metaDataValidator) {
                List<Descriptors.FieldDescriptor> fields = metaDataValidator.validateIndexForRecordType(this.index, recordType);
                switch (fields.get(fields.size() - 1).getType()) {
                    case INT64: 
                    case UINT64: 
                    case INT32: 
                    case UINT32: 
                    case SINT32: 
                    case SINT64: 
                    case FIXED32: 
                    case FIXED64: 
                    case SFIXED32: 
                    case SFIXED64: {
                        break;
                    }
                    default: {
                        throw new KeyExpression.InvalidExpressionException("index type only supports integer position key", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression(), "record_type", recordType.getName()});
                    }
                }
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new BitmapValueIndexMaintainer(state);
    }

    @Override
    @Nonnull
    public Iterable<MatchCandidate> createMatchCandidates(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse) {
        IndexExpansionInfo info = IndexExpansionInfo.createInfo(metaData, index, reverse);
        BitmapAggregateIndexExpansionVisitor expansionVisitor = new BitmapAggregateIndexExpansionVisitor(info.getIndex(), info.getIndexedRecordTypes());
        return MatchCandidateExpansion.optionalToIterable(MatchCandidateExpansion.expandIndexMatchCandidate(info, null, expansionVisitor));
    }
}

