/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.google.protobuf.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class InvalidIndexEntry {
    @Nonnull
    private IndexEntry entry;
    @Nonnull
    private Reason reason;
    @Nullable
    private FDBStoredRecord<Message> record;

    private InvalidIndexEntry(@Nonnull IndexEntry entry, @Nonnull Reason reason, @Nullable FDBStoredRecord<Message> record) {
        this.entry = entry;
        this.reason = reason;
        this.record = record;
    }

    public static InvalidIndexEntry newOrphan(@Nonnull IndexEntry entry) {
        return new InvalidIndexEntry(entry, Reasons.ORPHAN, null);
    }

    public static InvalidIndexEntry newMissing(@Nonnull IndexEntry entry, @Nonnull FDBStoredRecord<Message> record) {
        return new InvalidIndexEntry(entry, Reasons.MISSING, record);
    }

    @Nonnull
    public IndexEntry getEntry() {
        return this.entry;
    }

    @Nonnull
    public Reason getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InvalidIndexEntry{");
        sb.append("entry=").append(this.entry);
        sb.append(", reason=").append(this.reason);
        sb.append(", record=").append(this.record);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidIndexEntry that = (InvalidIndexEntry)o;
        return this.entry.equals(that.entry) && this.reason.equals(that.reason) && Objects.equals(this.record, that.record);
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.reason, this.record);
    }

    public static interface Reason {
        public String name();

        public String description();
    }

    public static enum Reasons implements Reason
    {
        ORPHAN("index entry does not point to an existing record"),
        MISSING("index entry is missing for a record");

        private final String description;

        private Reasons(String description) {
            this.description = description;
        }

        @Override
        public String description() {
            return this.description;
        }
    }
}

