/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MultiDimensionalIndexHelper {
    private MultiDimensionalIndexHelper() {
    }

    public static RTree.Config getConfig(@Nonnull Index index) {
        String rtreeUseNodeSlotIndex;
        String rtreeStorage;
        String rtreeSplitS;
        String rtreeMaxMOption;
        RTree.ConfigBuilder builder = RTree.newConfigBuilder();
        String rtreeMinMOption = index.getOption("rtreeMinimumM");
        if (rtreeMinMOption != null) {
            builder.setMinM(Integer.parseInt(rtreeMinMOption));
        }
        if ((rtreeMaxMOption = index.getOption("rtreeMaximumM")) != null) {
            builder.setMaxM(Integer.parseInt(rtreeMaxMOption));
        }
        if ((rtreeSplitS = index.getOption("rtreeSplitS")) != null) {
            builder.setSplitS(Integer.parseInt(rtreeSplitS));
        }
        if ((rtreeStorage = index.getOption("rtreeStorage")) != null) {
            builder.setStorage(RTree.Storage.valueOf(rtreeStorage));
        }
        String rtreeStoreHilbertValues = index.getOption("rtreeStoreHilbertValues");
        if (rtreeStorage != null) {
            builder.setStoreHilbertValues(Boolean.parseBoolean(rtreeStoreHilbertValues));
        }
        if ((rtreeUseNodeSlotIndex = index.getOption("rtreeUseNodeSlotIndex")) != null) {
            builder.setUseNodeSlotIndex(Boolean.parseBoolean(rtreeUseNodeSlotIndex));
        }
        return builder.build();
    }

    public static enum Events implements StoreTimer.DetailEvent
    {
        MULTIDIMENSIONAL_SCAN("scannig the R-tree of a multidimensional index"),
        MULTIDIMENSIONAL_SKIP_SCAN("skip scan the prefix tuples of a multidimensional scan"),
        MULTIDIMENSIONAL_MODIFICATION("modifying the R-tree of a multidimensional index");

        private final String title;
        private final String logKey;

        private Events(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.DetailEvent.super.logKey();
        }

        private Events(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }
}

