/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.ItemSlot;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeHelpers;
import com.apple.foundationdb.async.rtree.OnReadListener;
import com.apple.foundationdb.async.rtree.OnWriteListener;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.async.rtree.RTreeHilbertCurveHelpers;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.AsyncIteratorCursor;
import com.apple.foundationdb.record.cursors.AsyncLockCursor;
import com.apple.foundationdb.record.cursors.ChainedCursor;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.cursors.LazyCursor;
import com.apple.foundationdb.record.locking.AsyncLock;
import com.apple.foundationdb.record.locking.LockIdentifier;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.DimensionsKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.MultidimensionalIndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.indexes.MultiDimensionalIndexHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MultidimensionalIndexMaintainer
extends StandardIndexMaintainer {
    private static final byte nodeSlotIndexSubspaceIndicator = 0;
    @Nonnull
    private final RTree.Config config;

    public MultidimensionalIndexMaintainer(IndexMaintainerState state) {
        super(state);
        this.config = MultiDimensionalIndexHelper.getConfig(state.index);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!scanBounds.getScanType().equals(IndexScanType.BY_VALUE)) {
            throw new RecordCoreException("Can only scan multidimensional index by value.", new Object[0]);
        }
        if (!(scanBounds instanceof MultidimensionalIndexScanBounds)) {
            throw new RecordCoreException("Need proper multidimensional index scan bounds.", new Object[0]);
        }
        MultidimensionalIndexScanBounds mDScanBounds = (MultidimensionalIndexScanBounds)scanBounds;
        DimensionsKeyExpression dimensionsKeyExpression = MultidimensionalIndexMaintainer.getDimensionsKeyExpression(this.state.index.getRootExpression());
        int prefixSize = dimensionsKeyExpression.getPrefixSize();
        ExecuteProperties executeProperties = scanProperties.getExecuteProperties();
        ScanProperties innerScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndLimit);
        CursorLimitManager cursorLimitManager = new CursorLimitManager(this.state.context, innerScanProperties);
        Subspace indexSubspace = this.getIndexSubspace();
        Subspace nodeSlotIndexSubspace = this.getNodeSlotIndexSubspace();
        FDBStoreTimer timer = Objects.requireNonNull(this.state.context.getTimer());
        return RecordCursor.flatMapPipelined(this.prefixSkipScan(prefixSize, timer, mDScanBounds, innerScanProperties), (prefixTuple, innerContinuation) -> {
            Subspace rtNodeSlotIndexSubspace;
            Subspace rtSubspace;
            if (prefixTuple != null) {
                Verify.verify(prefixTuple.size() == prefixSize);
                rtSubspace = indexSubspace.subspace((Tuple)prefixTuple);
                rtNodeSlotIndexSubspace = nodeSlotIndexSubspace.subspace((Tuple)prefixTuple);
            } else {
                rtSubspace = indexSubspace;
                rtNodeSlotIndexSubspace = nodeSlotIndexSubspace;
            }
            Continuation parsedContinuation = Continuation.fromBytes(innerContinuation);
            BigInteger lastHilbertValue = parsedContinuation == null ? null : parsedContinuation.getLastHilbertValue();
            Tuple lastKey = parsedContinuation == null ? null : parsedContinuation.getLastKey();
            RTree rTree = new RTree(rtSubspace, rtNodeSlotIndexSubspace, this.getExecutor(), this.config, RTreeHilbertCurveHelpers::hilbertValue, NodeHelpers::newRandomNodeId, OnWriteListener.NOOP, new OnRead(cursorLimitManager, timer));
            ReadTransaction transaction = this.state.context.readTransaction(true);
            return new LazyCursor<ItemSlot>((CompletableFuture<RecordCursor<ItemSlot>>)this.state.context.acquireReadLock(new LockIdentifier(rtSubspace)).thenApply(lock -> new AsyncLockCursor<ItemSlot>((AsyncLock)lock, new ItemSlotCursor(this.getExecutor(), rTree.scan(transaction, lastHilbertValue, lastKey, mDScanBounds::overlapsMbrApproximately, (low, high) -> mDScanBounds.getSuffixRange().overlaps((Tuple)low, (Tuple)high)), cursorLimitManager, timer))), this.state.context.getExecutor()).filter(itemSlot -> lastHilbertValue == null || lastKey == null || itemSlot.compareHilbertValueAndKey(lastHilbertValue, lastKey) > 0).filter(itemSlot -> mDScanBounds.containsPosition(itemSlot.getPosition())).filter(itemSlot -> mDScanBounds.getSuffixRange().contains(itemSlot.getKeySuffix())).map(itemSlot -> {
                ArrayList<Object> keyItems = Lists.newArrayList();
                if (prefixTuple != null) {
                    keyItems.addAll(prefixTuple.getItems());
                }
                keyItems.addAll(itemSlot.getPosition().getCoordinates().getItems());
                keyItems.addAll(itemSlot.getKeySuffix().getItems());
                return new IndexEntry(this.state.index, Tuple.fromList(keyItems), itemSlot.getValue());
            });
        }, continuation, this.state.store.getPipelineSize(PipelineOperation.INDEX_TO_RECORD)).skipThenLimit(executeProperties.getSkip(), executeProperties.getReturnedRowLimit());
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        throw new RecordCoreException("index maintainer does not support this scan api", new Object[0]);
    }

    @Nonnull
    private Function<byte[], RecordCursor<Tuple>> prefixSkipScan(int prefixSize, @Nonnull StoreTimer timer, @Nonnull MultidimensionalIndexScanBounds mDScanBounds, @Nonnull ScanProperties innerScanProperties) {
        Function<byte[], RecordCursor<Tuple>> outerFunction = prefixSize > 0 ? outerContinuation -> timer.instrument((StoreTimer.Event)MultiDimensionalIndexHelper.Events.MULTIDIMENSIONAL_SKIP_SCAN, new ChainedCursor<Tuple>(this.state.context, lastKeyOptional -> this.nextPrefixTuple(mDScanBounds.getPrefixRange(), prefixSize, lastKeyOptional.orElse(null), innerScanProperties), Tuple::pack, Tuple::fromBytes, (byte[])outerContinuation, innerScanProperties)) : outerContinuation -> RecordCursor.fromFuture(CompletableFuture.completedFuture(null));
        return outerFunction;
    }

    private CompletableFuture<Optional<Tuple>> nextPrefixTuple(@Nonnull TupleRange prefixRange, int prefixSize, @Nullable Tuple lastPrefixTuple, @Nonnull ScanProperties scanProperties) {
        KeyValueCursor cursor;
        Subspace indexSubspace = this.getIndexSubspace();
        if (lastPrefixTuple == null) {
            cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(indexSubspace).setContext(this.state.context)).setRange(prefixRange)).setContinuation(null)).setScanProperties(scanProperties.setStreamingMode(CursorStreamingMode.ITERATOR).with(innerExecuteProperties -> innerExecuteProperties.setReturnedRowLimit(1)))).build();
        } else {
            KeyValueCursor.Builder builder = (KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(indexSubspace).setContext(this.state.context)).setContinuation(null)).setScanProperties(scanProperties)).setScanProperties(scanProperties.setStreamingMode(CursorStreamingMode.ITERATOR).with(innerExecuteProperties -> innerExecuteProperties.setReturnedRowLimit(1)));
            cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)builder.setLow(indexSubspace.pack(lastPrefixTuple), EndpointType.RANGE_EXCLUSIVE)).setHigh(prefixRange.getHigh(), prefixRange.getHighEndpoint())).build();
        }
        return cursor.onNext().thenApply(next -> {
            cursor.close();
            if (next.hasNext()) {
                KeyValue kv = Objects.requireNonNull((KeyValue)next.get());
                return Optional.of(TupleHelpers.subTuple(indexSubspace.unpack(kv.getKey()), 0, prefixSize));
            }
            return Optional.empty();
        });
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        DimensionsKeyExpression dimensionsKeyExpression = MultidimensionalIndexMaintainer.getDimensionsKeyExpression(this.state.index.getRootExpression());
        int prefixSize = dimensionsKeyExpression.getPrefixSize();
        int dimensionsSize = dimensionsKeyExpression.getDimensionsSize();
        Subspace indexSubspace = this.getIndexSubspace();
        Subspace nodeSlotIndexSubspace = this.getNodeSlotIndexSubspace();
        List futures = indexEntries.stream().map(indexEntry -> {
            Subspace rtNodeSlotIndexSubspace;
            Subspace rtSubspace;
            List<Object> indexKeyItems = indexEntry.getKey().getItems();
            Tuple prefixKey = Tuple.fromList(indexKeyItems.subList(0, prefixSize));
            if (prefixSize > 0) {
                rtSubspace = indexSubspace.subspace(prefixKey);
                rtNodeSlotIndexSubspace = nodeSlotIndexSubspace.subspace(prefixKey);
            } else {
                rtSubspace = indexSubspace;
                rtNodeSlotIndexSubspace = nodeSlotIndexSubspace;
            }
            return this.state.context.doWithWriteLock(new LockIdentifier(rtSubspace), () -> {
                RTree.Point point = MultidimensionalIndexMaintainer.validatePoint(new RTree.Point(Tuple.fromList(indexKeyItems.subList(prefixSize, prefixSize + dimensionsSize))));
                ArrayList<Object> primaryKeyParts = Lists.newArrayList(savedRecord.getPrimaryKey().getItems());
                this.state.index.trimPrimaryKey(primaryKeyParts);
                ArrayList<Object> keySuffixParts = Lists.newArrayList(indexKeyItems.subList(prefixSize + dimensionsSize, indexKeyItems.size()));
                keySuffixParts.addAll(primaryKeyParts);
                Tuple keySuffix = Tuple.fromList(keySuffixParts);
                FDBStoreTimer timer = Objects.requireNonNull(this.getTimer());
                RTree rTree = new RTree(rtSubspace, rtNodeSlotIndexSubspace, this.getExecutor(), this.config, RTreeHilbertCurveHelpers::hilbertValue, NodeHelpers::newRandomNodeId, new OnWrite(timer), OnReadListener.NOOP);
                if (remove) {
                    return rTree.delete(this.state.transaction, point, keySuffix);
                }
                return rTree.insertOrUpdate(this.state.transaction, point, keySuffix, indexEntry.getValue());
            });
        }).collect(Collectors.toList());
        return AsyncUtil.whenAll(futures);
    }

    @Override
    public boolean canDeleteWhere(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        if (!super.canDeleteWhere(matcher, evaluated)) {
            return false;
        }
        return evaluated.size() <= MultidimensionalIndexMaintainer.getDimensionsKeyExpression(this.state.index.getRootExpression()).getPrefixSize();
    }

    @Override
    public CompletableFuture<Void> deleteWhere(@Nonnull Transaction tr, @Nonnull Tuple prefix) {
        Verify.verify(MultidimensionalIndexMaintainer.getDimensionsKeyExpression(this.state.index.getRootExpression()).getPrefixSize() >= prefix.size());
        return super.deleteWhere(tr, prefix).thenApply(v -> {
            Subspace nodeSlotIndexSubspace = this.getNodeSlotIndexSubspace();
            byte[] key = nodeSlotIndexSubspace.pack(prefix);
            this.state.context.clear(new Range(key, ByteArrayUtil.strinc(key)));
            return v;
        });
    }

    @Nonnull
    private Subspace getNodeSlotIndexSubspace() {
        return this.getSecondarySubspace().subspace(Tuple.from((byte)0));
    }

    @Nonnull
    public static DimensionsKeyExpression getDimensionsKeyExpression(@Nonnull KeyExpression root) {
        if (root instanceof KeyWithValueExpression) {
            KeyExpression innerKey = ((KeyWithValueExpression)root).getInnerKey();
            while (innerKey instanceof ThenKeyExpression) {
                innerKey = ((ThenKeyExpression)innerKey).getChildren().get(0);
            }
            if (innerKey instanceof DimensionsKeyExpression) {
                return (DimensionsKeyExpression)innerKey;
            }
            throw new RecordCoreException("structure of multidimensional index is not supported", new Object[0]);
        }
        return (DimensionsKeyExpression)root;
    }

    @Nonnull
    private static RTree.Point validatePoint(@Nonnull RTree.Point point) {
        for (int d = 0; d < point.getNumDimensions(); ++d) {
            Object coordinate = point.getCoordinate(d);
            Preconditions.checkArgument(coordinate == null || coordinate instanceof Long, "dimension coordinates must be of type long");
        }
        return point;
    }

    static class OnWrite
    implements OnWriteListener {
        @Nonnull
        private final FDBStoreTimer timer;

        public OnWrite(@Nonnull FDBStoreTimer timer) {
            this.timer = timer;
        }

        @Override
        public <T extends Node> CompletableFuture<T> onAsyncReadForWrite(@Nonnull CompletableFuture<T> future) {
            return this.timer.instrument((StoreTimer.Event)MultiDimensionalIndexHelper.Events.MULTIDIMENSIONAL_MODIFICATION, future);
        }

        @Override
        public void onNodeWritten(@Nonnull Node node) {
            switch (node.getKind()) {
                case LEAF: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_LEAF_NODE_WRITES);
                    break;
                }
                case INTERMEDIATE: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_INTERMEDIATE_NODE_WRITES);
                    break;
                }
                default: {
                    throw new RecordCoreException("unsupported kind of node", new Object[0]);
                }
            }
        }

        @Override
        public void onKeyValueWritten(@Nonnull Node node, @Nullable byte[] key, @Nullable byte[] value) {
            int keyLength = key == null ? 0 : key.length;
            int valueLength = value == null ? 0 : value.length;
            int totalLength = keyLength + valueLength;
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_KEY);
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_KEY_BYTES, keyLength);
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_VALUE_BYTES, valueLength);
            switch (node.getKind()) {
                case LEAF: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_LEAF_NODE_WRITE_BYTES, totalLength);
                    break;
                }
                case INTERMEDIATE: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_INTERMEDIATE_NODE_WRITE_BYTES, totalLength);
                    break;
                }
                default: {
                    throw new RecordCoreException("unsupported kind of node", new Object[0]);
                }
            }
        }
    }

    private static class Continuation
    implements RecordCursorContinuation {
        @Nullable
        final BigInteger lastHilbertValue;
        @Nullable
        final Tuple lastKey;
        @Nullable
        private ByteString cachedByteString;
        @Nullable
        private byte[] cachedBytes;

        private Continuation(@Nullable BigInteger lastHilbertValue, @Nullable Tuple lastKey) {
            this.lastHilbertValue = lastHilbertValue;
            this.lastKey = lastKey;
        }

        @Nullable
        public BigInteger getLastHilbertValue() {
            return this.lastHilbertValue;
        }

        @Nullable
        public Tuple getLastKey() {
            return this.lastKey;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.isEnd()) {
                return ByteString.EMPTY;
            }
            if (this.cachedByteString == null) {
                this.cachedByteString = RecordCursorProto.MultidimensionalIndexScanContinuation.newBuilder().setLastHilbertValue(ByteString.copyFrom(Objects.requireNonNull(this.lastHilbertValue).toByteArray())).setLastKey(ByteString.copyFrom(Objects.requireNonNull(this.lastKey).pack())).build().toByteString();
            }
            return this.cachedByteString;
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.isEnd()) {
                return null;
            }
            if (this.cachedBytes == null) {
                this.cachedBytes = this.toByteString().toByteArray();
            }
            return this.cachedBytes;
        }

        @Override
        public boolean isEnd() {
            return this.lastHilbertValue == null || this.lastKey == null;
        }

        @Nullable
        private static Continuation fromBytes(@Nullable byte[] continuationBytes) {
            if (continuationBytes != null) {
                RecordCursorProto.MultidimensionalIndexScanContinuation parsed;
                try {
                    parsed = RecordCursorProto.MultidimensionalIndexScanContinuation.parseFrom(continuationBytes);
                }
                catch (InvalidProtocolBufferException ex) {
                    throw new RecordCoreException("error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuationBytes));
                }
                return new Continuation(new BigInteger(parsed.getLastHilbertValue().toByteArray()), Tuple.fromBytes(parsed.getLastKey().toByteArray()));
            }
            return null;
        }
    }

    static class OnRead
    implements OnReadListener {
        @Nonnull
        private final CursorLimitManager cursorLimitManager;
        @Nonnull
        private final FDBStoreTimer timer;

        public OnRead(@Nonnull CursorLimitManager cursorLimitManager, @Nonnull FDBStoreTimer timer) {
            this.cursorLimitManager = cursorLimitManager;
            this.timer = timer;
        }

        @Override
        public <T extends Node> CompletableFuture<T> onAsyncRead(@Nonnull CompletableFuture<T> future) {
            return this.timer.instrument((StoreTimer.Event)MultiDimensionalIndexHelper.Events.MULTIDIMENSIONAL_SCAN, future);
        }

        @Override
        public void onNodeRead(@Nonnull Node node) {
            switch (node.getKind()) {
                case LEAF: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_LEAF_NODE_READS);
                    break;
                }
                case INTERMEDIATE: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_INTERMEDIATE_NODE_READS);
                    break;
                }
                default: {
                    throw new RecordCoreException("unsupported kind of node", new Object[0]);
                }
            }
        }

        @Override
        public void onKeyValueRead(@Nonnull Node node, @Nullable byte[] key, @Nullable byte[] value) {
            int keyLength = key == null ? 0 : key.length;
            int valueLength = value == null ? 0 : value.length;
            int totalLength = keyLength + valueLength;
            this.cursorLimitManager.reportScannedBytes(totalLength);
            this.cursorLimitManager.tryRecordScan();
            this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_KEY);
            this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_KEY_BYTES, keyLength);
            this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_VALUE_BYTES, valueLength);
            switch (node.getKind()) {
                case LEAF: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_LEAF_NODE_READ_BYTES, totalLength);
                    break;
                }
                case INTERMEDIATE: {
                    this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_INTERMEDIATE_NODE_READ_BYTES, totalLength);
                    break;
                }
                default: {
                    throw new RecordCoreException("unsupported kind of node", new Object[0]);
                }
            }
        }

        @Override
        public void onChildNodeDiscard(@Nonnull ChildSlot childSlot) {
            this.timer.increment(FDBStoreTimer.Counts.MULTIDIMENSIONAL_CHILD_NODE_DISCARDS);
        }
    }

    static class ItemSlotCursor
    extends AsyncIteratorCursor<ItemSlot> {
        @Nonnull
        private final CursorLimitManager cursorLimitManager;
        @Nonnull
        private final FDBStoreTimer timer;

        public ItemSlotCursor(@Nonnull Executor executor, @Nonnull AsyncIterator<ItemSlot> iterator, @Nonnull CursorLimitManager cursorLimitManager, @Nonnull FDBStoreTimer timer) {
            super(executor, iterator);
            this.cursorLimitManager = cursorLimitManager;
            this.timer = timer;
        }

        @Override
        @Nonnull
        public CompletableFuture<RecordCursorResult<ItemSlot>> onNext() {
            if (this.nextResult != null && !this.nextResult.hasNext()) {
                return CompletableFuture.completedFuture(this.nextResult);
            }
            if (this.cursorLimitManager.tryRecordScan()) {
                return ((AsyncIterator)this.iterator).onHasNext().thenApply(hasNext -> {
                    if (hasNext.booleanValue()) {
                        ItemSlot itemSlot = (ItemSlot)((AsyncIterator)this.iterator).next();
                        this.timer.increment(FDBStoreTimer.Counts.LOAD_SCAN_ENTRY);
                        this.timer.increment(FDBStoreTimer.Counts.LOAD_KEY_VALUE);
                        ++this.valuesSeen;
                        this.nextResult = RecordCursorResult.withNextValue(itemSlot, new Continuation(itemSlot.getHilbertValue(), itemSlot.getKey()));
                    } else {
                        this.nextResult = RecordCursorResult.exhausted();
                    }
                    return this.nextResult;
                });
            }
            Optional<RecordCursor.NoNextReason> stoppedReason = this.cursorLimitManager.getStoppedReason();
            if (stoppedReason.isEmpty()) {
                throw new RecordCoreException("limit manager stopped cursor but did not report a reason", new Object[0]);
            }
            Verify.verifyNotNull(this.nextResult, "should have seen at least one record", new Object[0]);
            this.nextResult = RecordCursorResult.withoutNextValue(this.nextResult.getContinuation(), stoppedReason.get());
            return CompletableFuture.completedFuture(this.nextResult);
        }
    }
}

