/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.expressions.DimensionsKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.MultiDimensionalIndexHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.MultidimensionalIndexMaintainer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MultidimensionalIndexMaintainerFactory
implements IndexMaintainerFactory {
    static final String[] TYPES = new String[]{"multidimensional"};

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return Arrays.asList(TYPES);
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                this.validateNotGrouping();
                this.validateNotVersion();
                this.validateStructure();
            }

            private void validateStructure() {
                KeyExpression key = this.index.getRootExpression();
                if (key instanceof KeyWithValueExpression) {
                    KeyWithValueExpression keyWithValueExpression = (KeyWithValueExpression)key;
                    key = keyWithValueExpression.getInnerKey();
                    while (key instanceof ThenKeyExpression) {
                        key = ((ThenKeyExpression)key).getChildren().get(0);
                    }
                    if (!(key instanceof DimensionsKeyExpression)) {
                        throw new KeyExpression.InvalidExpressionException("no dimensions key expression or at incorrect place in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                    }
                    DimensionsKeyExpression dimensionsKeyExpression = (DimensionsKeyExpression)key;
                    this.validateDimensions(dimensionsKeyExpression);
                    if (dimensionsKeyExpression.getColumnSize() != keyWithValueExpression.getSplitPoint()) {
                        throw new KeyExpression.InvalidExpressionException("dimensions key expression must cover exactly all key parts in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                    }
                } else {
                    if (!(key instanceof DimensionsKeyExpression)) {
                        throw new KeyExpression.InvalidExpressionException("no dimensions key expression or at incorrect place in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                    }
                    this.validateDimensions((DimensionsKeyExpression)key);
                }
            }

            private void validateDimensions(@Nonnull DimensionsKeyExpression dimensionsKeyExpression) {
                if (dimensionsKeyExpression.getPrefixSize() + dimensionsKeyExpression.getDimensionsSize() > dimensionsKeyExpression.getColumnSize()) {
                    throw new KeyExpression.InvalidExpressionException("dimensions key expression declares wider prefix/dimensions than it covers in index", new Object[]{LogMessageKeys.INDEX_TYPE, this.index.getType(), LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_KEY, this.index.getRootExpression()});
                }
            }

            @Override
            public void validateChangedOptions(@Nonnull Index oldIndex, @Nonnull Set<String> changedOptions) {
                if (!changedOptions.isEmpty()) {
                    RTree.Config oldOptions = MultiDimensionalIndexHelper.getConfig(oldIndex);
                    RTree.Config newOptions = MultiDimensionalIndexHelper.getConfig(this.index);
                    if (changedOptions.contains("rtreeMinimumM")) {
                        if (oldOptions.getMinM() != newOptions.getMinM()) {
                            throw new MetaDataException("rtree minM changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeMinimumM");
                    }
                    if (changedOptions.contains("rtreeMaximumM")) {
                        if (oldOptions.getMaxM() != newOptions.getMaxM()) {
                            throw new MetaDataException("rtree minM changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeMaximumM");
                    }
                    if (changedOptions.contains("rtreeSplitS")) {
                        if (oldOptions.getSplitS() != newOptions.getSplitS()) {
                            throw new MetaDataException("rtree splitS changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeSplitS");
                    }
                    if (changedOptions.contains("rtreeStorage")) {
                        if (!Objects.equals((Object)oldOptions.getStorage(), (Object)newOptions.getStorage())) {
                            throw new MetaDataException("rtree storage changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeStorage");
                    }
                    if (changedOptions.contains("rtreeStoreHilbertValues")) {
                        if (oldOptions.isStoreHilbertValues() != newOptions.isStoreHilbertValues()) {
                            throw new MetaDataException("rtree store Hilbert values changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeStoreHilbertValues");
                    }
                    if (changedOptions.contains("rtreeUseNodeSlotIndex")) {
                        if (oldOptions.isUseNodeSlotIndex() != newOptions.isUseNodeSlotIndex()) {
                            throw new MetaDataException("rtree use node slot index changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rtreeUseNodeSlotIndex");
                    }
                }
                super.validateChangedOptions(oldIndex, changedOptions);
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new MultidimensionalIndexMaintainer(state);
    }
}

