/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class PermutedMinMaxIndexMaintainer
extends StandardIndexMaintainer {
    private final Type type;
    private final int permutedSize;

    public PermutedMinMaxIndexMaintainer(@Nonnull IndexMaintainerState state) {
        super(state);
        this.type = PermutedMinMaxIndexMaintainer.getType(state.index);
        this.permutedSize = PermutedMinMaxIndexMaintainer.getPermutedSize(state.index);
    }

    protected static int getPermutedSize(@Nonnull Index index) {
        String permutedSizeOption = index.getOption("permutedSize");
        if (permutedSizeOption == null) {
            throw new MetaDataException("permuted size not specified", new Object[]{LogMessageKeys.INDEX_NAME, index.getName()});
        }
        return Integer.parseInt(permutedSizeOption);
    }

    protected static Type getType(@Nonnull Index index) {
        if ("permuted_min".equals(index.getType())) {
            return Type.MIN;
        }
        if ("permuted_max".equals(index.getType())) {
            return Type.MAX;
        }
        throw new MetaDataException("Unknown index type for " + String.valueOf(index), new Object[0]);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (scanType.equals(IndexScanType.BY_VALUE)) {
            return this.scan(range, continuation, scanProperties);
        }
        if (scanType.equals(IndexScanType.BY_GROUP)) {
            Subspace permutedSubspace = this.getSecondarySubspace();
            KeyValueCursor keyValues = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(permutedSubspace).setContext(this.state.context)).setRange(range)).setContinuation(continuation)).setScanProperties(scanProperties)).build();
            return keyValues.map(kv -> {
                this.state.store.countKeyValue(FDBStoreTimer.Counts.LOAD_INDEX_KEY, FDBStoreTimer.Counts.LOAD_INDEX_KEY_BYTES, FDBStoreTimer.Counts.LOAD_INDEX_VALUE_BYTES, (KeyValue)kv);
                return this.unpackKeyValue(permutedSubspace, (KeyValue)kv);
            });
        }
        throw new RecordCoreException("Can only scan permuted index by value or group.", new Object[0]);
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        int groupPrefixSize = this.getGroupingCount();
        int totalSize = this.state.index.getColumnSize();
        Subspace permutedSubspace = this.getSecondarySubspace();
        int permutePosition = groupPrefixSize - this.permutedSize;
        Map<Tuple, IndexEntry> entryPerGroupMap = this.extremumEntriesByGroup(indexEntries);
        if (remove) {
            return super.updateIndexKeys(savedRecord, remove, indexEntries).thenCompose(vignore -> {
                ArrayList<CompletionStage> work = new ArrayList<CompletionStage>(entryPerGroupMap.size());
                for (Map.Entry entry : entryPerGroupMap.entrySet()) {
                    Tuple groupKey = (Tuple)entry.getKey();
                    IndexEntry indexEntry = (IndexEntry)entry.getValue();
                    Tuple value = TupleHelpers.subTuple(indexEntry.getKey(), groupPrefixSize, totalSize);
                    Tuple groupPrefix = TupleHelpers.subTuple(groupKey, 0, permutePosition);
                    Tuple groupSuffix = TupleHelpers.subTuple(groupKey, permutePosition, groupPrefixSize);
                    byte[] permutedKeyToRemove = permutedSubspace.pack(groupPrefix.addAll(value).addAll(groupSuffix));
                    work.add(this.state.store.ensureContextActive().get(permutedKeyToRemove).thenCompose(permutedValueExists -> {
                        if (permutedValueExists == null) {
                            return AsyncUtil.DONE;
                        }
                        return this.getExtremum(groupKey).thenApply(extremum -> {
                            if (extremum == null) {
                                this.state.store.ensureContextActive().clear(permutedKeyToRemove);
                            } else {
                                Tuple remainingValue = TupleHelpers.subTuple(extremum, groupPrefixSize, totalSize);
                                if (!value.equals(remainingValue)) {
                                    byte[] permutedKeyToAdd = permutedSubspace.pack(groupPrefix.addAll(remainingValue).addAll(groupSuffix));
                                    Transaction tr = this.state.store.ensureContextActive();
                                    tr.clear(permutedKeyToRemove);
                                    tr.set(permutedKeyToAdd, TupleHelpers.EMPTY.pack());
                                }
                            }
                            return null;
                        });
                    }));
                }
                return AsyncUtil.whenAll(work);
            });
        }
        ArrayList<CompletionStage> work = new ArrayList<CompletionStage>(entryPerGroupMap.size());
        for (Map.Entry<Tuple, IndexEntry> entry : entryPerGroupMap.entrySet()) {
            Tuple groupKey = entry.getKey();
            IndexEntry indexEntry = entry.getValue();
            Tuple value = TupleHelpers.subTuple(indexEntry.getKey(), groupPrefixSize, totalSize);
            Tuple groupPrefix = TupleHelpers.subTuple(groupKey, 0, permutePosition);
            Tuple groupSuffix = TupleHelpers.subTuple(groupKey, permutePosition, groupPrefixSize);
            work.add(this.getExtremum(groupKey).thenApply(extremum -> {
                boolean addPermuted;
                if (extremum == null) {
                    addPermuted = true;
                } else {
                    Tuple currentValue = TupleHelpers.subTuple(extremum, groupPrefixSize, totalSize);
                    addPermuted = this.type.shouldUpdateExtremum(currentValue, value);
                    if (addPermuted) {
                        byte[] permutedKeyToRemove = permutedSubspace.pack(groupPrefix.addAll(currentValue).addAll(groupSuffix));
                        this.state.store.ensureContextActive().clear(permutedKeyToRemove);
                    }
                }
                if (addPermuted) {
                    byte[] permutedKeyToAdd = permutedSubspace.pack(groupPrefix.addAll(value).addAll(groupSuffix));
                    this.state.store.ensureContextActive().set(permutedKeyToAdd, TupleHelpers.EMPTY.pack());
                }
                return null;
            }));
        }
        return AsyncUtil.whenAll(work).thenCompose(ignore -> super.updateIndexKeys(savedRecord, remove, indexEntries));
    }

    @Nonnull
    private Map<Tuple, IndexEntry> extremumEntriesByGroup(@Nonnull List<IndexEntry> entries) {
        if (entries.isEmpty()) {
            return Collections.emptyMap();
        }
        if (entries.size() == 1) {
            IndexEntry entry = Iterables.getOnlyElement(entries);
            Tuple groupKey = TupleHelpers.subTuple(entry.getKey(), 0, this.getGroupingCount());
            return Map.of(groupKey, entry);
        }
        int groupPrefixSize = this.getGroupingCount();
        int totalSize = this.state.index.getColumnSize();
        LinkedHashMap<Tuple, IndexEntry> entryMap = new LinkedHashMap<Tuple, IndexEntry>();
        for (IndexEntry entry : entries) {
            Tuple groupKey = TupleHelpers.subTuple(entry.getKey(), 0, groupPrefixSize);
            IndexEntry previousForGroup = entryMap.putIfAbsent(groupKey, entry);
            if (previousForGroup == null) continue;
            Tuple entryValue = TupleHelpers.subTuple(entry.getKey(), groupPrefixSize, totalSize);
            Tuple previousValue = TupleHelpers.subTuple(previousForGroup.getKey(), groupPrefixSize, totalSize);
            if (!this.type.shouldUpdateExtremum(previousValue, entryValue)) continue;
            entryMap.put(groupKey, entry);
        }
        return entryMap;
    }

    private CompletableFuture<Tuple> getExtremum(@Nonnull Tuple groupKey) {
        RecordCursor<IndexEntry> scan = this.scan(TupleRange.allOf(groupKey), null, this.type.baseScanProperties.with(props -> props.clearState().setReturnedRowLimit(1)));
        return scan.first().thenApply(first -> first.map(IndexEntry::getKey).orElse(null));
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        return function.getName().equals(this.type.name().toLowerCase(Locale.ROOT)) && IndexFunctionHelper.isGroupPrefix(function.getOperand(), this.state.index.getRootExpression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        if (!this.canEvaluateAggregateFunction(function)) {
            throw new RecordCoreArgumentException("Cannot execute aggregate function", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, function.getName()}).addLogInfo(new Object[]{LogMessageKeys.KEY_EXPRESSION, function.getOperand()}).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, this.state.index.getName()});
        }
        int valueStart = this.getGroupingCount() - this.permutedSize;
        int valueEnd = this.state.index.getColumnSize() - this.permutedSize;
        ScanProperties scanProperties = ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).build().asScanProperties(false);
        TupleRange unpermutedRange = this.trimToUnpermutedPrefix(range);
        RecordCursor<Tuple> cursor = null;
        boolean asyncWork = false;
        try {
            RecordCursor<IndexEntry> entryCursor = this.scan(IndexScanType.BY_GROUP, unpermutedRange, null, scanProperties);
            if (!unpermutedRange.equals(range)) {
                entryCursor = entryCursor.filter(entry -> {
                    Tuple groupPrefix = TupleHelpers.subTuple(entry.getKey(), 0, valueStart);
                    Tuple groupSuffix = TupleHelpers.subTuple(entry.getKey(), valueEnd, entry.getKeySize());
                    Tuple group = groupPrefix.addAll(groupSuffix);
                    return range.contains(group);
                });
            }
            cursor = entryCursor.map(entry -> TupleHelpers.subTuple(entry.getKey(), valueStart, valueEnd));
            CompletableFuture<Tuple> valueFuture = cursor.reduce(null, (accum, value) -> {
                if (accum == null) {
                    return value;
                }
                if (this.type.shouldUpdateExtremum((Tuple)accum, (Tuple)value)) {
                    return value;
                }
                return accum;
            });
            asyncWork = true;
            RecordCursor<Tuple> finalCursor = cursor;
            CompletionStage completionStage = valueFuture.whenComplete((ignore, eignore) -> finalCursor.close());
            return completionStage;
        }
        finally {
            if (cursor != null && !asyncWork) {
                cursor.close();
            }
        }
    }

    @Nonnull
    private TupleRange trimToUnpermutedPrefix(@Nonnull TupleRange range) {
        int unpermutedSize = this.getGroupingCount() - this.permutedSize;
        EndpointType lowEndpoint = range.getLowEndpoint();
        Tuple low = range.getLow();
        if (lowEndpoint != EndpointType.TREE_START && low != null && low.size() > unpermutedSize) {
            low = TupleHelpers.subTuple(low, 0, unpermutedSize);
            lowEndpoint = EndpointType.RANGE_INCLUSIVE;
        }
        EndpointType highEndpoint = range.getHighEndpoint();
        Tuple high = range.getHigh();
        if (highEndpoint != EndpointType.TREE_END && high != null && high.size() > unpermutedSize) {
            high = TupleHelpers.subTuple(high, 0, unpermutedSize);
            highEndpoint = EndpointType.RANGE_INCLUSIVE;
        }
        return new TupleRange(low, high, lowEndpoint, highEndpoint);
    }

    @Override
    public boolean canDeleteWhere(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        if (!super.canDeleteWhere(matcher, evaluated)) {
            return false;
        }
        int unpermutedSize = this.getGroupingCount() - this.permutedSize;
        return evaluated.size() <= unpermutedSize;
    }

    @Override
    public CompletableFuture<Void> deleteWhere(Transaction tr, @Nonnull Tuple prefix) {
        return super.deleteWhere(tr, prefix).thenApply(v -> {
            Subspace permutedSubspace = this.getSecondarySubspace();
            this.state.context.clear(permutedSubspace.subspace(prefix).range());
            return v;
        });
    }

    protected static enum Type {
        MIN(Comparator.naturalOrder(), ScanProperties.FORWARD_SCAN),
        MAX(Comparator.reverseOrder(), ScanProperties.REVERSE_SCAN);

        @Nonnull
        private final Comparator<Tuple> valueComparator;
        @Nonnull
        private final ScanProperties baseScanProperties;

        private Type(Comparator<Tuple> valueComparator, ScanProperties baseScanProperties) {
            this.valueComparator = valueComparator;
            this.baseScanProperties = baseScanProperties;
        }

        public boolean shouldUpdateExtremum(@Nonnull Tuple oldValue, @Nonnull Tuple newValue) {
            return this.valueComparator.compare(oldValue, newValue) > 0;
        }
    }
}

