/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.PermutedMinMaxIndexMaintainer;
import com.apple.foundationdb.record.query.plan.cascades.IndexExpansionInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidateExpansion;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PermutedMinMaxIndexMaintainerFactory
implements IndexMaintainerFactory {
    static final String[] TYPES = new String[]{"permuted_min", "permuted_max"};

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return Arrays.asList(TYPES);
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                this.validateGrouping(1);
                int groupingCount = ((GroupingKeyExpression)this.index.getRootExpression()).getGroupingCount();
                this.validateNotVersion();
                int permutedSize = PermutedMinMaxIndexMaintainer.getPermutedSize(this.index);
                if (permutedSize < 0) {
                    throw new MetaDataException("permuted size cannot be negative", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                }
                if (permutedSize > groupingCount) {
                    throw new MetaDataException("permuted size cannot be larger than grouping size", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                }
            }

            @Override
            public void validateChangedOptions(@Nonnull Index oldIndex, @Nonnull Set<String> changedOptions) {
                if (changedOptions.contains("permutedSize")) {
                    throw new MetaDataException("permuted size changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                }
                super.validateChangedOptions(oldIndex, changedOptions);
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new PermutedMinMaxIndexMaintainer(state);
    }

    @Override
    @Nonnull
    public Iterable<MatchCandidate> createMatchCandidates(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse) {
        IndexExpansionInfo info = IndexExpansionInfo.createInfo(metaData, index, reverse);
        ImmutableList.Builder resultBuilder = ImmutableList.builderWithExpectedSize(2);
        MatchCandidateExpansion.expandValueIndexMatchCandidate(info).ifPresent(resultBuilder::add);
        MatchCandidateExpansion.expandAggregateIndexMatchCandidate(info).ifPresent(resultBuilder::add);
        return resultBuilder.build();
    }
}

