/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.async.RankedSet;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankedSetIndexHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RankIndexMaintainer
extends StandardIndexMaintainer {
    private final RankedSet.Config config;

    public RankIndexMaintainer(IndexMaintainerState state) {
        super(state);
        this.config = RankedSetIndexHelper.getConfig(state.index);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange rankRange, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (scanType.equals(IndexScanType.BY_VALUE)) {
            return this.scan(rankRange, continuation, scanProperties);
        }
        if (!scanType.equals(IndexScanType.BY_RANK)) {
            throw new RecordCoreException("Can only scan rank index by rank or by value.", new Object[0]);
        }
        Subspace extraSubspace = this.getSecondarySubspace();
        CompletableFuture<TupleRange> scoreRangeFuture = RankedSetIndexHelper.rankRangeToScoreRange(this.state, this.getGroupingCount(), extraSubspace, this.config, rankRange);
        return RecordCursor.mapFuture(this.getExecutor(), scoreRangeFuture, continuation, (scoreRange, scoreContinuation) -> {
            if (scoreRange == null) {
                return RecordCursor.empty(this.getExecutor());
            }
            return this.scan((TupleRange)scoreRange, (byte[])scoreContinuation, scanProperties);
        });
    }

    @Override
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        int groupPrefixSize = this.getGroupingCount();
        Subspace extraSubspace = this.getSecondarySubspace();
        ArrayList<CompletableFuture<Void>> ordinaryIndexFutures = new ArrayList<CompletableFuture<Void>>(indexEntries.size());
        HashMap<Subspace, CompletionStage> rankFutures = Maps.newHashMapWithExpectedSize(indexEntries.size());
        for (IndexEntry indexEntry : indexEntries) {
            Tuple scoreKey;
            Subspace rankSubspace;
            CompletableFuture<Void> updateOrdinaryIndex = this.updateOneKeyAsync(savedRecord, remove, indexEntry);
            if (!MoreAsyncUtil.isCompletedNormally(updateOrdinaryIndex)) {
                ordinaryIndexFutures.add(updateOrdinaryIndex);
            }
            if (groupPrefixSize > 0) {
                List<Object> keyValues = indexEntry.getKey().getItems();
                rankSubspace = extraSubspace.subspace(Tuple.fromList(keyValues.subList(0, groupPrefixSize)));
                scoreKey = Tuple.fromList(keyValues.subList(groupPrefixSize, keyValues.size()));
            } else {
                rankSubspace = extraSubspace;
                scoreKey = indexEntry.getKey();
            }
            Function<Void, CompletableFuture> futureSupplier = vignore -> RankedSetIndexHelper.updateRankedSet(this.state, rankSubspace, this.config, indexEntry.getKey(), scoreKey, remove);
            CompletableFuture existingFuture = (CompletableFuture)rankFutures.get(rankSubspace);
            if (existingFuture == null) {
                rankFutures.put(rankSubspace, futureSupplier.apply(null));
                continue;
            }
            rankFutures.put(rankSubspace, existingFuture.thenCompose(futureSupplier));
        }
        return CompletableFuture.allOf(AsyncUtil.whenAll(ordinaryIndexFutures), AsyncUtil.whenAll(rankFutures.values()));
    }

    @Override
    public boolean isIdempotent() {
        return !this.config.isCountDuplicates();
    }

    @Override
    public boolean canEvaluateRecordFunction(@Nonnull IndexRecordFunction<?> function) {
        return "rank".equals(function.getName()) && this.state.index.getRootExpression().equals(function.getOperand());
    }

    @Override
    @Nonnull
    public <T, M extends Message> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext context, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<M> record) {
        if ("rank".equals(function.getName())) {
            return this.rank(context, function, record);
        }
        return this.unsupportedRecordFunction(function);
    }

    public <M extends Message> CompletableFuture<Long> rank(@Nonnull FDBRecord<M> record) {
        return this.rank(EvaluationContext.empty(), null, record);
    }

    protected <M extends Message> CompletableFuture<Long> rank(@Nonnull EvaluationContext context, @Nullable IndexRecordFunction<Long> function, @Nonnull FDBRecord<M> record) {
        int groupPrefixSize = this.getGroupingCount();
        Key.Evaluated indexKey = IndexFunctionHelper.recordFunctionIndexEntry(this.state.store, this.state.index, context, function, record, groupPrefixSize);
        if (indexKey == null) {
            return CompletableFuture.completedFuture(null);
        }
        Tuple scoreValue = indexKey.toTuple();
        Subspace rankSubspace = this.getSecondarySubspace();
        if (groupPrefixSize > 0) {
            Tuple prefix = Tuple.fromList(scoreValue.getItems().subList(0, groupPrefixSize));
            rankSubspace = rankSubspace.subspace(prefix);
            scoreValue = Tuple.fromList(scoreValue.getItems().subList(groupPrefixSize, scoreValue.size()));
        }
        RankedSetIndexHelper.InstrumentedRankedSet rankedSet = new RankedSetIndexHelper.InstrumentedRankedSet(this.state, rankSubspace, this.config);
        return RankedSetIndexHelper.rankForScore(this.state, rankedSet, scoreValue, true);
    }

    @Override
    public CompletableFuture<Void> deleteWhere(Transaction tr, @Nonnull Tuple prefix) {
        return super.deleteWhere(tr, prefix).thenApply(v -> {
            Subspace rankSubspace = this.getSecondarySubspace();
            byte[] key = rankSubspace.pack(prefix);
            this.state.context.clear(new Range(key, ByteArrayUtil.strinc(key)));
            return v;
        });
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        if ("count_distinct".equals(function.getName()) && function.getOperand().equals(this.state.index.getRootExpression())) {
            return true;
        }
        if ("count".equals(function.getName()) && this.state.index.isUnique() && function.getOperand().getColumnSize() == this.getGroupingCount() && function.getOperand().isPrefixKey(this.state.index.getRootExpression())) {
            return true;
        }
        if (("score_for_rank".equals(function.getName()) || "score_for_rank_else_skip".equals(function.getName()) || "rank_for_score".equals(function.getName())) && function.getOperand().equals(this.state.index.getRootExpression())) {
            return true;
        }
        return super.canEvaluateAggregateFunction(function);
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        if (("count".equals(function.getName()) || "count_distinct".equals(function.getName())) && range.isEquals()) {
            return this.evaluateEqualRange(range, (rankedSet, values) -> rankedSet.size(this.state.context.readTransaction(isolationLevel.isSnapshot())).thenApply(xva$0 -> Tuple.from(xva$0)));
        }
        if (("score_for_rank".equals(function.getName()) || "score_for_rank_else_skip".equals(function.getName())) && range.isEquals()) {
            Tuple outOfRange = "score_for_rank_else_skip".equals(function.getName()) ? RankedSetIndexHelper.COMPARISON_SKIPPED_SCORE : null;
            return this.evaluateEqualRange(range, (rankedSet, values) -> RankedSetIndexHelper.scoreForRank(this.state, rankedSet, (Number)values.get(0), outOfRange));
        }
        if ("rank_for_score".equals(function.getName()) && range.isEquals()) {
            return this.evaluateEqualRange(range, (rankedSet, values) -> RankedSetIndexHelper.rankForScore(this.state, rankedSet, values, false).thenApply(xva$0 -> Tuple.from(xva$0)));
        }
        return this.unsupportedAggregateFunction(function);
    }

    private CompletableFuture<Tuple> evaluateEqualRange(@Nonnull TupleRange range, @Nonnull EvaluateEqualRange function) {
        Subspace rankSubspace = this.getSecondarySubspace();
        Tuple values = range.getLow();
        int groupingCount = this.getGroupingCount();
        if (groupingCount > 0) {
            rankSubspace = rankSubspace.subspace(TupleHelpers.subTuple(values, 0, groupingCount));
            values = TupleHelpers.subTuple(values, groupingCount, values.size());
        }
        RankedSetIndexHelper.InstrumentedRankedSet rankedSet = new RankedSetIndexHelper.InstrumentedRankedSet(this.state, rankSubspace, this.config);
        return function.apply(rankedSet, values);
    }

    private static interface EvaluateEqualRange {
        @Nonnull
        public CompletableFuture<Tuple> apply(@Nonnull RankedSet var1, @Nonnull Tuple var2);
    }
}

