/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.RankedSet;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankedSetIndexHelper;
import com.apple.foundationdb.record.query.plan.cascades.IndexExpansionInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidateExpansion;
import com.apple.foundationdb.record.query.plan.cascades.WindowedIndexExpansionVisitor;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class RankIndexMaintainerFactory
implements IndexMaintainerFactory {
    static final String[] TYPES = new String[]{"rank"};

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return Arrays.asList(TYPES);
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                this.validateGrouping(1);
                this.validateNotVersion();
            }

            @Override
            public void validateChangedOptions(@Nonnull Index oldIndex, @Nonnull Set<String> changedOptions) {
                if (!changedOptions.isEmpty()) {
                    RankedSet.Config oldOptions = RankedSetIndexHelper.getConfig(oldIndex);
                    RankedSet.Config newOptions = RankedSetIndexHelper.getConfig(this.index);
                    if (changedOptions.contains("rankNLevels")) {
                        if (oldOptions.getNLevels() != newOptions.getNLevels()) {
                            throw new MetaDataException("rank levels changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rankNLevels");
                    }
                    if (changedOptions.contains("rankHashFunction")) {
                        if (!oldOptions.getHashFunction().equals(newOptions.getHashFunction())) {
                            throw new MetaDataException("rank hash function changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rankHashFunction");
                    }
                    if (changedOptions.contains("rankCountDuplicates")) {
                        if (oldOptions.isCountDuplicates() != newOptions.isCountDuplicates()) {
                            throw new MetaDataException("rank count duplicate changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        changedOptions.remove("rankCountDuplicates");
                    }
                }
                super.validateChangedOptions(oldIndex, changedOptions);
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new RankIndexMaintainer(state);
    }

    @Override
    @Nonnull
    public Iterable<MatchCandidate> createMatchCandidates(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse) {
        IndexExpansionInfo info = IndexExpansionInfo.createInfo(metaData, index, reverse);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        MatchCandidateExpansion.expandValueIndexMatchCandidate(info).ifPresent(resultBuilder::add);
        MatchCandidateExpansion.expandIndexMatchCandidate(info, info.getCommonPrimaryKeyForTypes(), new WindowedIndexExpansionVisitor(index, info.getIndexedRecordTypes())).ifPresent(resultBuilder::add);
        return resultBuilder.build();
    }
}

