/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.RankedSet;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RankedSetHashFunctions {
    public static final String JDK = "JDK";
    public static final String CRC = "CRC";
    public static final String RANDOM = "RANDOM";
    public static final String MURMUR3 = "MURMUR3";
    private static final RankedSet.HashFunction MURMUR3_HASH_FUNCTION = new GuavaHashFunction(Hashing.murmur3_32_fixed());
    private static final BiMap<String, RankedSet.HashFunction> extent = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("JDK", RankedSet.JDK_ARRAY_HASH)).put("CRC", RankedSet.CRC_HASH)).put("RANDOM", RankedSet.RANDOM_HASH)).put("MURMUR3", MURMUR3_HASH_FUNCTION)).build();

    public static RankedSet.HashFunction getHashFunction(@Nonnull String name) {
        RankedSet.HashFunction result = (RankedSet.HashFunction)extent.get(name);
        if (result != null) {
            return result;
        }
        throw new RecordCoreArgumentException("hash function not found: " + name, new Object[0]);
    }

    public static String getHashFunctionName(@Nonnull RankedSet.HashFunction hashFunction) {
        return (String)extent.inverse().get(hashFunction);
    }

    private RankedSetHashFunctions() {
    }

    private static class GuavaHashFunction
    implements RankedSet.HashFunction {
        @Nonnull
        private final HashFunction guava;

        public GuavaHashFunction(HashFunction guava) {
            this.guava = guava;
        }

        @Override
        public int hash(byte[] key) {
            return this.guava.hashBytes(key).asInt();
        }
    }
}

