/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.RankedSet;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionContext;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.RankedSetHashFunctions;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class RankedSetIndexHelper {
    public static final Tuple COMPARISON_SKIPPED_SCORE = Tuple.from(Comparisons.COMPARISON_SKIPPED_BINDING);

    public static RankedSet.Config getConfig(@Nonnull Index index) {
        String duplicatesOption;
        String nlevelsOption;
        RankedSet.ConfigBuilder builder = RankedSet.newConfigBuilder();
        String hashFunctionOption = index.getOption("rankHashFunction");
        if (hashFunctionOption != null) {
            builder.setHashFunction(RankedSetHashFunctions.getHashFunction(hashFunctionOption));
        }
        if ((nlevelsOption = index.getOption("rankNLevels")) != null) {
            builder.setNLevels(Integer.parseInt(nlevelsOption));
        }
        if ((duplicatesOption = index.getOption("rankCountDuplicates")) != null) {
            builder.setCountDuplicates(Boolean.parseBoolean(duplicatesOption));
        }
        return builder.build();
    }

    private RankedSetIndexHelper() {
    }

    @Nonnull
    public static CompletableFuture<TupleRange> rankRangeToScoreRange(@Nonnull IndexMaintainerState state, int groupPrefixSize, @Nonnull Subspace rankSubspace, @Nonnull RankedSet.Config config, @Nonnull TupleRange rankRange) {
        Number lowRankNum;
        Tuple prefix = RankedSetIndexHelper.groupPrefix(groupPrefixSize, rankRange, rankSubspace);
        if (prefix != null) {
            rankSubspace = rankSubspace.subspace(prefix);
        }
        boolean startFromBeginning = (lowRankNum = RankedSetIndexHelper.extractRank(groupPrefixSize, rankRange.getLow())) == null || lowRankNum.longValue() < 0L;
        EndpointType lowEndpoint = startFromBeginning ? EndpointType.RANGE_INCLUSIVE : rankRange.getLowEndpoint();
        Number highRankNum = RankedSetIndexHelper.extractRank(groupPrefixSize, rankRange.getHigh());
        EndpointType highEndpoint = rankRange.getHighEndpoint();
        if (highRankNum != null && (highRankNum.longValue() < 0L || highEndpoint == EndpointType.RANGE_EXCLUSIVE && highRankNum.longValue() == 0L)) {
            return CompletableFuture.completedFuture(null);
        }
        if (highRankNum != null && highEndpoint == EndpointType.RANGE_EXCLUSIVE && lowEndpoint == EndpointType.RANGE_EXCLUSIVE && highRankNum.equals(lowRankNum)) {
            return CompletableFuture.completedFuture(null);
        }
        if (startFromBeginning && highRankNum == null) {
            return CompletableFuture.completedFuture(TupleRange.allOf(prefix));
        }
        InstrumentedRankedSet rankedSet = new InstrumentedRankedSet(state, rankSubspace, config);
        return RankedSetIndexHelper.init(state, rankedSet).thenCompose(v -> {
            CompletableFuture<Tuple> lowScoreFuture = RankedSetIndexHelper.scoreForRank(state, rankedSet, startFromBeginning ? (Number)0L : (Number)lowRankNum, null);
            CompletableFuture<Tuple> highScoreFuture = RankedSetIndexHelper.scoreForRank(state, rankedSet, highRankNum, null);
            return lowScoreFuture.thenCombine(highScoreFuture, (lowScore, highScore) -> {
                if (lowScore == null) {
                    return null;
                }
                EndpointType adjustedHighEndpoint = highScore != null ? highEndpoint : (prefix != null ? EndpointType.RANGE_INCLUSIVE : EndpointType.TREE_END);
                TupleRange scoreRange = new TupleRange((Tuple)lowScore, (Tuple)highScore, lowEndpoint, adjustedHighEndpoint);
                if (prefix != null) {
                    scoreRange = scoreRange.prepend(prefix);
                }
                return scoreRange;
            });
        });
    }

    @Nonnull
    private static CompletableFuture<Void> init(@Nonnull IndexMaintainerState state, @Nonnull RankedSet rankedSet) {
        return rankedSet.initNeeded(state.context.readTransaction(true)).thenCompose(needed -> needed != false ? rankedSet.init(state.transaction) : AsyncUtil.DONE);
    }

    @Nullable
    private static Tuple groupPrefix(int groupPrefixSize, @Nonnull TupleRange rankRange, @Nonnull Subspace rankSubspace) {
        if (groupPrefixSize > 0) {
            Tuple highPrefix;
            Tuple lowRank = rankRange.getLow();
            Tuple highRank = rankRange.getHigh();
            if (lowRank == null || lowRank.size() < groupPrefixSize || highRank == null || highRank.size() < groupPrefixSize) {
                throw new RecordCoreException("Ranked scan range does not include group", "rankRange", rankRange, "rankSubspace", ByteArrayUtil2.loggable(rankSubspace.getKey()));
            }
            Tuple prefix = Tuple.fromList(lowRank.getItems().subList(0, groupPrefixSize));
            if (!prefix.equals(highPrefix = Tuple.fromList(highRank.getItems().subList(0, groupPrefixSize)))) {
                throw new RecordCoreException("Ranked scan range crosses groups", "rankRange", rankRange, "rankSubspace", ByteArrayUtil2.loggable(rankSubspace.getKey()));
            }
            return prefix;
        }
        return null;
    }

    @Nullable
    private static Number extractRank(int groupPrefixSize, @Nullable Tuple maybeRank) {
        if (maybeRank == null) {
            return null;
        }
        if (maybeRank.size() == groupPrefixSize + 1) {
            return (Number)maybeRank.get(groupPrefixSize);
        }
        if (maybeRank.size() == groupPrefixSize) {
            return null;
        }
        throw new RecordCoreException("Ranked set range bound is not correct size", "groupPrefixSize", groupPrefixSize, "maybeRank", maybeRank);
    }

    public static CompletableFuture<Tuple> scoreForRank(@Nonnull IndexMaintainerState state, @Nonnull RankedSet rankedSet, @Nullable Number rank, @Nullable Tuple outOfRange) {
        if (rank == null) {
            return CompletableFuture.completedFuture(null);
        }
        rankedSet.preloadForLookup(state.context.readTransaction(true));
        CompletableFuture result = rankedSet.getNth(state.transaction, rank.longValue()).thenApply(scoreBytes -> scoreBytes == null ? outOfRange : Tuple.fromBytes(scoreBytes));
        if (state.store.getTimer() != null) {
            result = state.store.instrument(Events.RANKED_SET_SCORE_FOR_RANK, result);
        }
        return result;
    }

    public static CompletableFuture<Long> rankForScore(@Nonnull IndexMaintainerState state, @Nonnull RankedSet rankedSet, @Nullable Tuple score, boolean nullIfMissing) {
        if (score == null) {
            return CompletableFuture.completedFuture(null);
        }
        rankedSet.preloadForLookup(state.context.readTransaction(true));
        CompletableFuture<Long> result = rankedSet.rank(state.transaction, score.pack(), nullIfMissing);
        return state.store.instrument(Events.RANKED_SET_RANK_FOR_SCORE, result);
    }

    @Nonnull
    public static CompletableFuture<Void> updateRankedSet(@Nonnull IndexMaintainerState state, @Nonnull Subspace rankSubspace, @Nonnull RankedSet.Config config, @Nonnull Tuple valueKey, @Nonnull Tuple scoreKey, boolean remove) {
        InstrumentedRankedSet rankedSet = new InstrumentedRankedSet(state, rankSubspace, config);
        byte[] score = scoreKey.pack();
        CompletionStage result = RankedSetIndexHelper.init(state, rankedSet).thenCompose(v -> {
            if (remove) {
                if (config.isCountDuplicates()) {
                    return RankedSetIndexHelper.removeFromRankedSet(state, rankedSet, score);
                }
                return state.transaction.getRange(state.indexSubspace.range(valueKey)).iterator().onHasNext().thenCompose(hasNext -> hasNext != false ? AsyncUtil.DONE : RankedSetIndexHelper.removeFromRankedSet(state, rankedSet, score));
            }
            return rankedSet.add(state.transaction, score).thenApply(added -> null);
        });
        return state.store.instrument(Events.RANKED_SET_UPDATE, result);
    }

    private static CompletableFuture<Void> removeFromRankedSet(@Nonnull IndexMaintainerState state, @Nonnull RankedSet rankedSet, @Nonnull byte[] score) {
        return rankedSet.remove(state.transaction, score).thenApply(exists -> {
            if (!exists.booleanValue() && !state.store.isIndexWriteOnly(state.index)) {
                throw new RecordCoreException("Score was not present in ranked set.", "rankSubspace", ByteArrayUtil2.loggable(rankedSet.getSubspace().getKey()));
            }
            return null;
        });
    }

    public static class InstrumentedRankedSet
    extends RankedSet {
        private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentedRankedSet.class);
        private final FDBTransactionContext context;

        public InstrumentedRankedSet(@Nonnull IndexMaintainerState state, @Nonnull Subspace rankSubspace, @Nonnull RankedSet.Config config) {
            super(rankSubspace, state.context.getExecutor(), config);
            this.context = state.context;
        }

        @Override
        public CompletableFuture<Void> init(TransactionContext tc) {
            CompletableFuture<Void> result = super.init(tc);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_INIT, result);
        }

        @Override
        public CompletableFuture<Boolean> contains(ReadTransactionContext tc, byte[] key) {
            CompletableFuture<Boolean> result = super.contains(tc, key);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_CONTAINS, result);
        }

        @Override
        protected CompletableFuture<Boolean> nextLookup(RankedSet.Lookup lookup, ReadTransaction tr) {
            CompletableFuture<Boolean> result = super.nextLookup(lookup, tr);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_NEXT_LOOKUP, result);
        }

        @Override
        protected void nextLookupKey(long duration, boolean newIter, boolean hasNext, int level, boolean rankLookup) {
            if (this.context.getTimer() != null) {
                FDBStoreTimer.DetailEvents event = FDBStoreTimer.DetailEvents.RANKED_SET_NEXT_LOOKUP_KEY;
                this.context.getTimer().record(event, duration);
            }
        }

        @Override
        protected int getKeyHash(byte[] key) {
            int hash = super.getKeyHash(key);
            if (LOGGER.isTraceEnabled()) {
                String hashString = Integer.toHexString(hash);
                LOGGER.trace(KeyValueLogMessage.of("Ranked set key hash", new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.subspace.getKey()), LogMessageKeys.KEY, ByteArrayUtil2.loggable(key), LogMessageKeys.HASH_FUNCTION, RankedSetHashFunctions.getHashFunctionName(this.config.getHashFunction()), LogMessageKeys.HASH, "0".repeat(8 - hashString.length()) + hashString}));
            }
            return hash;
        }

        @Override
        protected CompletableFuture<Void> addLevelZeroKey(Transaction tr, byte[] key, int level, boolean increment) {
            CompletableFuture<Void> result = super.addLevelZeroKey(tr, key, level, increment);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_ADD_LEVEL_ZERO_KEY, result);
        }

        @Override
        protected CompletableFuture<Void> addIncrementLevelKey(Transaction tr, byte[] key, int level, boolean orEqual) {
            CompletableFuture<Void> result = super.addIncrementLevelKey(tr, key, level, orEqual);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_ADD_INCREMENT_LEVEL_KEY, result);
        }

        @Override
        protected CompletableFuture<Void> addInsertLevelKey(Transaction tr, byte[] key, int level) {
            CompletableFuture<Void> result = super.addInsertLevelKey(tr, key, level);
            return this.context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.RANKED_SET_ADD_INSERT_LEVEL_KEY, result);
        }
    }

    public static enum Events implements StoreTimer.DetailEvent
    {
        RANKED_SET_SCORE_FOR_RANK("ranked set score for rank"),
        RANKED_SET_RANK_FOR_SCORE("ranked set rank for score"),
        RANKED_SET_UPDATE("ranked set update");

        private final String title;
        private final String logKey;

        private Events(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.DetailEvent.super.logKey();
        }

        private Events(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }
}

