/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordIndexUniquenessViolation;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexPredicate;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.record.provider.foundationdb.IndexPrefetchRangeKeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.InvalidIndexEntry;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Verify;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public abstract class StandardIndexMaintainer
extends IndexMaintainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardIndexMaintainer.class);
    protected static final int TOO_LARGE_VALUE_MESSAGE_LIMIT = 100;

    protected StandardIndexMaintainer(IndexMaintainerState state) {
        super(state);
    }

    @Nullable
    protected FDBStoreTimer getTimer() {
        return this.state.context.getTimer();
    }

    @Nonnull
    protected Executor getExecutor() {
        return this.state.context.getExecutor();
    }

    protected RecordCursor<IndexEntry> scan(@Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        KeyValueCursor keyValues = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(this.state.indexSubspace).setContext(this.state.context)).setRange(range)).setContinuation(continuation)).setScanProperties(scanProperties)).build();
        return keyValues.map(kv -> {
            this.state.store.countKeyValue(FDBStoreTimer.Counts.LOAD_INDEX_KEY, FDBStoreTimer.Counts.LOAD_INDEX_KEY_BYTES, FDBStoreTimer.Counts.LOAD_INDEX_VALUE_BYTES, (KeyValue)kv);
            return this.unpackKeyValue((KeyValue)kv);
        });
    }

    @Nonnull
    protected RecordCursor<FDBIndexedRawRecord> scanRemoteFetchByValue(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, int commonPrimaryKeyLength) {
        if (commonPrimaryKeyLength <= 0) {
            throw new RecordCoreArgumentException("scanRemoteFetch requires a positive commonPrimaryKeyLength", new Object[0]);
        }
        if (!scanBounds.getScanType().equals(IndexScanType.BY_VALUE) || !(scanBounds instanceof IndexScanRange)) {
            throw new RecordCoreArgumentException("scanRemoteFetch can only be used with VALUE index scan type and Range Scan", new Object[0]);
        }
        IndexScanRange scanRange = (IndexScanRange)scanBounds;
        Tuple mapper = this.createRemoteFetchMapper(commonPrimaryKeyLength);
        IndexPrefetchRangeKeyValueCursor keyValues = ((IndexPrefetchRangeKeyValueCursor.Builder)((IndexPrefetchRangeKeyValueCursor.Builder)((IndexPrefetchRangeKeyValueCursor.Builder)((IndexPrefetchRangeKeyValueCursor.Builder)IndexPrefetchRangeKeyValueCursor.Builder.newBuilder(this.state.indexSubspace, mapper.pack()).setContext(this.state.context)).setRange(scanRange.getScanRange())).setContinuation(continuation)).setScanProperties(scanProperties)).build();
        return keyValues.map(this::unpackRemoteFetchRecord);
    }

    @Nonnull
    protected IndexEntry unpackKeyValue(@Nonnull KeyValue kv) {
        return this.unpackKeyValue(this.state.indexSubspace, kv);
    }

    @Nonnull
    protected IndexEntry unpackKeyValue(@Nonnull Subspace subspace, @Nonnull KeyValue kv) {
        return new IndexEntry(this.state.index, SplitHelper.unpackKey(subspace, kv), this.decodeValue(kv.getValue()));
    }

    @Nonnull
    protected FDBIndexedRawRecord unpackRemoteFetchRecord(@Nonnull MappedKeyValue indexKeyValue) {
        IndexEntry indexEntry = new IndexEntry(this.state.index, SplitHelper.unpackKey(this.state.indexSubspace, indexKeyValue), this.decodeValue(indexKeyValue.getValue()));
        return new FDBIndexedRawRecord(indexEntry, indexKeyValue);
    }

    @Nonnull
    protected Tuple decodeValue(@Nonnull byte[] value) {
        return value.length == 0 ? TupleHelpers.EMPTY : Tuple.fromBytes(value);
    }

    public boolean skipUpdateForUnchangedKeys() {
        return true;
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Void> update(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        List<IndexEntry> commonKeys;
        List<IndexEntry> oldIndexEntries = this.filteredIndexEntries(oldRecord);
        List<IndexEntry> newIndexEntries = this.filteredIndexEntries(newRecord);
        if (oldIndexEntries != null && newIndexEntries != null && this.skipUpdateForUnchangedKeys() && !(commonKeys = this.commonKeys(oldIndexEntries, newIndexEntries)).isEmpty()) {
            oldIndexEntries = StandardIndexMaintainer.makeMutable(oldIndexEntries);
            oldIndexEntries.removeAll(commonKeys);
            newIndexEntries = StandardIndexMaintainer.makeMutable(newIndexEntries);
            newIndexEntries.removeAll(commonKeys);
        }
        CompletionStage<Void> future = AsyncUtil.DONE;
        if (oldIndexEntries != null && !oldIndexEntries.isEmpty()) {
            Function<Void, CompletableFuture<Void>> oldUpdate = this.updateIndexKeysFunction(oldRecord, true, oldIndexEntries);
            future = MoreAsyncUtil.isCompletedNormally(future) ? oldUpdate.apply(null) : future.thenCompose(oldUpdate);
        }
        if (newIndexEntries != null && !newIndexEntries.isEmpty()) {
            Function<Void, CompletableFuture<Void>> newUpdate = this.updateIndexKeysFunction(newRecord, false, newIndexEntries);
            future = MoreAsyncUtil.isCompletedNormally(future) ? newUpdate.apply(null) : future.thenCompose(newUpdate);
        }
        return future;
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Void> updateWhileWriteOnly(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        if (this.isIdempotent()) {
            return this.update(oldRecord, newRecord);
        }
        return this.state.store.loadIndexingTypeStampAsync(this.state.index).thenCompose(stamp -> {
            if (stamp == null) {
                return this.updateWriteOnlyByRecords(oldRecord, newRecord);
            }
            switch (stamp.getMethod()) {
                case BY_RECORDS: 
                case MULTI_TARGET_BY_RECORDS: 
                case MUTUAL_BY_RECORDS: {
                    return this.updateWriteOnlyByRecords(oldRecord, newRecord);
                }
                case BY_INDEX: {
                    Object sourceIndexKey = Tuple.fromBytes(stamp.getSourceIndexSubspaceKey().toByteArray()).get(0);
                    Index sourceIndex = this.state.store.getRecordMetaData().getIndexFromSubspaceKey(sourceIndexKey);
                    return this.updateWriteOnlyByIndex(sourceIndex, oldRecord, newRecord);
                }
            }
            throw new RecordCoreException("unable to update write-only index with current type stamp", new Object[0]).addLogInfo("stamp", stamp);
        });
    }

    private <M extends Message> CompletableFuture<Void> updateWriteOnlyByRecords(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        Tuple primaryKey = oldRecord == null ? Verify.verifyNotNull(newRecord).getPrimaryKey() : oldRecord.getPrimaryKey();
        return this.addedRangeWithKey(primaryKey).thenCompose(inRange -> inRange != false ? this.update(oldRecord, newRecord) : AsyncUtil.DONE);
    }

    private <M extends Message> CompletableFuture<Void> updateWriteOnlyByIndex(@Nonnull Index sourceIndex, @Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        Tuple entryKey;
        IndexMaintainer sourceIndexMaintainer = this.state.store.getIndexMaintainer(sourceIndex);
        Tuple oldEntryKey = StandardIndexMaintainer.evaluateSingletonIndexKey(sourceIndex, sourceIndexMaintainer, oldRecord);
        Tuple newEntryKey = StandardIndexMaintainer.evaluateSingletonIndexKey(sourceIndex, sourceIndexMaintainer, newRecord);
        if (oldEntryKey != null && newEntryKey != null) {
            if (oldEntryKey.equals(newEntryKey)) {
                return this.addedRangeWithKey(oldEntryKey).thenCompose(inRange -> inRange != false ? this.update(oldRecord, newRecord) : AsyncUtil.DONE);
            }
            CompletableFuture<Boolean> oldInRangeFuture = this.addedRangeWithKey(oldEntryKey);
            CompletableFuture<Boolean> newInRangeFuture = this.addedRangeWithKey(newEntryKey);
            return ((CompletableFuture)((CompletableFuture)oldInRangeFuture.thenCompose(oldInRange -> oldInRange != false ? this.update(oldRecord, null) : AsyncUtil.DONE)).thenCompose(ignore -> newInRangeFuture)).thenCompose(newInRange -> newInRange != false ? this.update(null, newRecord) : AsyncUtil.DONE);
        }
        Tuple tuple = entryKey = oldEntryKey == null ? newEntryKey : oldEntryKey;
        if (entryKey == null) {
            return AsyncUtil.DONE;
        }
        return this.addedRangeWithKey(entryKey).thenCompose(inRange -> inRange != false ? this.update(oldRecord, newRecord) : AsyncUtil.DONE);
    }

    @Nullable
    private static <M extends Message> Tuple evaluateSingletonIndexKey(Index index, IndexMaintainer maintainer, @Nullable FDBIndexableRecord<M> record) {
        if (record == null) {
            return null;
        }
        List<IndexEntry> entries = maintainer.filteredIndexEntries(record);
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        if (entries.size() != 1) {
            throw new RecordCoreException("index produced incorrect number of entries for use as source index", new Object[0]);
        }
        IndexEntry entry = entries.get(0);
        return FDBRecordStoreBase.indexEntryKey(index, entry.getKey(), record.getPrimaryKey());
    }

    @Override
    @Nullable
    public <M extends Message> List<IndexEntry> filteredIndexEntries(@Nullable FDBIndexableRecord<M> savedRecord) {
        if (savedRecord == null) {
            return null;
        }
        FDBStoreTimer timer = this.state.store.getTimer();
        IndexPredicate predicate = this.state.index.getPredicate();
        if (predicate != null) {
            long startTime = System.nanoTime();
            boolean useMe = predicate.shouldIndexThisRecord(this.state.store, savedRecord);
            if (timer != null) {
                FDBStoreTimer.Events event = useMe ? FDBStoreTimer.Events.USE_INDEX_RECORD_BY_PREDICATE : FDBStoreTimer.Events.SKIP_INDEX_RECORD_BY_PREDICATE;
                timer.recordSinceNanoTime(event, startTime);
            }
            if (!useMe) {
                return null;
            }
        }
        Object record = savedRecord.getRecord();
        long startTime = System.nanoTime();
        boolean filterIndexKeys = false;
        switch (this.state.filter.maintainIndex(this.state.index, (MessageOrBuilder)record)) {
            case NONE: {
                if (timer != null) {
                    timer.recordSinceNanoTime(FDBStoreTimer.Events.SKIP_INDEX_RECORD, startTime);
                }
                return null;
            }
            case SOME: {
                filterIndexKeys = true;
                break;
            }
        }
        List<IndexEntry> indexEntries = this.evaluateIndex(savedRecord);
        if (!filterIndexKeys) {
            return indexEntries;
        }
        int i = 0;
        while (i < indexEntries.size()) {
            if (this.state.filter.maintainIndexValue(this.state.index, (MessageOrBuilder)record, indexEntries.get(i))) {
                ++i;
                continue;
            }
            indexEntries = StandardIndexMaintainer.makeMutable(indexEntries);
            indexEntries.remove(i);
            long endTime = System.nanoTime();
            if (this.state.store.getTimer() != null) {
                this.state.store.getTimer().record(FDBStoreTimer.Events.SKIP_INDEX_ENTRY, endTime - startTime);
            }
            startTime = endTime;
        }
        return indexEntries;
    }

    @Nonnull
    protected List<IndexEntry> commonKeys(@Nonnull List<IndexEntry> oldIndexEntries, @Nonnull List<IndexEntry> newIndexEntries) {
        ArrayList<IndexEntry> commonKeys = new ArrayList<IndexEntry>();
        for (IndexEntry oldEntry : oldIndexEntries) {
            if (!newIndexEntries.contains(oldEntry)) continue;
            commonKeys.add(oldEntry);
        }
        return commonKeys;
    }

    @Nonnull
    protected static <T> List<T> makeMutable(@Nonnull List<T> list) {
        if (list instanceof ArrayList) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    @Nonnull
    protected <M extends Message> Function<Void, CompletableFuture<Void>> updateIndexKeysFunction(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        return vignore -> this.updateIndexKeys(savedRecord, remove, indexEntries);
    }

    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        return CompletableFuture.allOf((CompletableFuture[])indexEntries.stream().map(entry -> this.updateOneKeyAsync(savedRecord, remove, (IndexEntry)entry)).toArray(CompletableFuture[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <M extends Message> CompletableFuture<Void> updateOneKeyAsync(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull IndexEntry indexEntry) {
        Tuple valueKey = indexEntry.getKey();
        Tuple value = indexEntry.getValue();
        long startTime = System.nanoTime();
        Tuple entryKey = this.indexEntryKey(valueKey, savedRecord.getPrimaryKey());
        byte[] keyBytes = this.state.indexSubspace.pack(entryKey);
        byte[] valueBytes = value.pack();
        if (remove) {
            this.state.transaction.clear(keyBytes);
            if (this.state.store.getTimer() != null) {
                this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.DELETE_INDEX_ENTRY, startTime);
                this.state.store.countKeyValue(FDBStoreTimer.Counts.DELETE_INDEX_KEY, FDBStoreTimer.Counts.DELETE_INDEX_KEY_BYTES, FDBStoreTimer.Counts.DELETE_INDEX_VALUE_BYTES, keyBytes, valueBytes);
            }
            if (this.isWriteOnlyOrUniquePending() && this.state.index.isUnique()) {
                return this.removeUniquenessViolationsAsync(valueKey, savedRecord.getPrimaryKey());
            }
            return AsyncUtil.DONE;
        }
        this.checkKeyValueSizes(savedRecord, valueKey, value, keyBytes, valueBytes);
        if (this.state.index.isUnique()) {
            FDBRecordContext fDBRecordContext = this.state.context;
            synchronized (fDBRecordContext) {
                if (!indexEntry.keyContainsNonUniqueNull()) {
                    this.checkUniqueness(savedRecord, indexEntry);
                }
                this.state.transaction.set(keyBytes, valueBytes);
            }
        } else {
            this.state.transaction.set(keyBytes, valueBytes);
        }
        if (this.state.store.getTimer() != null) {
            this.state.store.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.SAVE_INDEX_ENTRY, startTime);
            this.state.store.countKeyValue(FDBStoreTimer.Counts.SAVE_INDEX_KEY, FDBStoreTimer.Counts.SAVE_INDEX_KEY_BYTES, FDBStoreTimer.Counts.SAVE_INDEX_VALUE_BYTES, keyBytes, valueBytes);
        }
        return AsyncUtil.DONE;
    }

    protected <M extends Message> void checkUniqueness(@Nonnull FDBIndexableRecord<M> savedRecord, @Nonnull IndexEntry indexEntry) {
        Tuple valueKey = indexEntry.getKey();
        AsyncIterable<KeyValue> kvs = this.state.transaction.getRange(this.state.indexSubspace.range(valueKey));
        Tuple primaryKey = savedRecord.getPrimaryKey();
        CompletableFuture<Void> checker = this.state.store.getContext().instrument((StoreTimer.Event)FDBStoreTimer.Events.CHECK_INDEX_UNIQUENESS, AsyncUtil.forEach(kvs, kv -> {
            Tuple existingEntry = SplitHelper.unpackKey(this.getIndexSubspace(), kv);
            Tuple existingKey = this.state.index.getEntryPrimaryKey(existingEntry);
            if (!TupleHelpers.equals(primaryKey, existingKey)) {
                if (this.state.store.isIndexWriteOnly(this.state.index)) {
                    this.addUniquenessViolation(valueKey, primaryKey, existingKey);
                    this.addUniquenessViolation(valueKey, existingKey, primaryKey);
                } else {
                    throw new RecordIndexUniquenessViolation(this.state.index, indexEntry, primaryKey, existingKey);
                }
            }
        }, this.getExecutor()));
        this.state.store.addIndexUniquenessCommitCheck(this.state.index, this.state.indexSubspace, checker);
    }

    private boolean isWriteOnlyOrUniquePending() {
        return this.state.store.isIndexWriteOnly(this.state.index) || this.state.store.isIndexReadableUniquePending(this.state.index);
    }

    protected void addUniquenessViolation(@Nonnull Tuple valueKey, @Nonnull Tuple primaryKey, @Nullable Tuple existingKey) {
        byte[] uniquenessKeyBytes = this.state.store.indexUniquenessViolationsSubspace(this.state.index).pack(FDBRecordStoreBase.uniquenessViolationKey(valueKey, primaryKey));
        this.state.transaction.set(uniquenessKeyBytes, existingKey == null ? new byte[]{} : existingKey.pack());
    }

    @Nonnull
    protected CompletableFuture<Void> removeUniquenessViolationsAsync(@Nonnull Tuple valueKey, @Nonnull Tuple primaryKey) {
        Subspace uniqueValueSubspace = this.state.store.indexUniquenessViolationsSubspace(this.state.index).subspace(valueKey);
        this.state.transaction.clear(uniqueValueSubspace.pack(primaryKey));
        KeyValueCursor uniquenessViolationEntries = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(uniqueValueSubspace).setContext(this.state.context)).setScanProperties(new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(2).setIsolationLevel(IsolationLevel.SERIALIZABLE).setDefaultCursorStreamingMode(CursorStreamingMode.WANT_ALL).build()))).build();
        return uniquenessViolationEntries.getCount().thenAccept(count -> {
            if (count == 1) {
                this.state.context.clear(Range.startsWith(uniqueValueSubspace.pack()));
            }
        });
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scanUniquenessViolations(@Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        Subspace uniquenessViolationsSubspace = this.state.store.indexUniquenessViolationsSubspace(this.state.index);
        KeyValueCursor keyValues = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(uniquenessViolationsSubspace).setContext(this.state.context)).setRange(range)).setContinuation(continuation)).setScanProperties(scanProperties)).build();
        return keyValues.map(kv -> this.unpackKeyValue(uniquenessViolationsSubspace, (KeyValue)kv));
    }

    @Override
    public CompletableFuture<Void> clearUniquenessViolations() {
        if (this.state.index.isUnique()) {
            throw new RecordCoreException(this.state.index.getName() + " is unique and cannot clear uniqueness violations", new Object[0]);
        }
        this.state.context.ensureActive().clear(this.state.store.indexUniquenessViolationsSubspace(this.state.index).range());
        return AsyncUtil.DONE;
    }

    @Override
    @Nonnull
    public RecordCursor<InvalidIndexEntry> validateEntries(@Nullable byte[] continuation, @Nullable ScanProperties scanProperties) {
        return RecordCursor.empty();
    }

    @Nonnull
    protected RecordCursor<InvalidIndexEntry> validateOrphanEntries(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scan(IndexScanType.BY_VALUE, TupleRange.ALL, continuation, scanProperties).filterAsync(indexEntry -> this.state.store.hasIndexEntryRecord((IndexEntry)indexEntry, IsolationLevel.SNAPSHOT).thenApply(has -> has == false), this.state.store.getPipelineSizer().getPipelineSize(PipelineOperation.INDEX_ASYNC_FILTER)).map(InvalidIndexEntry::newOrphan);
    }

    @Nonnull
    protected RecordCursor<InvalidIndexEntry> validateMissingEntries(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        Collection<RecordType> recordTypes = this.state.store.getRecordMetaData().recordTypesForIndex(this.state.index);
        FDBRecordStoreBase.PipelineSizer pipelineSizer = this.state.store.getPipelineSizer();
        return RecordCursor.flatMapPipelined(cont -> this.state.store.scanRecords(TupleRange.ALL, (byte[])cont, scanProperties).filter(rec -> recordTypes.contains(rec.getRecordType())), (record, cont) -> {
            List<IndexEntry> filteredIndexEntries = this.filteredIndexEntries((FDBIndexableRecord)record);
            return RecordCursor.fromList(filteredIndexEntries == null ? Collections.emptyList() : filteredIndexEntries.stream().map(indexEntryWithoutPrimaryKey -> new IndexEntry(indexEntryWithoutPrimaryKey.getIndex(), this.indexEntryKey(indexEntryWithoutPrimaryKey.getKey(), record.getPrimaryKey()), indexEntryWithoutPrimaryKey.getValue())).map(indexEntry -> InvalidIndexEntry.newMissing(indexEntry, record)).collect(Collectors.toList()), cont);
        }, continuation, pipelineSizer.getPipelineSize(PipelineOperation.RECORD_FUNCTION)).filterAsync(missingEntryCandidate -> {
            byte[] keyBytes = this.state.indexSubspace.pack(missingEntryCandidate.getEntry().getKey());
            return this.state.transaction.get(keyBytes).thenApply(Objects::isNull);
        }, pipelineSizer.getPipelineSize(PipelineOperation.INDEX_ASYNC_FILTER));
    }

    protected <M extends Message> void checkKeyValueSizes(@Nonnull FDBIndexableRecord<M> savedRecord, @Nonnull Tuple valueKey, @Nonnull Tuple value, @Nonnull byte[] keyBytes, @Nonnull byte[] valueBytes) {
        if (keyBytes.length > this.state.store.getKeySizeLimit()) {
            throw new FDBExceptions.FDBStoreKeySizeException("index entry is too large to be stored in FDB key", new Object[]{LogMessageKeys.PRIMARY_KEY, savedRecord.getPrimaryKey(), LogMessageKeys.VALUE_KEY, StandardIndexMaintainer.trimTooLargeTuple(valueKey), LogMessageKeys.INDEX_NAME, this.state.index.getName()});
        }
        if (valueBytes.length > this.state.store.getValueSizeLimit()) {
            throw new FDBExceptions.FDBStoreValueSizeException("index entry is too large to be stored in FDB value", new Object[]{LogMessageKeys.PRIMARY_KEY, savedRecord.getPrimaryKey(), LogMessageKeys.VALUE, StandardIndexMaintainer.trimTooLargeTuple(value), LogMessageKeys.INDEX_NAME, this.state.index.getName()});
        }
    }

    protected static String trimTooLargeTuple(@Nonnull Tuple tuple) {
        String fullString = tuple.toString();
        if (fullString.length() > 100) {
            return fullString.substring(0, 100) + "...";
        }
        return fullString;
    }

    @Nonnull
    protected Tuple indexEntryKey(@Nonnull Tuple valueKey, @Nonnull Tuple primaryKey) {
        return FDBRecordStoreBase.indexEntryKey(this.state.index, valueKey, primaryKey);
    }

    protected void saveIndexEntryAsKeyValue(IndexEntry keyValue) {
        this.state.transaction.set(this.state.indexSubspace.pack(keyValue.getKey()), keyValue.getValue().pack());
    }

    @Override
    public boolean canEvaluateRecordFunction(@Nonnull IndexRecordFunction<?> function) {
        return false;
    }

    @Override
    @Nonnull
    public <T, M extends Message> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext context, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<M> record) {
        return this.unsupportedRecordFunction(function);
    }

    @Override
    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        return false;
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        return this.unsupportedAggregateFunction(function);
    }

    protected int getGroupingCount() {
        return ((GroupingKeyExpression)this.state.index.getRootExpression()).getGroupingCount();
    }

    protected int getGroupedCount() {
        return ((GroupingKeyExpression)this.state.index.getRootExpression()).getGroupedCount();
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> addedRangeWithKey(@Nonnull Tuple primaryKey) {
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(this.state.store, this.state.index);
        return rangeSet.containsAsync(primaryKey.pack());
    }

    protected static boolean canDeleteWhere(@Nonnull IndexMaintainerState state, @Nonnull QueryToKeyMatcher.Match match, @Nonnull Key.Evaluated evaluated) {
        if (match.getType() != QueryToKeyMatcher.MatchType.EQUALITY) {
            return false;
        }
        if (evaluated.equals(match.getEquality(state.store, EvaluationContext.EMPTY))) {
            return true;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(KeyValueLogMessage.of("IndexPrefixes don't align on deleteRecordsWhere", new Object[]{LogMessageKeys.INITIAL_PREFIX, evaluated, LogMessageKeys.SECOND_PREFIX, match.getEquality(state.store, EvaluationContext.EMPTY), LogMessageKeys.INDEX_NAME, state.index.getName()}));
        }
        return false;
    }

    @Override
    public boolean canDeleteWhere(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        QueryToKeyMatcher.Match match = matcher.matchesSatisfyingQuery(this.state.index.getRootExpression());
        return StandardIndexMaintainer.canDeleteWhere(this.state, match, evaluated);
    }

    protected boolean canDeleteGroup(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        KeyExpression rootExpression = this.state.index.getRootExpression();
        if (!(rootExpression instanceof GroupingKeyExpression)) {
            return false;
        }
        QueryToKeyMatcher.Match match = matcher.matchesSatisfyingQuery(rootExpression);
        return StandardIndexMaintainer.canDeleteWhere(this.state, match, evaluated);
    }

    @Override
    public CompletableFuture<Void> deleteWhere(Transaction tr, @Nonnull Tuple prefix) {
        byte[] key = this.state.indexSubspace.pack(prefix);
        Range indexRange = new Range(key, ByteArrayUtil.strinc(key));
        this.state.context.clear(indexRange);
        return AsyncUtil.DONE;
    }

    @Override
    public CompletableFuture<IndexOperationResult> performOperation(@Nonnull IndexOperation operation) {
        throw new RecordCoreException("Unsupported index operation", new Object[]{LogMessageKeys.INDEX_NAME, this.state.index.getName(), LogMessageKeys.INDEX_OPERATION, operation.getClass().getSimpleName()});
    }

    @Override
    public <M extends Message> List<IndexEntry> evaluateIndex(@Nonnull FDBRecord<M> record) {
        KeyExpression rootExpression = this.state.index.getRootExpression();
        List<Key.Evaluated> indexKeys = rootExpression.evaluate(record);
        if (rootExpression instanceof KeyWithValueExpression) {
            KeyWithValueExpression keyWithValueExpression = (KeyWithValueExpression)rootExpression;
            return indexKeys.stream().map(key -> new IndexEntry(this.state.index, keyWithValueExpression.getKey((Key.Evaluated)key), keyWithValueExpression.getValue((Key.Evaluated)key))).collect(Collectors.toList());
        }
        return indexKeys.stream().map(key -> new IndexEntry(this.state.index, (Key.Evaluated)key)).collect(Collectors.toList());
    }

    @Nonnull
    private Tuple createRemoteFetchMapper(int commonPrimaryKeyLength) {
        int prefixLength = Tuple.fromBytes(this.state.indexSubspace.pack()).size();
        List<Integer> keyLocations = this.state.index.getEntryPrimaryKeyPositions(commonPrimaryKeyLength);
        Tuple result = Tuple.fromBytes(this.state.store.recordsSubspace().pack());
        for (int i : keyLocations) {
            result = result.add("{K[" + (i + prefixLength) + "]}");
        }
        result = result.add("{...}");
        return result;
    }

    @Override
    public CompletableFuture<Void> mergeIndex() {
        return AsyncUtil.DONE;
    }
}

