/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.map.BunchedMapMultiIterator;
import com.apple.foundationdb.map.BunchedMapScanEntry;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.BaseCursor;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.tuple.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
class TextCursor
implements BaseCursor<IndexEntry> {
    @Nonnull
    private final BunchedMapMultiIterator<Tuple, List<Integer>, Tuple> underlying;
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final Index index;
    @Nonnull
    private final CursorLimitManager limitManager;
    @Nullable
    private final FDBStoreTimer timer;
    private int limitRemaining;
    @Nullable
    private RecordCursorResult<IndexEntry> nextResult;
    private boolean closed;

    TextCursor(@Nonnull BunchedMapMultiIterator<Tuple, List<Integer>, Tuple> underlying, @Nonnull Executor executor, @Nonnull FDBRecordContext context, @Nonnull ScanProperties scanProperties, @Nonnull Index index) {
        this.underlying = underlying;
        this.executor = executor;
        this.limitManager = new CursorLimitManager(context, scanProperties);
        this.index = index;
        this.limitRemaining = scanProperties.getExecuteProperties().getReturnedRowLimitOrMax();
        this.timer = context.getTimer();
        this.closed = false;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<IndexEntry>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        if (this.limitRemaining > 0 && this.limitManager.tryRecordScan()) {
            return this.underlying.onHasNext().thenApply(hasNext -> {
                if (hasNext.booleanValue()) {
                    Object nextItem = this.underlying.next();
                    if (this.timer != null) {
                        this.timer.increment(FDBStoreTimer.Counts.LOAD_SCAN_ENTRY);
                        this.timer.increment(FDBStoreTimer.Counts.LOAD_TEXT_ENTRY);
                    }
                    Tuple k = (Tuple)((BunchedMapScanEntry)nextItem).getKey();
                    Tuple subspaceTag = (Tuple)((BunchedMapScanEntry)nextItem).getSubspaceTag();
                    if (subspaceTag != null) {
                        k = subspaceTag.addAll(k);
                    }
                    if (this.limitRemaining != Integer.MAX_VALUE) {
                        --this.limitRemaining;
                    }
                    this.nextResult = RecordCursorResult.withNextValue(new IndexEntry(this.index, k, Tuple.from(((BunchedMapScanEntry)nextItem).getValue())), this.continuationHelper());
                } else {
                    this.nextResult = RecordCursorResult.exhausted();
                }
                return this.nextResult;
            });
        }
        if (this.limitRemaining <= 0) {
            this.nextResult = RecordCursorResult.withoutNextValue(this.continuationHelper(), RecordCursor.NoNextReason.RETURN_LIMIT_REACHED);
        } else {
            Optional<RecordCursor.NoNextReason> stoppedReason = this.limitManager.getStoppedReason();
            if (!stoppedReason.isPresent()) {
                throw new RecordCoreException("limit manager stopped TextCursor but did not report a reason", new Object[0]);
            }
            this.nextResult = RecordCursorResult.withoutNextValue(this.continuationHelper(), stoppedReason.get());
        }
        return CompletableFuture.completedFuture(this.nextResult);
    }

    @Nonnull
    private RecordCursorContinuation continuationHelper() {
        return ByteArrayContinuation.fromNullable(this.underlying.getContinuation());
    }

    @Override
    public void close() {
        this.underlying.cancel();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter(this);
        return visitor.visitLeave(this);
    }
}

