/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.map.BunchedSerializationException;
import com.apple.foundationdb.map.BunchedSerializer;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TextIndexBunchedSerializer
implements BunchedSerializer<Tuple, List<Integer>> {
    private static final byte[] PREFIX = new byte[]{32};
    private static final TextIndexBunchedSerializer INSTANCE = new TextIndexBunchedSerializer();

    public static TextIndexBunchedSerializer instance() {
        return INSTANCE;
    }

    private TextIndexBunchedSerializer() {
    }

    private static int getVarIntSize(int val) {
        if (val == 0) {
            return 1;
        }
        return (32 - Integer.numberOfLeadingZeros(val) + 6) / 7;
    }

    private static int getListSize(@Nonnull List<Integer> list) {
        int sum = 0;
        int last = 0;
        for (int val : list) {
            if (val < 0 || val < last) {
                throw new BunchedSerializationException("list is not monotonically increasing non-negative integers").setValue(list);
            }
            sum += TextIndexBunchedSerializer.getVarIntSize(val - last);
            last = val;
        }
        return sum;
    }

    private static void serializeVarInt(@Nonnull ByteBuffer buffer, int val) {
        if (val == 0) {
            buffer.put((byte)0);
        } else {
            int numBytes = TextIndexBunchedSerializer.getVarIntSize(val);
            for (int i = numBytes - 1; i >= 0; --i) {
                byte nextByte = (byte)(val >> 7 * i & 0x7F | (i == 0 ? 0 : 128));
                buffer.put(nextByte);
            }
        }
    }

    private static int deserializeVarInt(@Nonnull ByteBuffer buffer) {
        byte nextByte;
        boolean done;
        int val = 0;
        do {
            nextByte = buffer.get();
            val = (val << 7) + (nextByte & 0x7F);
        } while (!(done = (nextByte & 0x80) == 0));
        return val;
    }

    private static void serializeList(@Nonnull ByteBuffer buffer, @Nonnull List<Integer> list, int serializedSize) {
        TextIndexBunchedSerializer.serializeVarInt(buffer, serializedSize);
        int last = 0;
        for (int val : list) {
            TextIndexBunchedSerializer.serializeVarInt(buffer, val - last);
            last = val;
        }
    }

    @Nonnull
    private static List<Integer> deserializeList(@Nonnull ByteBuffer buffer) {
        int serializedSize = TextIndexBunchedSerializer.deserializeVarInt(buffer);
        if (serializedSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> endList = new ArrayList<Integer>(serializedSize);
        int curPos = buffer.position();
        int last = 0;
        while (buffer.position() < curPos + serializedSize) {
            int next = TextIndexBunchedSerializer.deserializeVarInt(buffer);
            endList.add(last + next);
            last += next;
        }
        return endList;
    }

    @Override
    @Nonnull
    public byte[] serializeKey(@Nonnull Tuple key) {
        try {
            return key.pack();
        }
        catch (IllegalArgumentException e) {
            throw new BunchedSerializationException("unable to serialize key", e).setValue(key);
        }
    }

    @Override
    @Nonnull
    public byte[] serializeEntry(@Nonnull Tuple key, @Nonnull List<Integer> value) {
        try {
            byte[] serializedKey = key.pack();
            int listSize = TextIndexBunchedSerializer.getListSize(value);
            int size = TextIndexBunchedSerializer.getVarIntSize(serializedKey.length) + serializedKey.length + TextIndexBunchedSerializer.getVarIntSize(listSize) + listSize;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            TextIndexBunchedSerializer.serializeVarInt(buffer, serializedKey.length);
            buffer.put(serializedKey);
            TextIndexBunchedSerializer.serializeList(buffer, value, listSize);
            return buffer.array();
        }
        catch (RuntimeException e) {
            throw new BunchedSerializationException("unable to serialize entry", e).setValue(new AbstractMap.SimpleImmutableEntry<Tuple, List<Integer>>(key, value));
        }
    }

    @Override
    @Nonnull
    public byte[] serializeEntries(@Nonnull List<Map.Entry<Tuple, List<Integer>>> entries) {
        if (entries.isEmpty()) {
            throw new BunchedSerializationException("cannot serialize empty entry list");
        }
        try {
            int size = PREFIX.length;
            ArrayList<byte[]> serializedKeys = new ArrayList<byte[]>(entries.size() - 1);
            int[] listSizes = new int[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                int listSize;
                Map.Entry<Tuple, List<Integer>> entry = entries.get(i);
                if (i != 0) {
                    byte[] serializedKey = entry.getKey().pack();
                    size += TextIndexBunchedSerializer.getVarIntSize(serializedKey.length) + serializedKey.length;
                    serializedKeys.add(serializedKey);
                }
                listSizes[i] = listSize = TextIndexBunchedSerializer.getListSize(entry.getValue());
                size += TextIndexBunchedSerializer.getVarIntSize(listSize) + listSize;
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.put(PREFIX);
            for (int i = 0; i < entries.size(); ++i) {
                if (i != 0) {
                    byte[] key = (byte[])serializedKeys.get(i - 1);
                    TextIndexBunchedSerializer.serializeVarInt(buffer, key.length);
                    buffer.put(key);
                }
                TextIndexBunchedSerializer.serializeList(buffer, entries.get(i).getValue(), listSizes[i]);
            }
            return buffer.array();
        }
        catch (RuntimeException e) {
            throw new BunchedSerializationException("could not serialize entry list", e).setValue(entries);
        }
    }

    @Override
    @Nonnull
    public Tuple deserializeKey(@Nonnull byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new BunchedSerializationException("offset (" + offset + ") or length " + length + " out of range (" + data.length + ")").setData(data);
        }
        try {
            return Tuple.fromBytes(data, offset, length);
        }
        catch (RuntimeException e) {
            throw new BunchedSerializationException("unable to deserialize key", e).setData(Arrays.copyOfRange(data, offset, offset + length));
        }
    }

    private void checkPrefix(@Nonnull byte[] data) {
        if (!ByteArrayUtil.startsWith(data, PREFIX)) {
            throw new BunchedSerializationException("serialized data begins with incorrect prefix").setData(data);
        }
    }

    @Nonnull
    private <T> List<T> deserializeBunch(@Nonnull Tuple key, @Nonnull byte[] data, boolean deserializeValues, @Nonnull BiFunction<Tuple, List<Integer>, T> itemCreator) {
        this.checkPrefix(data);
        try {
            ArrayList<T> list = new ArrayList<T>();
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.position(PREFIX.length);
            boolean first = true;
            while (buffer.hasRemaining()) {
                List<Object> entryValue;
                Tuple entryKey;
                if (!first) {
                    int tupleSize = TextIndexBunchedSerializer.deserializeVarInt(buffer);
                    entryKey = tupleSize == 0 ? TupleHelpers.EMPTY : Tuple.fromBytes(data, buffer.position(), tupleSize);
                    buffer.position(buffer.position() + tupleSize);
                } else {
                    entryKey = key;
                    first = false;
                }
                if (deserializeValues) {
                    entryValue = TextIndexBunchedSerializer.deserializeList(buffer);
                } else {
                    entryValue = Collections.emptyList();
                    int listSize = TextIndexBunchedSerializer.deserializeVarInt(buffer);
                    buffer.position(buffer.position() + listSize);
                }
                list.add(itemCreator.apply(entryKey, entryValue));
            }
            return Collections.unmodifiableList(list);
        }
        catch (RuntimeException e) {
            throw new BunchedSerializationException("unable to deserialize entries", e).setData(data);
        }
    }

    @Override
    @Nonnull
    public List<Map.Entry<Tuple, List<Integer>>> deserializeEntries(@Nonnull Tuple key, @Nonnull byte[] data) {
        return this.deserializeBunch(key, data, true, AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    @Nonnull
    public List<Tuple> deserializeKeys(@Nonnull Tuple key, @Nonnull byte[] data) {
        return this.deserializeBunch(key, data, false, (t2, ignore) -> t2);
    }

    @Override
    public boolean canAppend() {
        return true;
    }
}

