/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.map.BunchedMap;
import com.apple.foundationdb.map.BunchedMapMultiIterator;
import com.apple.foundationdb.record.ByteScanLimiter;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.text.TextTokenizer;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerRegistry;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerRegistryImpl;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextCursor;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexBunchedSerializer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextSubspaceSplitter;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class TextIndexMaintainer
extends StandardIndexMaintainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextIndexMaintainer.class);
    private static final TextTokenizerRegistry registry = TextTokenizerRegistryImpl.instance();
    private static final int BUNCH_SIZE = 20;
    private static final BunchedMap<Tuple, List<Integer>> BUNCHED_MAP = new BunchedMap<Tuple, List<Integer>>(TextIndexBunchedSerializer.instance(), Comparator.naturalOrder(), 20);
    @Nonnull
    @VisibleForTesting
    static final Tuple TOKENIZER_VERSION_SUBSPACE_TUPLE = Tuple.from(0L);
    @Nonnull
    private final TextTokenizer tokenizer;
    private final int tokenizerVersion;
    private final boolean addAggressiveConflictRanges;
    private final boolean omitPositionLists;

    @Nonnull
    public static TextTokenizer getTokenizer(@Nonnull Index index) {
        String tokenizerName = index.getOption("textTokenizerName");
        return registry.getTokenizer(tokenizerName);
    }

    public static int getIndexTokenizerVersion(@Nonnull Index index) {
        String versionStr = index.getOption("textTokenizerVersion");
        if (versionStr != null) {
            try {
                return Integer.parseInt(versionStr);
            }
            catch (NumberFormatException e) {
                throw new MetaDataException("tokenizer version could not be parsed as int", new Object[0]).addLogInfo("index", (Object)index.getName()).addLogInfo("textTokenizerVersion", (Object)versionStr);
            }
        }
        return 0;
    }

    static boolean getIfAddAggressiveConflictRanges(@Nonnull Index index) {
        return index.getBooleanOption("textAddAggressiveConflictRanges", false);
    }

    static boolean getIfOmitPositions(@Nonnull Index index) {
        return index.getBooleanOption("textOmitPositions", false);
    }

    static int textFieldPosition(@Nonnull KeyExpression expression) {
        if (expression instanceof GroupingKeyExpression) {
            return ((GroupingKeyExpression)expression).getGroupingCount();
        }
        return 0;
    }

    @Nonnull
    static BunchedMap<Tuple, List<Integer>> getBunchedMap(@Nonnull FDBRecordContext context) {
        if (context.getTimer() != null) {
            return new InstrumentedBunchedMap<Tuple, List<Integer>>(BUNCHED_MAP, context.getTimer(), context.getExecutor());
        }
        return BUNCHED_MAP;
    }

    protected TextIndexMaintainer(@Nonnull IndexMaintainerState state) {
        super(state);
        this.tokenizer = TextIndexMaintainer.getTokenizer(state.index);
        this.tokenizerVersion = TextIndexMaintainer.getIndexTokenizerVersion(state.index);
        this.addAggressiveConflictRanges = TextIndexMaintainer.getIfAddAggressiveConflictRanges(state.index);
        this.omitPositionLists = TextIndexMaintainer.getIfOmitPositions(state.index);
    }

    private static int varIntSize(int val) {
        if (val == 0) {
            return 1;
        }
        return (32 - Integer.numberOfLeadingZeros(val) + 6) / 7;
    }

    @Nonnull
    private byte[] getRecordTokenizerKey(@Nonnull Tuple primaryKey) {
        return this.getSecondarySubspace().subspace(TOKENIZER_VERSION_SUBSPACE_TUPLE).subspace(primaryKey).pack();
    }

    @Nonnull
    private CompletableFuture<Integer> getRecordTokenizerVersion(@Nonnull Tuple primaryKey) {
        byte[] key = this.getRecordTokenizerKey(primaryKey);
        return this.state.transaction.get(key).thenApply(rawVersion -> {
            if (rawVersion == null) {
                return 0;
            }
            return (int)Tuple.fromBytes(rawVersion).getLong(0);
        });
    }

    private void writeRecordTokenizerVersion(@Nonnull Tuple primaryKey) {
        this.state.transaction.set(this.getRecordTokenizerKey(primaryKey), Tuple.from(this.tokenizerVersion).pack());
    }

    private void clearRecordTokenizerVersion(@Nonnull Tuple primaryKey) {
        this.state.transaction.clear(this.getRecordTokenizerKey(primaryKey));
    }

    @Nonnull
    private NonnullPair<Integer, Integer> estimateSize(@Nullable Tuple groupingKey, @Nonnull Map<String, List<Integer>> positionMap, @Nonnull Tuple groupedKey) {
        int idSize = groupedKey.pack().length;
        int subspaceSize = this.getIndexSubspace().getKey().length + (groupingKey != null ? groupingKey.pack().length : 0);
        int keySize = 0;
        int valueSize = 0;
        for (Map.Entry<String, List<Integer>> posting : positionMap.entrySet()) {
            keySize += subspaceSize + 2 + posting.getKey().length() + idSize;
            if (this.omitPositionLists) {
                ++valueSize;
                continue;
            }
            int listSize = posting.getValue().stream().mapToInt(TextIndexMaintainer::varIntSize).sum();
            valueSize += TextIndexMaintainer.varIntSize(idSize) + idSize + TextIndexMaintainer.varIntSize(listSize) + listSize;
        }
        return NonnullPair.of(keySize, valueSize);
    }

    @Nonnull
    private <M extends Message> CompletableFuture<Void> updateOneKeyAsync(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull IndexEntry entry, int textPosition, int recordTokenizerVersion) {
        FDBStoreTimer.Events indexUpdateEvent;
        long startTime = System.nanoTime();
        Tuple indexEntryKey = this.indexEntryKey(entry.getKey(), savedRecord.getPrimaryKey());
        String text = indexEntryKey.getString(textPosition);
        if (text == null || text.isEmpty()) {
            return AsyncUtil.DONE;
        }
        Tuple groupingKey = textPosition == 0 ? null : TupleHelpers.subTuple(indexEntryKey, 0, textPosition);
        Tuple groupedKey = TupleHelpers.subTuple(indexEntryKey, textPosition + 1, indexEntryKey.size());
        Map<String, List<Integer>> positionMap = this.tokenizer.tokenizeToMap(text, recordTokenizerVersion, TextTokenizer.TokenizerMode.INDEX);
        FDBStoreTimer.Events events = indexUpdateEvent = remove ? FDBStoreTimer.Events.DELETE_INDEX_ENTRY : FDBStoreTimer.Events.SAVE_INDEX_ENTRY;
        if (LOGGER.isDebugEnabled()) {
            NonnullPair<Integer, Integer> estimatedSize = this.estimateSize(groupingKey, positionMap, groupedKey);
            KeyValueLogMessage msg = KeyValueLogMessage.build("performed text tokenization", new Object[]{LogMessageKeys.REMOVE, remove, LogMessageKeys.TEXT_SIZE, text.length(), LogMessageKeys.UNIQUE_TOKENS, positionMap.size(), LogMessageKeys.AVG_TOKEN_SIZE, (double)positionMap.keySet().stream().mapToInt(String::length).sum() * 1.0 / (double)positionMap.size(), LogMessageKeys.MAX_TOKEN_SIZE, positionMap.keySet().stream().mapToInt(String::length).max().orElse(0), LogMessageKeys.AVG_POSITIONS, (double)positionMap.values().stream().mapToInt(List::size).sum() * 1.0 / (double)positionMap.size(), LogMessageKeys.MAX_POSITIONS, positionMap.values().stream().mapToInt(List::size).max().orElse(0), LogMessageKeys.TEXT_KEY_SIZE, estimatedSize.getKey(), LogMessageKeys.TEXT_VALUE_SIZE, estimatedSize.getValue(), LogMessageKeys.TEXT_INDEX_SIZE_AMORTIZED, (Integer)estimatedSize.getKey() / 10 + (Integer)estimatedSize.getValue(), "textTokenizerName", this.tokenizer.getName(), "textTokenizerVersion", recordTokenizerVersion, "textAddAggressiveConflictRanges", this.addAggressiveConflictRanges, LogMessageKeys.PRIMARY_KEY, savedRecord.getPrimaryKey(), LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(this.state.store.getSubspace().getKey()), LogMessageKeys.INDEX_SUBSPACE, ByteArrayUtil2.loggable(this.state.indexSubspace.getKey()), LogMessageKeys.WROTE_INDEX, true});
            LOGGER.debug(msg.toString());
        }
        if (positionMap.isEmpty()) {
            if (this.state.store.getTimer() != null) {
                this.state.store.getTimer().recordSinceNanoTime(indexUpdateEvent, startTime);
            }
            return AsyncUtil.DONE;
        }
        if (this.addAggressiveConflictRanges) {
            Range indexRange = groupingKey == null ? this.state.indexSubspace.range() : this.state.indexSubspace.range(groupingKey);
            this.state.context.ensureActive().addReadConflictRange(indexRange.begin, indexRange.end);
            this.state.context.ensureActive().addWriteConflictRange(indexRange.begin, indexRange.end);
        }
        BunchedMap<Tuple, List<Integer>> bunchedMap = TextIndexMaintainer.getBunchedMap(this.state.context);
        CompletableFuture<Void> tokenInsertFuture = RecordCursor.fromIterator(this.state.context.getExecutor(), positionMap.entrySet().iterator()).forEachAsync(tokenEntry -> {
            Tuple subspaceTuple = groupingKey == null ? Tuple.from(tokenEntry.getKey()) : groupingKey.add((String)tokenEntry.getKey());
            Subspace mapSubspace = this.state.indexSubspace.subspace(subspaceTuple);
            if (remove) {
                return bunchedMap.remove(this.state.transaction, mapSubspace, groupedKey).thenAccept(ignore -> {});
            }
            List value = this.omitPositionLists ? Collections.emptyList() : (List)tokenEntry.getValue();
            return bunchedMap.put(this.state.transaction, mapSubspace, groupedKey, value).thenAccept(ignore -> {});
        }, this.state.store.getPipelineSize(PipelineOperation.TEXT_INDEX_UPDATE));
        if (this.state.store.getTimer() != null) {
            return this.state.store.getTimer().instrument(indexUpdateEvent, tokenInsertFuture, this.state.context.getExecutor(), startTime);
        }
        return tokenInsertFuture;
    }

    @Nonnull
    private <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries, int recordTokenizerVersion) {
        if (indexEntries.isEmpty()) {
            return AsyncUtil.DONE;
        }
        int textPosition = TextIndexMaintainer.textFieldPosition(this.state.index.getRootExpression());
        if (indexEntries.size() == 1) {
            return this.updateOneKeyAsync(savedRecord, remove, indexEntries.get(0), textPosition, recordTokenizerVersion);
        }
        AtomicInteger pos = new AtomicInteger(0);
        return AsyncUtil.whileTrue(() -> this.updateOneKeyAsync(savedRecord, remove, (IndexEntry)indexEntries.get(pos.getAndIncrement()), textPosition, recordTokenizerVersion).thenApply(ignore -> pos.get() < indexEntries.size()), this.state.store.getExecutor());
    }

    @Override
    @Nonnull
    protected <M extends Message> CompletableFuture<Void> updateIndexKeys(@Nonnull FDBIndexableRecord<M> savedRecord, boolean remove, @Nonnull List<IndexEntry> indexEntries) {
        if (indexEntries.isEmpty()) {
            return AsyncUtil.DONE;
        }
        if (remove) {
            return this.getRecordTokenizerVersion(savedRecord.getPrimaryKey()).thenCompose(recordTokenizerVersion -> this.updateIndexKeys(savedRecord, true, indexEntries, (int)recordTokenizerVersion));
        }
        return this.updateIndexKeys(savedRecord, false, indexEntries, this.tokenizerVersion);
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Void> update(final @Nullable FDBIndexableRecord<M> oldRecord, final @Nullable FDBIndexableRecord<M> newRecord) {
        if (oldRecord == null && newRecord != null) {
            this.writeRecordTokenizerVersion(newRecord.getPrimaryKey());
            return super.update(null, newRecord);
        }
        if (oldRecord != null && newRecord == null) {
            return super.update(oldRecord, null).thenRun(new Runnable(){

                @Override
                @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/552")
                public void run() {
                    TextIndexMaintainer.this.clearRecordTokenizerVersion(oldRecord.getPrimaryKey());
                }
            });
        }
        if (oldRecord != null) {
            return this.getRecordTokenizerVersion(oldRecord.getPrimaryKey()).thenCompose(recordTokenizerVersion -> {
                if (recordTokenizerVersion == this.tokenizerVersion) {
                    return super.update(oldRecord, newRecord);
                }
                return super.update(oldRecord, null).thenCompose(new Function<Void, CompletionStage<Void>>(){

                    @Override
                    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/552")
                    public CompletionStage<Void> apply(Void vignore) {
                        TextIndexMaintainer.this.writeRecordTokenizerVersion(newRecord.getPrimaryKey());
                        return TextIndexMaintainer.super.update(null, newRecord);
                    }
                });
            });
        }
        return AsyncUtil.DONE;
    }

    @Override
    public boolean canDeleteWhere(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        return this.canDeleteGroup(matcher, evaluated);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!scanType.equals(IndexScanType.BY_TEXT_TOKEN)) {
            throw new RecordCoreException("Can only scan text index by text token.", new Object[0]);
        }
        int textPosition = TextIndexMaintainer.textFieldPosition(this.state.index.getRootExpression());
        TextSubspaceSplitter subspaceSplitter = new TextSubspaceSplitter(this.state.indexSubspace, textPosition + 1);
        Range byteRange = range.toRange();
        ScanProperties withAdjustedLimit = scanProperties.with(ExecuteProperties::clearSkipAndAdjustLimit);
        ExecuteProperties adjustedExecuteProperties = withAdjustedLimit.getExecuteProperties();
        ByteScanLimiter byteScanLimiter = adjustedExecuteProperties.getState().getByteScanLimiter();
        Consumer<KeyValue> callback = keyValue -> byteScanLimiter.registerScannedBytes(keyValue.getKey().length + keyValue.getValue().length);
        BunchedMapMultiIterator<Tuple, List<Integer>, Tuple> iterator = TextIndexMaintainer.getBunchedMap(this.state.context).scanMulti(this.state.context.readTransaction(adjustedExecuteProperties.getIsolationLevel().isSnapshot()), this.state.indexSubspace, subspaceSplitter, byteRange.begin, byteRange.end, continuation, adjustedExecuteProperties.getReturnedRowLimit(), callback, scanProperties.isReverse());
        RecordCursor<IndexEntry> cursor = new TextCursor(iterator, this.state.store.getExecutor(), this.state.context, withAdjustedLimit, this.state.index);
        if (scanProperties.getExecuteProperties().getSkip() != 0) {
            cursor = cursor.skip(scanProperties.getExecuteProperties().getSkip());
        }
        return cursor;
    }

    private static class InstrumentedBunchedMap<K, V>
    extends BunchedMap<K, V> {
        @Nonnull
        private final FDBStoreTimer timer;
        @Nonnull
        private final Executor executor;

        public InstrumentedBunchedMap(@Nonnull BunchedMap<K, V> model, @Nonnull FDBStoreTimer timer, @Nonnull Executor executor) {
            super(model);
            this.timer = timer;
            this.executor = executor;
        }

        @Override
        protected void instrumentDelete(@Nonnull byte[] key, @Nullable byte[] oldValue) {
            this.timer.increment(FDBStoreTimer.Counts.DELETE_INDEX_KEY);
            this.timer.increment(FDBStoreTimer.Counts.DELETE_INDEX_KEY_BYTES, key.length);
            if (oldValue != null) {
                this.timer.increment(FDBStoreTimer.Counts.DELETE_INDEX_VALUE_BYTES, oldValue.length);
            }
        }

        @Override
        protected void instrumentWrite(@Nonnull byte[] key, @Nonnull byte[] value, @Nullable byte[] oldValue) {
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_KEY);
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_KEY_BYTES, key.length);
            this.timer.increment(FDBStoreTimer.Counts.SAVE_INDEX_VALUE_BYTES, value.length);
            if (oldValue != null) {
                this.timer.increment(FDBStoreTimer.Counts.DELETE_INDEX_VALUE_BYTES, oldValue.length);
            }
        }

        @Override
        @Nonnull
        protected CompletableFuture<List<KeyValue>> instrumentRangeRead(@Nonnull CompletableFuture<List<KeyValue>> readFuture) {
            return this.timer.instrument(FDBStoreTimer.Events.SCAN_INDEX_KEYS, readFuture, this.executor).whenComplete((list, err) -> {
                if (list != null && !list.isEmpty()) {
                    int keyBytes = 0;
                    int valueBytes = 0;
                    for (KeyValue kv : list) {
                        keyBytes += kv.getKey().length;
                        valueBytes += kv.getValue().length;
                    }
                    this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_KEY, list.size());
                    this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_KEY_BYTES, keyBytes);
                    this.timer.increment(FDBStoreTimer.Counts.LOAD_INDEX_VALUE_BYTES, valueBytes);
                }
            });
        }
    }
}

