/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb.indexes;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.MetaDataValidator;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.text.TextTokenizer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexMaintainer;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TextIndexMaintainerFactory
implements IndexMaintainerFactory {
    @Nonnull
    private static final List<String> TYPES = Collections.singletonList("text");
    @Nonnull
    private static final Set<String> TEXT_OPTIONS = ImmutableSet.of("textTokenizerName", "textTokenizerVersion", "textOmitPositions", "textAddAggressiveConflictRanges");

    @Override
    @Nonnull
    public Iterable<String> getIndexTypes() {
        return TYPES;
    }

    @Override
    @Nonnull
    public IndexValidator getIndexValidator(Index index) {
        return new IndexValidator(index){

            @Override
            public void validate(@Nonnull MetaDataValidator metaDataValidator) {
                super.validate(metaDataValidator);
                this.validateNotVersion();
                this.validateNotUnique();
                this.validateNoValue();
                TextTokenizer tokenizer = TextIndexMaintainer.getTokenizer(this.index);
                int tokenizerVersion = TextIndexMaintainer.getIndexTokenizerVersion(this.index);
                tokenizer.validateVersion(tokenizerVersion);
            }

            @Override
            public void validateIndexForRecordType(@Nonnull RecordType recordType, @Nonnull MetaDataValidator metaDataValidator) {
                List<Descriptors.FieldDescriptor> fields = metaDataValidator.validateIndexForRecordType(this.index, recordType);
                int textFieldPosition = TextIndexMaintainer.textFieldPosition(this.index.getRootExpression());
                if (textFieldPosition > fields.size()) {
                    throw new KeyExpression.InvalidExpressionException("text index does not have text field after grouped fields");
                }
                Descriptors.FieldDescriptor textFieldDescriptor = fields.get(textFieldPosition);
                if (!textFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.STRING)) {
                    throw new KeyExpression.InvalidExpressionException("text index has non-string type as text field").addLogInfo(new Object[]{LogMessageKeys.EXPECTED_TYPE, Descriptors.FieldDescriptor.Type.STRING}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL_TYPE, textFieldDescriptor.getLiteJavaType()});
                }
                if (textFieldDescriptor.isRepeated()) {
                    throw new KeyExpression.InvalidExpressionException("text index does not allow a repeated field for text body");
                }
            }

            @Override
            protected void validateChangedOptions(@Nonnull Index oldIndex, @Nonnull Set<String> changedOptions) {
                Iterator<String> iterator = changedOptions.iterator();
                block11: while (iterator.hasNext()) {
                    String changedOption;
                    switch (changedOption = iterator.next()) {
                        case "textAddAggressiveConflictRanges": 
                        case "textOmitPositions": {
                            continue block11;
                        }
                        case "textTokenizerName": {
                            String newTokenizerName;
                            String oldTokenizerName = TextIndexMaintainer.getTokenizer(oldIndex).getName();
                            if (oldTokenizerName.equals(newTokenizerName = TextIndexMaintainer.getTokenizer(this.index).getName())) continue block11;
                            throw new MetaDataException("text tokenizer changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
                        }
                        case "textTokenizerVersion": {
                            int newTokenizerVersion;
                            int oldTokenizerVersion = TextIndexMaintainer.getIndexTokenizerVersion(oldIndex);
                            if (oldTokenizerVersion <= (newTokenizerVersion = TextIndexMaintainer.getIndexTokenizerVersion(this.index))) continue block11;
                            throw new MetaDataException("text tokenizer version downgraded", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.OLD_VERSION, oldTokenizerVersion, LogMessageKeys.NEW_VERSION, newTokenizerVersion});
                        }
                    }
                    if (!TEXT_OPTIONS.contains(changedOption)) continue;
                    throw new MetaDataException("index option changed", new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_OPTION, changedOption, LogMessageKeys.OLD_OPTION, oldIndex.getOption(changedOption), LogMessageKeys.NEW_OPTION, this.index.getOption(changedOption)});
                }
                changedOptions.removeAll(TEXT_OPTIONS);
                super.validateChangedOptions(oldIndex, changedOptions);
            }
        };
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new TextIndexMaintainer(state);
    }
}

